#ifndef _DOCKING_H_
#define _DOCKING_H_

#include <stdio.h>
#include <qapp.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <qpopmenu.h>
#include <qpoint.h>


#define BACK 0
#define WAIT 0
#define PLAY 1

class DockWidget : public QWidget {

  Q_OBJECT

public:
  DockWidget(const char *name=0);
  ~DockWidget();

protected:
  void paintEvent(QPaintEvent *e);

private slots:
  void timerCall();
  void timeclick();
  void toggle_window_state();
  void mousePressEvent(QMouseEvent *e);

public slots:
  void dock();
  void undock();
  void paintIcon( int Nr );
  void playPressed();
  void stopPressed();
  void nextPressed();
  void prevPressed();
  void exitPressed();

public:
  const bool isDocked();
  //void SaveKmp3Position();
  int stat;

private:
  bool docked;
  bool background;
  int toggleID;
  int pos_x;
  int pos_y;
  int prevKmp3Desk;
  bool bMadeVisible;
  QPopupMenu *popup_m;
  //bool have_kmp3_position;
  QPixmap idle_pixmap, playing_pixmap, paused_pixmap, error_pixmap;
  QTimer *timed;

};

#endif



