#include "fileSelector.h"
#include <qpainter.h>

//
// CLASS fileLBI
//
void fileLBI::paint( QPainter *p ) 
{
  p->drawPixmap( 3, 0, *pm );
  QFontMetrics fm = p->fontMetrics();
  int yPos;                             // vertical text position
  if ( pm->height() < fm.height() ) 
    yPos = fm.ascent() + fm.leading()/2;
  else 
    yPos = pm->height()/2 - fm.height()/2 + fm.ascent(); 
  p->drawText( pm->width() + 5, yPos, text() );
}      

int fileLBI::height(const QListBox *lb ) const
{   
  return QMAX( pm->height(), lb->fontMetrics().lineSpacing() + 1 );   
}

int fileLBI::width(const QListBox *lb ) const  
{ 
  return pm->width() + lb->fontMetrics().width( text() ) + 6;
}

//
// CLASS fileSelector
//
fileSelector::fileSelector(bool s, QDir::SortSpec sorting,
			   QWidget *parent, const char *name)
  :QListBox(parent, name), KFileInfoContents(s,sorting) 
{
  setBackgroundMode( PaletteBase );   
  setMultiSelection(true);
  connect(this, SIGNAL(selected(int)), this, SLOT(sel(int)));
  connect(this, SIGNAL(selectionChanged ()), this, SLOT(newSelec()));
}

fileSelector::~fileSelector() 
{
}

void fileSelector::setAutoUpdate( bool f ) 
{
  QListBox::setAutoUpdate(f);
}

bool fileSelector::insertItem(const KFileInfo *i, int index)
{
  fileLBI * item = 0;
  if (i->isDir()) {
    if (i->isReadable())
      item = new fileLBI( i->fileName(), folder_pixmap);
    else
      item = new fileLBI( i->fileName(), locked_folder);
  }
  else {
    if (i->isReadable())
      item = new fileLBI( i->fileName(), file_pixmap);
    else
      item = new fileLBI( i->fileName(), locked_file);
  }
  
  if(!item) return false;

  QListBox::insertItem( item, index );
  return true;
}


void fileSelector::highlightItem( unsigned int index )
{
  QListBox::setCurrentItem(index);
}

void fileSelector::newSelec ()
{
  emit newSelection();
  for(int i= 0; i < (int)QListBox::count(); i++)
      if(QListBox::isSelected(i)) emit highlight(i);
}

//#include "fileSelector.moc"
