// -*- c++ -*-
#ifndef FILESELECTOR_H
#define FILESELECTOR_H

#include <qlistbox.h>
#include <qpixmap.h>
#include "kfileinfocontents.h"

class fileLBI : public QListBoxItem {
public:
  fileLBI( const char *s, QPixmap * p )
    : QListBoxItem(), pm(p) 
    { setText( s ); }
protected: 
  virtual void paint( QPainter * );
  virtual int height( const QListBox * ) const;
  virtual int width( const QListBox * ) const; 
  virtual const QPixmap *pixmap() { return pm; }
private:
  QPixmap * pm; 
};

class fileSelector : public QListBox, public KFileInfoContents {
  Q_OBJECT

public:
  fileSelector(bool s, QDir::SortSpec sorting, QWidget *parent, 
	       const char *name);
  virtual ~fileSelector();

  virtual QWidget *widget() { return this; }
  virtual void setAutoUpdate(bool f);
  virtual void clear() { KFileInfoContents::clear(); }
    
  virtual bool acceptsFiles() { return true; }
  virtual bool acceptsDirs() { return true; }

signals:
  void	newSelection();

protected:
  virtual bool insertItem(const KFileInfo *i, int index);
  virtual void clearView() { QListBox::clear(); }
  virtual void highlightItem (unsigned int index);

protected slots:
  void sel (int index)   { setSelected (index, false); select(index); }
  void newSelec ();
};

#endif // FILESELECTOR_H
