// -*- c++ -*-
#ifndef _KMP3_H
#define _KMP3_H

#include <qapp.h>
#include <qdialog.h>
#include <qpushbt.h>
#include <qslider.h>
#include <qcolor.h>
#include <qmessagebox.h>
#include <qpalette.h>
#include <qtooltip.h>
#include <qbitmap.h>
#include <qtabdlg.h>
#include <qgrpbox.h>
#include <qpixmap.h>
#include <qmsgbox.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
// Added by SMF
#include "playlist.h"
#include "musicBrowser.h"
#include "QScrLabel.h"
#include <qstring.h>

#include <kapp.h>
#include <klocale.h>
#include <ktopwidget.h>
#include <drag.h>

#include "player.h"
#include "bwlednum.h"
#include "tagEditor.h"

#define PLAYLIST_WIDTH  551
#define PLAYLIST_HEIGHT 441

#define APP_NAME "kmp3"

struct cfg_struct{
	QColor  led_color;
	QColor  background_color;
	QString LastFile,
		line[3];		// Added by SMF

	int     buffers,
		volume,
		step;

	bool 	stereo,
		mixdown,
		stripname,
		stripend,
		tooltips,
		loadLast,
		docking,
	 	fuzzy,
	 	sensitive,
	 	autoStart,
	 	autoStartCMD,
	        startShuffle;
        int     startLoop;

	bool 	pl_hidden,      // Added by SMF (12/22/98) for Playlist Editor
	        pl_path,        // configuration
	        pl_m3u;
};


class kmp3: public QDialog {
	Q_OBJECT

public:
	kmp3( QWidget *parent = 0, const char *name = 0 );
	QPixmap folder_pixmap;
	QPixmap file_pixmap;
	QPixmap cdup_pixmap;

	Player *plr;

public slots:
	void setColors();
	void setVolume( int volume );
	void logoPressed();
	void ejectPressed();
	void infoPressed();
	void powerPressed();
	void shufflePressed();
	void configPressed();
	void playPressed();
	void stopPressed();
	void nextPressed();
	void prevPressed();
	void repeatPressed();
	void setPlayer();
	void updateTime();
	void updateSong();
	QString getHomeDir();
	void makedirs();
	void setStatus( int status );
        void showError( int Nr ); 
	
private slots:
        void drop( KDNDDropZone *zone);
	void playerReady();

private:
	QPushButton *logoPB;
	QPushButton *ejectPB;
	QPushButton *infoPB;
	QPushButton *powerPB;
	QPushButton *blankPB;
	QWidget     *blankBar;
	QPushButton *shufflePB;
	QPushButton *configPB;
	QPushButton *prevPB;
	QPushButton *nextPB;
	QPushButton *forwPB;
	QPushButton *backPB;
	QPushButton *stopPB;
	QPushButton *repeatPB;
	QPushButton *playPB;
	KConfig *config;   
	QSlider *volSB;
	QFrame *backdrop;
	QColorGroup colgrp;	

	PlaylistDialog *playlistdlg;
	musicBrowser *mb;
	BW_LED_Number *trackTimeLED[6];

	// Added by SMF
        TagEditor *     tag;

	int errorFlag;

	QLabel *statusLabel;
	QLabel *volumeLabel;
	QLabel *timeLabel;
	QLabel *trackLabel;
	QLabel *bitrateLabel;
	QLabel *freqLabel;
	QTimer *checkPlayer;

	// Modified by SMF
	QScrLabel *titleLabel;
	QScrLabel *artistLabel;

	QLabel *repeatLED;
	QLabel *repeat1LED;
        QLabel *shuffleLED;

	void drawPanel();
	void setDocking();
	void showConfigBox();
	void setToolTips();
	void readSettings();
	void writeSettings();
	void setLEDs(QString symbols);
	void stripNames( char *to, char *from );
	void stripExtension( char *from );
	void writeBool( const char text[], bool value );
	// Added by SMF
	void makeLine(QString & toMake, int lineNum);
	void reinitializePlayer();

	QPushButton *makeButton( int x, int y, int w, int h );
        bool allreadySet;
        KDNDDropZone * DropZone;

protected:
	void closeEvent( QCloseEvent *e );
};

#endif
