#include "kmp3.h"
#include<iostream.h>
#include<string.h>
#include<ctype.h>
#include<kapp.h>
#include<klocale.h>

#include "musicBrowser.h"
#include "player.h"

#include "bitmaps/play.xbm"
#include "bitmaps/stop.xbm"
#include "bitmaps/nexttrk.xbm"
#include "bitmaps/prevtrk.xbm"
#include "bitmaps/delete.xbm"

extern QStrList  *playlist;
extern kmp3 *k;
extern QApplication *a;
extern cfg_struct cfgData;

#define MAXLEN 31

musicBrowser::musicBrowser(QWidget *parent = 0, const char *name = 0)
        :QTabDialog( parent, name, TRUE)
{
  setStyle(WindowsStyle);
  setCaption( klocale->translate("KMP3 Music Browser") );

  allreadyStarted= false;
  currentIndex= 0;

  playBmp= new QBitmap( play_width, play_height, play_bits, true );
  stopBmp= new QBitmap( stop_width, stop_height, stop_bits, true );
  nextBmp= new QBitmap( nexttrk_width, nexttrk_height, nexttrk_bits, true );
  prevBmp= new QBitmap( prevtrk_width, prevtrk_height, prevtrk_bits, true );
  delBmp=  new QBitmap( delete_width, delete_height, delete_bits, true );

  clearPB= new QPushButton( klocale->translate( "Reset" ), this );

  search = new QWidget( this, "SearchPage" );
  showSearch();
  addTab( search , klocale->translate("Search"));

  results= new QWidget( this, "ResultPage" );
  showResults();
  addTab( results , klocale->translate("Results"));

  foundList= new int[ playlist->count() ];

  setOkButton( klocale->translate( "Close" ) );
  setMinimumSize(520,380);

  connect( artistBox, SIGNAL( textChanged( const char * ) ),
	   SLOT( artistChanged( const char * ) ) );
  connect( titleBox, SIGNAL( textChanged( const char * ) ),
	   SLOT( titleChanged( const char * ) ) );
  connect( albumBox, SIGNAL( textChanged( const char * ) ),
	   SLOT( albumChanged( const char * ) ) );
  connect( yearBox, SIGNAL( textChanged( const char * ) ),
	   SLOT( yearChanged( const char * ) ) );
  connect( commentBox, SIGNAL( textChanged( const char * ) ),
	   SLOT( commentChanged( const char * ) ) );
  connect( genreBox, SIGNAL( activated( int ) ),
	   SLOT( genreChanged( int ) ) );

  connect( nextPB, SIGNAL( clicked() ),
           SLOT( nextSong() ) );
  connect( prevPB, SIGNAL( clicked() ),
           SLOT( prevSong() ) );
  connect( playPB, SIGNAL( clicked() ),
           SLOT( playSong() ) );
  connect( stopPB, SIGNAL( clicked() ),
           SLOT( stopSong() ) );
  connect( delPB, SIGNAL( clicked() ),
	   SLOT( delClicked() ) );

  connect( clearPB, SIGNAL( clicked() ),
	   SLOT( clearPressed() ) );
  connect( this, SIGNAL( selected( const char* ) ),
	   SLOT( tabChanged( const char*)));
  connect( foundBox, SIGNAL( highlighted( const char * ) ),
           SLOT( updateTag( const char * ) ) );
  connect( foundBox, SIGNAL( selected( int ) ),
           SLOT( itemClicked( int ) ) );
}


musicBrowser::~musicBrowser(){
  delete foundList;
}


void musicBrowser::resizeEvent(QResizeEvent *ev){
  QDialog::resizeEvent(ev);
  int w = width();
  int h = height();

  clearPB->setGeometry( 7, h-31 ,80,26);
  foundBox->setGeometry( 275, 28, w-300, h-130 );
  progrLB->setGeometry( 10, h-122, 260, 20 );
  progrBar->setGeometry( 10, h-102, 260, 20 );
  playPB->setGeometry( w-85, h-100, 30, 18 );
  stopPB->setGeometry( w-115, h-100,30, 18 );
  nextPB->setGeometry( w-55, h-100, 30, 18 );
  prevPB->setGeometry( w-145, h-100, 30, 18 );
  delPB->setGeometry( 275, h-100, 30, 18 );
}


void musicBrowser::showResults(){
  foundBox= new QListBox( results, "foundBox" );

  foundLB= new QLabel( klocale->translate( "Results:" ), results );
  foundLB->setGeometry( 275, 2, 240, 25 );
 
  titleLB= new QLabel( klocale->translate( "Title:" ), results );
  titleLB->setGeometry( 10, 2, 260, 25 );
  titleLB->setFont( QFont("times",12,QFont::Bold) );
  titleRS= new QLabel( results, "TitleResult" );
  titleRS->setGeometry( 10, 20, 260, 25 );

  artistLB= new QLabel( klocale->translate( "Artist:" ), results );
  artistLB->setGeometry( 10, 42, 260, 25 );
  artistLB->setFont( QFont("times",12,QFont::Bold) );
  artistRS= new QLabel( results, "artistResult" );
  artistRS->setGeometry( 10, 60, 260, 25 );
                         
  albumLB= new QLabel( klocale->translate( "Album:" ), results );
  albumLB->setGeometry( 10, 82, 260, 25 );
  albumLB->setFont( QFont("times",12,QFont::Bold) );
  albumRS= new QLabel( results, "albumResult" );
  albumRS->setGeometry( 10, 100, 260, 25 );
                          
  yearLB= new QLabel( klocale->translate( "Year:" ), results );
  yearLB->setGeometry( 10, 122, 100, 25 );
  yearLB->setFont( QFont("times",12,QFont::Bold) );
  yearRS= new QLabel( results, "yearResult" ); 
  yearRS->setGeometry( 10, 140, 100, 25 );  

  genreLB= new QLabel( klocale->translate( "Genre:" ), results );
  genreLB->setGeometry( 130, 122, 130, 25 );
  genreLB->setFont( QFont("times",12,QFont::Bold) );
  genreRS= new QLabel( results, "genreResult" );
  genreRS->setGeometry( 130, 140, 130, 25 );

  commentLB= new QLabel( klocale->translate( "Comment:" ), results );
  commentLB->setGeometry( 10, 162, 260, 25 );
  commentLB->setFont( QFont("times",12,QFont::Bold) );
  commentRS= new QLabel( results, "commentResult" ); 
  commentRS->setGeometry( 10, 180, 260, 25 );

  progrLB= new QLabel( klocale->translate( "Search progress:" ), results ); 
  progrBar= new QProgressBar( results, "progressBar" );

  playPB = new QPushButton( results );
  playPB->setPixmap( *playBmp );

  stopPB = new QPushButton( results );
  stopPB->setPixmap( *stopBmp );

  nextPB = new QPushButton( results );
  nextPB->setPixmap( *nextBmp );

  prevPB = new QPushButton( results );
  prevPB->setPixmap( *prevBmp );

  delPB  = new QPushButton( results );
  delPB->setPixmap( *delBmp );
}


void musicBrowser::showSearch(){
  int i;

  titleCB = new QCheckBox(klocale->translate("Title"), search);
  titleCB->setGeometry(15,10,100,25);
  titleBox= new QLineEdit( search, "titleBox" );
  titleBox->setGeometry(105,10,345,25);
  titleBox->setMaxLength(30);

  artistCB = new QCheckBox(klocale->translate("Artist"), search);
  artistCB->setGeometry(15,50,100,25);
  artistBox = new QLineEdit(search,"artistBox");
  artistBox->setGeometry(105,50,345,25);
  artistBox->setMaxLength(30);

  albumCB = new QCheckBox(klocale->translate("Album"), search);
  albumCB->setGeometry(15,90,100,25);
  albumBox = new QLineEdit(search,"albumBox");
  albumBox->setGeometry(105,90,345,25);
  albumBox->setMaxLength(30);

  yearCB = new QCheckBox(klocale->translate("Year"), search);
  yearCB->setGeometry(15,130,100,25);
  yearBox = new QLineEdit(search,"yearBox");
  yearBox->setGeometry(105,130,60,25);
  yearBox->setMaxLength(4);

  genreCB = new QCheckBox(klocale->translate("Genre"), search);
  genreCB->setGeometry(15,170,100,25);
  genreBox = new QComboBox(FALSE, search, "genreBox");
  genreBox->setGeometry(105,170,150,25); 

  for(i=0;i<= Tag::genre_largest;i++)
    genreBox->insertItem(Tag::genres[i],i);

  commentCB = new QCheckBox(klocale->translate("Comment"), search);
  commentCB->setGeometry(15,210,100,25);
  commentBox = new QLineEdit(search,"commentBox");
  commentBox->setGeometry(105,210,345,25);
  commentBox->setMaxLength(30); 
}


void musicBrowser::artistChanged( const char * ){
  artistCB->setChecked( true );
}


void musicBrowser::titleChanged( const char * ){
  titleCB->setChecked( true );
}


void musicBrowser::albumChanged( const char * ){
  albumCB->setChecked( true );
}


void musicBrowser::yearChanged( const char * ){
  yearCB->setChecked( true );
}


void musicBrowser::commentChanged( const char * ){
  commentCB->setChecked( true );
}


void musicBrowser::genreChanged( int index ){
  genreCB->setChecked( true );
}


void musicBrowser::clearPressed(){
  artistBox->clear();
  artistCB->setChecked( false );

  titleBox->clear();
  titleCB->setChecked( false );

  albumBox->clear();
  albumCB->setChecked( false );

  yearBox->clear();
  yearCB->setChecked( false );

  commentBox->clear();
  commentCB->setChecked( false );

  genreBox->setCurrentItem( 0 );
  genreCB->setChecked( false );
}


void musicBrowser::delClicked(){
  unsigned i;

  if( foundBox->count() ){
    for( i= foundBox->currentItem(); i < (foundBox->count()-1); i++ )
      foundList[i]= foundList[i+1];
    foundBox->removeItem( foundBox->currentItem() );
  }
}


void musicBrowser::tabChanged( const char *label ){
  if( !strcmp( klocale->translate("Results"), label ) ){
    titleRS->setText("-");
    artistRS->setText("-");
    genreRS->setText("-");
    albumRS->setText("-");
    commentRS->setText("-");
    yearRS->setText("-");
    clearPB->setEnabled( false );
    foundBox->clear();  

    if( titleCB->isChecked()   ||
        artistCB->isChecked()  ||
        albumCB->isChecked()  ||
        commentCB->isChecked() ||
        yearCB->isChecked()    ||
        genreCB->isChecked() ){
    
      QApplication::setOverrideCursor( waitCursor );
      a->processEvents();
      searchIt();
      QApplication::restoreOverrideCursor();
    }
  }
  else{
      clearPB->setEnabled( true );
  }
}


int musicBrowser::getLevel( const char *text ){
  int k= 0;
  unsigned i;

  for( i= 0; i < strlen( text ); i++ ){
    if( text[i] == '*' || text[i] == '?' )
      k++;
  }

  k= ( strlen( text ) - k ) / 2 ;
  return ( k > 3 ? 3 : ( k > 0 ? k : 0 ) );
}


int musicBrowser::compare( const char *s1, const char *s2 ){
  int l;
  char mode= ' ';

  l= getLevel( s2 );
  if( fuzzy ){
    if( sensitive ) mode= '+';
    return (WLD( (char *)s1, (char *)s2, mode, l ) < ( step*2+1 ) );
  }
  else{
    if( !sensitive ){
      return (strcasecmp( s1, s2 ) == 0);
    }
    else{
      return (strcmp( s1, s2 ) == 0);
    }
  }
}

void musicBrowser::searchIt(){
  int j=0, found, flag= 0;
  unsigned i;
  FILE *f;

  progrBar->setTotalSteps( playlist->count() );
  if( titleCB->isChecked() ) flag++;
  if( artistCB->isChecked() ) flag++;
  if( commentCB->isChecked() ) flag++;
  if( genreCB->isChecked() ) flag++;
  if( yearCB->isChecked() ) flag++;
  if( albumCB->isChecked() ) flag++;

  for( i= 0; i < playlist->count(); i++ ){
    found= 0;
    f= fopen( playlist->at( i ), "r" );  
    progrBar->setProgress( i );
 
    if( f ){

      if( fileTag.get( f ) ){

        if( artistCB->isChecked() ){
	  if( compare( fileTag.getArtist(), artistBox->text() ) )
            found++;	  
	}
        if( titleCB->isChecked() ){
          if( compare( fileTag.getTitle(), titleBox->text() ) )
            found++;
        }
        if( commentCB->isChecked() ){
          if( compare( fileTag.getComment(), commentBox->text() ) )
            found++;
        }
        if( albumCB->isChecked() ){
          if( compare( fileTag.getAlbum(), albumBox->text() ) )
            found++;
        }
        if( yearCB->isChecked() )
          if( !strcmp( fileTag.getYear(), yearBox->text() ) )
            found++;

        if( genreCB->isChecked() )
	  if( !strcmp( fileTag.getGenre(), genreBox->currentText() ) )
            found++;
      }

      if( found == flag ){
        foundBox->insertItem( playlist->at( i ) );
        foundList[ j++ ]= i;
      }
      fclose( f );
    }
  }
  progrBar->setProgress( playlist->count() );

  if( j )
    foundBox->setCurrentItem( 0 );  
}

void musicBrowser::itemClicked( int index ){
  currentIndex= index;
  allreadyStarted= true;
  k->plr->setBrowserMode( true );
  k->plr->setIndex( foundList[ index ] );
  k->plr->play();
}


void musicBrowser::playSong(){
  k->plr->setBrowserMode( true );
  currentIndex= foundBox->currentItem();
  allreadyStarted= true;
  k->plr->setIndex( foundList[ currentIndex ] );
  k->plr->play();
}


void musicBrowser::stopSong(){
  allreadyStarted= false;
  k->plr->stop();
}

void musicBrowser::nextSong(){
  if( this->isVisible() ){
    if( currentIndex < (foundBox->count()-1) ){
      currentIndex++;
      if( allreadyStarted ){
        k->plr->setIndex( foundList[ currentIndex ] );
        k->plr->play();
      }
    }
    else{
      currentIndex= 0;
      k->plr->stop();
    }
    foundBox->setCurrentItem( currentIndex );
  }
}

void musicBrowser::prevSong(){
  if( this->isVisible() ){
    if( currentIndex > 0 ){
      currentIndex--;
      if( allreadyStarted ){
        k->plr->setIndex( foundList[ currentIndex ] );
        k->plr->play();
      }
    }
    foundBox->setCurrentItem( currentIndex );
  }
}


void musicBrowser::updateTag( const char *selectedText ){
  FILE *f;

  f= fopen( selectedText, "r" );

  if( f ){
    if( fileTag.get( f ) ){
      artistRS->setText( fileTag.getArtist() );
      titleRS->setText( fileTag.getTitle() );
      albumRS->setText( fileTag.getAlbum() );
      yearRS->setText( fileTag.getYear() );
      genreRS->setText( fileTag.getGenre() );
      commentRS->setText( fileTag.getComment() );
    }
  }

  fclose( f );
}


void musicBrowser::setFuzzy( bool value ){
  fuzzy= value;
}


void musicBrowser::setSensitive( bool value ){
  sensitive= value;
}


void musicBrowser::setStep( int value ){
  step= value;
}


int musicBrowser::formatting( char dest[], char source[], int n, char mode ){
  int i= 0, k= 0;
  char c;

  while( (c = source[i++] ) !=0 && k < n-1 ){
    if( isupper( c ) || isdigit( c ) ){
      dest[k++] = c;
    }
    else
      if( islower( c ) ){
        dest[k++]= c - 'a'+'A';
      }
      else{
        if( mode == '*' && c != '?' ){
          if( k == 0 || dest[k-1] != '*' )
            dest[k++]= '*';
        }
        else
          dest[k++]= c;
      }  
  }
  dest[k]= 0;
  return k;
}


int musicBrowser::WLD( char *s1, char *s2, char mode, int limit ){
  register int spmin, p, q, r, lm, lw, d1, d2, i, k, x1, x2, x3;
  char c, mm[MAXLEN], ww[MAXLEN];
  int d[MAXLEN];

  if( mode == '+' || mode == '*' ){
    lw= formatting( ww, s1, MAXLEN, mode );
    lm= formatting( mm, s2, MAXLEN, mode );

    if( mode == '*' && lw < lm-1 && strchr( ww, '*' ) != NULL ){
      s1= mm;
      s2= ww;
      strcpy( ww+lw, "*" );
      i= lw;
      lw= lm;
      lm= i+1;
      i= (int)(i/3);

      if( i<limit )
        limit= i;         
    }
    else{
      s1= ww;
      s2= mm;
    }
  }
  else{
    lw= strlen( s1 );
    lm= strlen( s2 );
    if( lw >= MAXLEN )
      lw= (MAXLEN-1);
    if( lm >= MAXLEN )
      lm= (MAXLEN-1);
  }

  if( *s2 == '*' ){
    for( k=0; k<=lw; k++ )
      d[k]= 0;
  }
  else{
    d[0]= (*s2==0) ? 0:1;
    i= (*s2=='?') ? 0:1;
    for( k=1; k<=lw; k++ ){
      if( *s2 == *(s1+k-1)){
        i= 0;
      }  
      d[k]= k-1+i;
    }
  }

  spmin= (d[0] == 0 || lw == 0) ? d[0]:d[1];
  if( spmin > limit )
    return MAXLEN;

  for( i=2; i<=lm; i++ ){
    c= *( s2+i-1 );
    p= ( c == '*' || c == '?' ) ? 0 : 1;
    q= ( c == '*' ) ? 0 : 1;
    r= ( c == '*' ) ? 0 : 1;
    d2= d[0];
    d[0]= d2 + q;
    spmin= d[0];

    for( k=1; k<=lw; k++ ){
      d1= d2;
      d2= d[k];
      x1= d1 + (( c == *(s1+k-1)) ? 0 : p );
      x2= d2 + q;
      x3= d[k-1] + r;

      if( x1 < x2 )
        x2= x1;
      d[k]= ( x2 < x3 ) ? x2: x3;

      if( d[k] < spmin )
        spmin= d[k];
    }

    if( spmin > limit )
      return MAXLEN;
  }
  return ((d[lw] <= limit ) ? d[lw] : MAXLEN );
}

