/* musicBrowser.h

  Created by Cajus Pollmeier (Cajus.Pollmeier@mfh-iserlohn.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _MUSICBROWSER_H_
#define _MUSICBROWSER_H_

#include <qdialog.h>
#include <qstrlist.h>
#include <qcombo.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qchkbox.h>
#include <qtabdialog.h>
#include <qlistbox.h>
#include <qprogressbar.h>
#include <qmessagebox.h>
#include <qbitmap.h>

#include "tag.h"

class musicBrowser : public QTabDialog
{
  Q_OBJECT;
  
  public:
    musicBrowser(QWidget *parent = 0, const char *name = 0);
    ~musicBrowser();

    void setFuzzy( bool value );
    void setSensitive( bool value );
    void setStep( int value );

  private:
    int formatting( char dest[], char source[], int n, char mode );
    int WLD( char *s1, char *s2, char mode, int limit );
    int getLevel( const char *text );
    void searchIt();
    void showSearch();
    void showResults();
    int compare( const char *s1, const char *s2 );

    Tag fileTag;

    int	*foundList;

    bool allreadyStarted;
    unsigned currentIndex;

    QProgressBar *progrBar;
    QLabel	*foundLB, *progrLB, 
		*titleLB,  *titleRS,
		*artistLB, *artistRS,
		*albumLB,  *albumRS,
		*yearLB,   *yearRS,
		*genreLB,  *genreRS,
		*commentLB,*commentRS,
	       	*positionLB;

    QWidget     *search,
                *results;

    QListBox	*foundBox;

    QCheckBox   *titleCB,
                *artistCB,
                *albumCB,
                *yearCB,
                *genreCB,
                *commentCB;

    QLineEdit   *titleBox,
                *artistBox,
                *albumBox,
                *yearBox,
                *commentBox;

    QComboBox	*genreBox, *positionBox;

    QPushButton *clearPB,
		*playPB,
		*stopPB,
		*nextPB,
		*prevPB,
		*delPB;

    bool 	fuzzy,
		wildcards,
		sensitive;
    int		step;	

    QBitmap	*playBmp,
		*stopBmp,
		*nextBmp,
		*prevBmp,
		*delBmp;

  public slots:
    void nextSong();

  private slots:
    void prevSong();
    void playSong();
    void stopSong();
    void delClicked();  
    void artistChanged( const char * );
    void titleChanged( const char * );
    void albumChanged( const char * );
    void yearChanged( const char * );
    void commentChanged( const char * );
    void genreChanged( int index );
    void tabChanged( const char *label);
    void clearPressed();
    void updateTag( const char *selectedText );
    void itemClicked( int index );

  protected:
    void resizeEvent(QResizeEvent *ev);

};

#endif
