#ifndef PLAYER_H
#define PLAYER_H

#include <qstrlist.h>
#include <kapp.h>
#include <qtimer.h>
#include "layer.h"
#include "process.h"
#include "docking.h"
#include "volume.h"

// Error constants
#define ERR_SOCKET	0
#define ERR_MESSAGE	1
#define ERR_AUDIO	2
#define ERR_PRIORITY	3
#define ERR_NOFILE	4
#define ERR_PLAYER	5
#define ERR_PLAYER_DIED	6
#define ERR_NOSONG	7

// Status for forwarding and rewinding in mpeg streams
enum{
  forwardState = 1,
  forwardStep = 2,
  rewindState = 4,
  rewindStep = 8
};

#define REPEAT_NO 1
#define REPEAT_ALL 2
#define REPEAT_ONE 3

// The class Player
class Player : public QObject
{
  Q_OBJECT

public:
  Player( int buffers );
  ~Player();
  
  void setPriority( int priority );
  int getPriority();
  void setPreLoadBuffer( int buffer );
  int getPreLoadBuffer();
  void setPreDecodeBuffer( int buffer );    
  int getPreDecodeBuffer();    
  void setSongNr( unsigned Nr );
  void setIndex( unsigned Nr );
  unsigned getSongNr();
  unsigned getIndex();
  int getSeconds();
  int getMinutes();
  int gotResponse();
  int isPaused();
  int isPlaying();
  int getVolume();
  void setBrowserMode( int mode );
  unsigned long getTotalLength();
  void cycleUpRepeatFlag();
  void setRepeatFlag(int flag); // Added by SMF (22/12/98)
  int getRepeatFlag();
  void setShuffleFlag( int flag );
  int getShuffleFlag();
  inline int getPauseFlag(){ return pauseFlag; };
  inline int getPlayingFlag(){ return playingFlag; };
  unsigned getBitrate();
  unsigned getFrequency();
  unsigned *list;


signals:
  void mpegError( int );
  void next();
  void songComplete();
  void frames( int );
  void position( int );
  void songChanged();
  void timeChanged();
  void listFinished();
  void status( int );

public slots:
  void play();
  int initCurentSong();
  void forward();
  void rewind();
  void quit();
  void nextSong();
  void prevSong();
  void setVolume( int value );
  void stop();
  void pause();

private slots:
  void notifyExit( KProcess * );
  void parseMessage(KProcess *, char *buffer, int );
  void noResponse();
  void stepTimer();
  void playerNextSong();

private:
  PProcess amp;

// That's for the player itself
  unsigned index;
  int priority;
  int preLoadBuffer;
  int preDecodeBuffer;
  int repeatFlag;
  int shuffleFlag;
  int pauseFlag;
  int playingFlag;
  int dontTouchFlag;
  int isLocked;
  int fd;
  int browserMode;
  unsigned freq;
  unsigned pcmperfrm;
  int seconds;
  int oldSeconds;
  int minutes;
  FILE *fd2;
  Layer *layer;
  Volume vol;

// For ffwd / fbwd
  QTimer *sTimer;  
  int curState;

// For receiving player messages
  QTimer *timer;
  int response;
  int responseFlag;
  
  void nextSong(bool bUserPressed);
  void sendMessage( int cmd, int data );
  void prepareList();
};


#endif
