#include <stdio.h>
#include <time.h>
#include <qbitmap.h>
#include <kfiledialog.h>
#include <kurl.h>

#include "kmp3.h"
#include "bitmaps/up.xbm"
#include "bitmaps/down.xbm"

#define ktr           klocale->translate

extern KApplication *a;
extern kmp3 * k;
extern cfg_struct cfgData;

/*-----------------------------------------------------------------------------
  Constructor
-----------------------------------------------------------------------------*/
PlaylistDialog::PlaylistDialog(QWidget *parent, const char *name)
  : QDialog(parent, name,TRUE)
{
  setCaption(ktr("Playlist Editor"));
  setMinimumSize(600,360);

  layer = new Layer();
  songlist = new QStrList();
  saved = true;
  playlistName = 0;

  // Init of random generator...
  srand(time(0));

  // Init lists...
  highlight = new QStrList();

  // Adding Key Accelerator...
  QAccel *a = new QAccel( this );
  a->connectItem(a->insertItem(Key_T + CTRL), this, 
		 SLOT(completion()));
  a->connectItem(a->insertItem(Key_Insert), this, 
		 SLOT(add()));
  a->connectItem(a->insertItem(Key_Delete), this, 
		 SLOT(del()));

  // Init Filter...
  filter = QDir::Files | QDir::Dirs | QDir::TypeMask ;

  // directory reader...
  dir = new KDir("/");
  dir->setSorting(QDir::Name | QDir::DirsFirst | QDir::IgnoreCase);
  connect(dir, SIGNAL(newFilesArrived(const KFileInfoList*)), 
	  this, SLOT(fileArrived(const KFileInfoList*)));
  // Add MenuBar...
  menu = new QMenuBar(this, "PLMenu");

    // Sub-Menu File...
    playlistMenu = new QPopupMenu();
    playlistMenu->insertItem(ktr("&New Playlist"), MENU_ID_PNEW, -1);
    playlistMenu->insertItem(ktr("&Load Playlist..."), MENU_ID_PLOAD, -1);
    playlistMenu->insertItem(ktr("&Add Playlist..."), MENU_ID_PADD, -1);
    playlistMenu->insertItem(ktr("&Save Playlist"), MENU_ID_PSAVE, -1);
    playlistMenu->insertItem(ktr("Save &Playlist As..."), MENU_ID_PSAVEAS, -1);
    playlistMenu->insertSeparator(-1);
    playlistMenu->insertItem(ktr("&Close"), MENU_ID_PCLOSE, -1);
    connect(playlistMenu, SIGNAL(activated(int)), this, SLOT(menuHandler(int)));
  
    // Sub-Menu Edit...
    editMenu = new QPopupMenu();
    editMenu->insertItem(ktr("&Add"), MENU_ID_EADD, -1);
    editMenu->insertItem(ktr("&Del"), MENU_ID_EDEL, -1);
    editMenu->insertItem(ktr("&Clear"), MENU_ID_ECLEAR, -1);
    editMenu->insertItem(ktr("&Shuffle"), MENU_ID_ESHUFFLE, -1);
    connect(editMenu, SIGNAL(activated(int)), this, SLOT(menuHandler(int)));

    // Sub-Menu Option...
    optionMenu = new QPopupMenu();
    optionMenu->setCheckable(TRUE);
    optionMenu->insertItem(ktr("&Show Hidden"), MENU_ID_OHIDDEN, -1);
    optionMenu->setItemChecked(MENU_ID_OHIDDEN, cfgData.pl_hidden);
    optionMenu->insertItem(ktr("&Save Path"), MENU_ID_OPATH, -1);
    optionMenu->setItemChecked(MENU_ID_OPATH, cfgData.pl_path);
    // Added by SMF (12/22/98)
    optionMenu->insertItem(ktr("&Append M3U extension"), MENU_ID_OM3U, -1);
    optionMenu->setItemChecked(MENU_ID_OM3U, cfgData.pl_m3u );

    connect(optionMenu, SIGNAL(activated(int)), this, SLOT(menuHandler(int)));

  menu->insertItem(ktr("&File"), playlistMenu, 5, -1);
  menu->insertItem(ktr("&Edit"), editMenu, 4, -1);
  menu->insertItem(ktr("&Options"), optionMenu, 2, -1);

  menu->setFixedHeight(menu->height());
  
  // Add Panner...
  panner = new KPanner(this, "_panner", KPanner::O_VERTICAL, 30);
  panner->setMinimumSize(500,250);
  panner->setSeparator(45);

    // Left Pannel...
    leftLayout = new QGridLayout(panner->child0(), 3, 1, 1, -1);
      // - UP : path...
      pathCB = new KCombo(true, panner->child0(), "Path");
      connect(pathCB, SIGNAL(activated(const char *)), 
	      this, SLOT(pathHasChanged(const char *)));
      pathCB->setFixedHeight(pathCB->height()-4);
      leftLayout->addWidget(pathCB, 0, 0);
      leftLayout->setRowStretch(0, 0);

      // - MIDDLE : file selector
      fileSelectorLB = new fileSelector(false, dir->sorting(), 
					panner->child0(), "FileSelector");
      fileSelectorLB->setAutoUpdate(true);
      fileSelectorLB->connectDirSelected(this, 
                      SLOT(dirActivated(KFileInfo*)));
      fileSelectorLB->connectFileSelected(this, 
		      SLOT(fileActivated(KFileInfo*)));
      fileSelectorLB->connectFileHighlighted(this, 
		      SLOT(fileHighlighted(KFileInfo*)));
      connect(fileSelectorLB, SIGNAL(newSelection()), 
	      this, SLOT(emptyHighlighted()));
      leftLayout->addWidget(fileSelectorLB->widget(), 1, 0);
      leftLayout->setRowStretch(1, 1);

      // - DOWN : mask
      maskFF = new KFileFilter(panner->child0() , "Mask");
      maskFF->setFilter("*.[Mm][Pp]?|MPEG Files (*.mp?)\n*|All Files");
      maskFF->setFixedHeight(maskFF->height()-4);
      connect(maskFF, SIGNAL(filterChanged ()), this, SLOT(maskHasChanged()));
      leftLayout->addWidget(maskFF, 2, 0);
      leftLayout->setRowStretch(2, 0);

    leftLayout->activate();
    dir->setNameFilter(maskFF->currentFilter());

    // Right Pannel...
    rightLayout = new QGridLayout(panner->child1(), 2, 1, 1, -1);

      // - UP : playlist + Drop zone...
      playlistLB = new  QListBox(panner->child1(), "Playlist",0);
      playlistLB->setMultiSelection(true);
      rightLayout->addWidget(playlistLB, 0, 0);
      rightLayout->setRowStretch(0, 1);
      DropZone = new KDNDDropZone( playlistLB, DndURL );
      connect(DropZone,SIGNAL(dropAction(KDNDDropZone*)),this,
	      SLOT(drop(KDNDDropZone *)));


      // - DOWN : button bar...
      buttonBar = new QWidget(panner->child1(), "buttonBar");
      
      //          Add button...
      addButton = new QPushButton(ktr("Add"),buttonBar);
      connect(addButton, SIGNAL(clicked()), this, SLOT(add()));
      //          Del button...
      delButton = new QPushButton(ktr("Del"),buttonBar);
      connect(delButton, SIGNAL(clicked()), this, SLOT(del()));
      //          Clear button...
      clearButton = new QPushButton(ktr("Clear"),buttonBar);
      connect(clearButton, SIGNAL(clicked()), this, SLOT(clear()));
      //          Shuffle button...
      shuffleButton = new QPushButton(ktr("Shuffle"),buttonBar);
      connect(shuffleButton, SIGNAL(clicked()), this, SLOT(shuffle()));
      //          Up button...
      upButton = new QPushButton(ktr("&Up"),buttonBar);
      QBitmap upBmp( up_width, up_height, up_bits,TRUE );
      upButton->setPixmap(upBmp);
      connect(upButton, SIGNAL(clicked()), this, SLOT(up()));
      //          Down button...
      downButton = new QPushButton(ktr("D&own"),buttonBar);
      QBitmap downBmp( down_width, down_height, down_bits, TRUE );
      downButton->setPixmap(downBmp);
      connect(downButton, SIGNAL(clicked()), this, SLOT(down()));
      //          Layouts...
      layout1 = new QHBoxLayout(buttonBar, 0);
      layout1->addSpacing(2);
      layout1->addWidget(addButton, 0);
      layout1->addSpacing(2);
      layout1->addWidget(delButton, 0);
      layout1->addSpacing(2);
      layout1->addWidget(clearButton, 0);
      layout1->addSpacing(2);
      layout1->addWidget(shuffleButton, 0);
      layout1->addSpacing(2);
      layout2 = new QVBoxLayout(0);
      layout1->addLayout(layout2, 0);
      layout2->addWidget(upButton, 0);
      layout2->addWidget(downButton, 0);
      layout1->activate();
      buttonBar->setFixedHeight(25);

    rightLayout->addWidget(buttonBar, 1, 0);
    rightLayout->setRowStretch(1, 0);
    rightLayout->activate();

  // Add Bottom bar of buttons...
  bottomBar = new QWidget(this, "bottomBar");

  newButton = new QPushButton(ktr("&New"),bottomBar);
  connect(newButton, SIGNAL(clicked()), this, SLOT(newpl()));
  loadButton = new QPushButton(ktr("&Load"),bottomBar);
  connect(loadButton, SIGNAL(clicked()), this, SLOT(loadpl()));
  addpButton = new QPushButton(ktr("Add &Pl"),bottomBar);
  connect(addpButton, SIGNAL(clicked()), this, SLOT(addpl()));
  saveButton = new QPushButton(ktr("&Save"),bottomBar);
  connect(saveButton, SIGNAL(clicked()), this, SLOT(savepl()));

  cancelButton = new QPushButton(ktr("&Cancel"),bottomBar);
  connect(cancelButton, SIGNAL(clicked()), this, SLOT(cancel()));
  okButton = new QPushButton(ktr("&Ok"),bottomBar);
  connect(okButton, SIGNAL(clicked()), this, SLOT(ok()));

  bottomLayout =  new QHBoxLayout(bottomBar, 0);
  bottomLayout->addWidget(newButton, 1);
  bottomLayout->addSpacing(2);
  bottomLayout->addWidget(loadButton, 1);
  bottomLayout->addSpacing(2);
  bottomLayout->addWidget(addpButton, 1);
  bottomLayout->addSpacing(2);
  bottomLayout->addWidget(saveButton, 1);
  bottomLayout->addSpacing(2);
  bottomLayout->addStretch(2);
  bottomLayout->addWidget(okButton, 1);
  bottomLayout->addSpacing(2);
  bottomLayout->addWidget(cancelButton, 1);
  bottomLayout->activate(); 
  bottomBar->setFixedHeight(25);
 
  // create main layout...
  mainLayout = new QGridLayout(this, 3, 1, 5, -1);
  mainLayout->addWidget(menu, 0, 0);
  mainLayout->setRowStretch(0, 0);
  mainLayout->addWidget(panner, 1, 0);
  mainLayout->setRowStretch(1, 1);
  mainLayout->addWidget(bottomBar, 2, 0);
  mainLayout->setRowStretch(2, 0);
  mainLayout->activate();

  // Init Dialog box...
  pathHasChanged(getenv("PWD"));
}

/*-----------------------------------------------------------------------------
  Destructor
-----------------------------------------------------------------------------*/
PlaylistDialog::~PlaylistDialog()
{
  delete dir;
  delete songlist;
  delete layer;
  if(playlistName) delete playlistName;
}

/*-----------------------------------------------------------------------------
  Routine menuHandler
-----------------------------------------------------------------------------*/
void PlaylistDialog::menuHandler(int id)
{
  switch(id) {
  case MENU_ID_PNEW:     newpl(); break;
  case MENU_ID_PLOAD:    loadpl(); break;
  case MENU_ID_PADD:     addpl(); break;
  case MENU_ID_PSAVE:    savepl(); break;
  case MENU_ID_PSAVEAS:  saveplas(); break;
  case MENU_ID_PCLOSE:   cancel(); break;
    
  case MENU_ID_EADD:     add(); break;
  case MENU_ID_EDEL:     del(); break;
  case MENU_ID_ECLEAR:   clear(); break;
  case MENU_ID_ESHUFFLE: shuffle(); break;
  case MENU_ID_OHIDDEN:  viewHidden(); break;
  case MENU_ID_OPATH:    includePath(); break;
  case MENU_ID_OM3U:     appendM3U(); break;
  default: printf("What's that ??\n");
  }
}

/*-----------------------------------------------------------------------------
  Slot drop
-----------------------------------------------------------------------------*/
void PlaylistDialog::drop( KDNDDropZone * zone ) {
  unsigned int num, i;
  char *  file, * tmp;

  num = (zone->getURLList()).count();
  for(i=0;i<num;i++) {                         // process dropped objects
    tmp = (i==0 ? (zone->getURLList()).first() 
	   : (zone->getURLList()).next());
    if(!strncmp(tmp,"file:",5)) {              // is this a local object ?
      file = new char[strlen(tmp)-4];
      strcpy(file, tmp+5);
      enqueue(file, true);
      delete[] file;
    }
    else {               
      QMessageBox::critical(this,
			    ktr("Drop Error"), 
	ktr("Only files and Directories are accepted !!!"));
    }
  }
}  

/*-----------------------------------------------------------------------------
  Slot pathHasChanged
-----------------------------------------------------------------------------*/
void PlaylistDialog::pathHasChanged(const char * newVal) {
  
  pathCB->clear();
  QString path= newVal;
  QString pos= strtok(path.data(), "/");
  QStrList list;

  QString tmp = "/";
  list.insert(0, tmp);
  while (!pos.isNull()) {
    tmp+=pos+"/";
    list.insert(0, tmp);
    pos= strtok(0, "/");
  };

  pathCB->insertStrList(&list);

  tmp = dir->path();
  dir->setPath(newVal);
  if (!dir->isReadable()) {
    QMessageBox::message(ktr("Error: Cannot Open Directory"),
			 ktr("The specified directory does not exist "
			      "or was not readable."),
			 ktr("Dismiss"),
			 this);
    dir->setPath(tmp);
  } 
  updateFS();
}

/*-----------------------------------------------------------------------------
  routine updateFS
-----------------------------------------------------------------------------*/
void PlaylistDialog::updateFS() {
  fileSelectorLB->clear();
  const KFileInfoList *il = dir->entryInfoList(filter, 
					       QDir::Name | QDir::IgnoreCase);
  fileSelectorLB->addItemList(il);
}

/*-----------------------------------------------------------------------------
  Slot fileArrived
-----------------------------------------------------------------------------*/
void PlaylistDialog::fileArrived(const KFileInfoList* info) {
  fileSelectorLB->addItemList(info);
}

/*-----------------------------------------------------------------------------
  Slot maskHasChanged
-----------------------------------------------------------------------------*/
void PlaylistDialog::maskHasChanged() {
 dir->setNameFilter(maskFF->currentFilter());
 updateFS();
}

/*-----------------------------------------------------------------------------
  Slot dirActivated
-----------------------------------------------------------------------------*/
void PlaylistDialog::dirActivated(KFileInfo* info){
  QString tmp = dir->path();
  tmp += info->fileName();
  KDir foo(tmp.data());
  tmp = foo.path();
  pathHasChanged(tmp.data());
   highlight->clear();
}

/*-----------------------------------------------------------------------------
  Slot fileActivated
-----------------------------------------------------------------------------*/
void PlaylistDialog::fileActivated(KFileInfo* info) {
  QString tmp = dir->path();
  tmp +=info->fileName();
  enqueue(tmp, true);
//  playlistLB->insertItem(tmp);
}

/*-----------------------------------------------------------------------------
  Slot fileHighlighted
-----------------------------------------------------------------------------*/
void PlaylistDialog::emptyHighlighted() {
  highlight->clear();
}

/*-----------------------------------------------------------------------------
  Slot fileHighlighted
-----------------------------------------------------------------------------*/
void PlaylistDialog::fileHighlighted(KFileInfo* info) {
  QString tmp = dir->path();
  tmp +=info->fileName();
  highlight->append(tmp);
}

/*-----------------------------------------------------------------------------
  Slot ok
-----------------------------------------------------------------------------*/
void PlaylistDialog::ok() {
  songlist->clear();

  for(int index = 0; index < (int)playlistLB->count(); index ++){
      //      printf("Appending: <%s>:\n",playlistLB->text(index));
      songlist->append( playlistLB->text(index));
  }  
  accept();
}

/*-----------------------------------------------------------------------------
  Slot cancel
-----------------------------------------------------------------------------*/
void PlaylistDialog::cancel() {
  playlistLB->clear();
  playlistLB->insertStrList(songlist);
  reject();
}

/*-----------------------------------------------------------------------------
  Slot add
-----------------------------------------------------------------------------*/
void PlaylistDialog::add() {
  char * file = 0;
  if(highlight->isEmpty()) return;
  saved = false;
  for(file = highlight->first(); file != 0; file = highlight->next())
    enqueue( file, true );
//  highlight->clear();
}

/*-----------------------------------------------------------------------------
  Routine enqueue
-----------------------------------------------------------------------------*/
void PlaylistDialog::enqueue(const char * file, bool toplevel) {
  QFileInfo info(file);
  if(!info.isReadable()) {
    printf("%s is not readable\n", file);
    return;
  }
  if(info.isFile()) {
    FILE * filed = 0;
    if((filed = fopen(file, "r")) !=0) {
      if(layer->get(filed)) playlistLB->insertItem( file );
      else printf("%s is not an MP3 file\n",file);
      fclose(filed);
    }
  }
  else {
    QDir     *dir2proc;
    QStrList *sltmp;
    QString  file1;          
    char     *filename;
    
    // Looking for MP3 files ...
    dir2proc = new QDir(file, maskFF->currentFilter());
    if(toplevel) {
      file1 = ktr("Adding the directory\n");
      file1 += dir2proc->path();
      file1 += ktr("\nwill add all its sub-directories\n"\
		   "and can take a long time.\n\nContinue ?");
      if(QMessageBox::warning(this, ktr("Warning"), file1.data(),
			      ktr("Yes"),ktr("No"),0, 0, 1)) {
	delete dir2proc;
	return;
      }
      QApplication::setOverrideCursor( waitCursor );
    }
    dir2proc->setFilter(QDir::Files);
    sltmp = (QStrList *)(dir2proc->entryList());
    for(filename = sltmp->first(); filename !=0 ;filename = sltmp->next()) {
      file1 = dir2proc->path();
      file1 += "/";
      file1 += filename;
      enqueue(file1.data(), false);
    }
    delete dir2proc;
    
    // Looking for sub-directories ...
    dir2proc = new QDir(file, "*");
    dir2proc->setFilter(QDir::Dirs);
    sltmp = (QStrList *)(dir2proc->entryList());
    for(filename = sltmp->first(); filename !=0 ;filename = sltmp->next()) {
      if(!strcmp(filename,".") || !strcmp(filename,"..")) continue;
      file1 = dir2proc->path();
      file1 += "/";
      file1 += filename;
      enqueue(file1.data(), false);
    }
    delete dir2proc;    
    
    if(toplevel) QApplication::restoreOverrideCursor(); 
  }
}

/*-----------------------------------------------------------------------------
  Slot del
-----------------------------------------------------------------------------*/
void PlaylistDialog::del() {
  for(int i = playlistLB->count()-1; i>=0; i--) {
    if(playlistLB->isSelected(i)) {
      saved = false;
      playlistLB->removeItem(i);
    }
  }
}

/*-----------------------------------------------------------------------------
  Slot clear
-----------------------------------------------------------------------------*/
void PlaylistDialog::clear() {
  if(!playlistLB->count()) return;
  saved = false;
  playlistLB->clear();
}

/*-----------------------------------------------------------------------------
  Slot shuffle
-----------------------------------------------------------------------------*/
void PlaylistDialog::shuffle() {
  int index, i;
  QStrList * tmpList;
  if(playlistLB->count()<2) return;

  saved = false;
  playlistLB->setAutoUpdate( false );
  tmpList = new QStrList();
  for(i= playlistLB->count();i>0;i--) {
    index = rand() % i;
    tmpList->insert(0, playlistLB->text( index ));
    playlistLB->removeItem ( index );
  }
  playlistLB->clear();
  playlistLB->insertStrList( tmpList );
  delete tmpList;
  playlistLB->setAutoUpdate( true );
  playlistLB->repaint();

}

/*-----------------------------------------------------------------------------
  Slot up
-----------------------------------------------------------------------------*/
void PlaylistDialog::up() {
  if( !playlistLB->count() || playlistLB->isSelected(0) ) return;
  playlistLB->setAutoUpdate( false );
    for(uint i = 1; i<playlistLB->count(); i++) {
    if( playlistLB->isSelected(i) ) {
      QString item = playlistLB->text( i ); 
      saved = false;
      playlistLB->removeItem( i );
      playlistLB->insertItem( item, i-1 );
      playlistLB->setSelected( i-1, true);
    }
  }
  playlistLB->setAutoUpdate( true );
  playlistLB->repaint();
}

/*-----------------------------------------------------------------------------
  Slot down
-----------------------------------------------------------------------------*/
void PlaylistDialog::down() {
  if( !playlistLB->count()  
      || playlistLB->isSelected(playlistLB->count()-1) ) return;
  playlistLB->setAutoUpdate( false );
  for(int i = (int)playlistLB->count() -1; i>=0; i--) {
    if( playlistLB->isSelected(i) ) {
      QString item = playlistLB->text( i ); 
      saved = false;
      playlistLB->removeItem( i );
      playlistLB->insertItem( item, i+1 );
      playlistLB->setSelected( i+1, true);
    }
  }
  playlistLB->setAutoUpdate( true );
  playlistLB->repaint();
}

/*-----------------------------------------------------------------------------
  Slot newpl
-----------------------------------------------------------------------------*/
void PlaylistDialog::newpl() {
  if( playlistLB->count() && !saved && !wannaSave()) return;

  saved = true;
  if(playlistName) delete playlistName;
  clear();
}

/*-----------------------------------------------------------------------------
  Slot loadpl
-----------------------------------------------------------------------------*/
void PlaylistDialog::loadpl() {
  if( playlistLB->count() && !saved && !wannaSave()) return;
  QString * plAdd = new QString(KFileDialog::getOpenFileName(dir->path(),
			 "*.m3u|Playlist Files (*.m3u)\n*|All Files",
			 this, ktr("Load")));
  if(!plAdd->isNull() && loadPlaylist(*plAdd)) {
    if(playlistName) delete playlistName;
    playlistName = plAdd;
    saved = true;
  }
}

/*-----------------------------------------------------------------------------
  Routine wannaSave();
-----------------------------------------------------------------------------*/
bool PlaylistDialog::wannaSave() {
  int i = QMessageBox::warning(this, ktr("warning"),
			       ktr("The current playlist is not save.\n\n"\
				   "Do you want to do save it ?"),
			       3, 4, 2);
  if(i == 2) return false;
  if(i == 4) return true;
  savepl();
  return saved;
}

/*-----------------------------------------------------------------------------
  Slot addpl
-----------------------------------------------------------------------------*/
void PlaylistDialog::addpl() {
  QString * plAdd = new QString(KFileDialog::getOpenFileName(0,
			 "*.m3u|Playlist Files (*.m3u)\n*|All Files",
			 this, ktr("Add Playlist")));
  if(!plAdd->isNull()) loadPlaylist(*plAdd);
  delete plAdd;
}

/*-----------------------------------------------------------------------------
  Slot savepl
-----------------------------------------------------------------------------*/
bool PlaylistDialog::savepl() {
  if(!playlistName && !saveplas()) return false;
  return savePlaylist(*playlistName);
}

/*-----------------------------------------------------------------------------
  Slot saveplas

    return : false (cancel), true (ok)
-----------------------------------------------------------------------------*/
bool PlaylistDialog::saveplas() {
  QString *plName = new QString(KFileDialog::getSaveFileName(0,
			 "*.m3u|Playlist Files (*.m3u)\n*|All Files",
			 this, ktr("Save As")));
  if(plName->isNull()) {
    delete plName;
    return false;
  }

  // ADDED BY SMF (12/22/98)
  if(cfgData.pl_m3u)
    if((plName->right(4)).upper()!=".M3U") plName->append(".m3u");

  QFileInfo * info = new QFileInfo(plName->data());
  if(info->exists()) {
    while(info->isSymLink()) {
      QString tmp = info->dirPath();
      tmp+= "/"+  info->readLink();
      // printf("LINK => %s\n",tmp.data());
      delete info;
      info = new QFileInfo(tmp.data());
    }
    if(info->isDir()) {
      QMessageBox::critical(this, ktr("Error"),
			    ktr("You must specify a file.\n"\
				"But, a directory was given."\
				"\n\nThe operation has been cancelled."),
			    ktr("OK"), 0, 0, 0, 0);
      delete info;
      delete plName;
      return false;
    }
    // this is a file !!
    delete info;
    if(!QMessageBox::warning(this,ktr("Warning"),
			     ktr("You have specified an existing file.\n\n"\
				 "Do you want to overwrite it ?"),
			     ktr("Yes"), ktr("No"), 0, 0, 1)) {
      // overwrite file ...
      delete playlistName;
      playlistName = plName;      
      return savepl();
    }
    delete plName;
    return false;
  }
  else {
    delete playlistName;
    playlistName = plName;
  }
  return savepl();  
};
  
/*-----------------------------------------------------------------------------
  Slot viewHidden
-----------------------------------------------------------------------------*/
void PlaylistDialog::viewHidden() {
  cfgData.pl_hidden = !cfgData.pl_hidden;
  optionMenu->setItemChecked(MENU_ID_OHIDDEN, cfgData.pl_hidden);
  filter = QDir::Files | QDir::Dirs | QDir::TypeMask;
  if(cfgData.pl_hidden) filter |= QDir::Hidden;
  updateFS();
}

/*-----------------------------------------------------------------------------
  Slot includePath
-----------------------------------------------------------------------------*/
void PlaylistDialog::includePath() {
  cfgData.pl_path = !cfgData.pl_path;
  optionMenu->setItemChecked(MENU_ID_OPATH, cfgData.pl_path);
}

// Added by SMF (12/22/98)
/*-----------------------------------------------------------------------------
  Slot appendM3U
-----------------------------------------------------------------------------*/
void PlaylistDialog::appendM3U() {
  cfgData.pl_m3u = !cfgData.pl_m3u;
  optionMenu->setItemChecked(MENU_ID_OM3U, cfgData.pl_m3u);
}

/*-----------------------------------------------------------------------------
  Slot completion
-----------------------------------------------------------------------------*/
void PlaylistDialog::completion() // SLOT
{
    QString base = dir->path();

    QString text = pathCB->currentText();
    if ( KURL(text).isMalformed() )
	return;                         // invalid entry in location
            
    if (text.left(base.length()) == base) {

	QString complete =
	  fileSelectorLB->findCompletion(text.right(text.length() - 
						    base.length()));
	
	if (!complete.isNull()) {
	    if ( complete != "../" ) {
	      base+= complete;
	      KFileInfo *info = new KFileInfo(base.data());
	      if(info->isDir()) {
		base+="/";
		pathCB->setText(base);
	      }
	      delete info;
	    }
	} 
	else {
	  // warning("no complete");
	  //XBell(a->getDisplay(),100);
	}
    } else {    // we changed into a parent directory -> go there first
	int l = text.length() - 1;
	while (!text.isEmpty() && text[l] != '/')
	    l--;
//	setDir(text.left(l), true);
	pathCB->setText(text);

	// this recursion is very dangerous.
	// I'm not *that* sure, that it works in every case
        // dg: added a little timeout: time to reread the new directory
        QTimer::singleShot( 500, this, SLOT(completion()) );
    }
}

/*-----------------------------------------------------------------------------
  Routine saveDefault
-----------------------------------------------------------------------------*/
void PlaylistDialog::saveDefault(){
  QString _default = QDir::homeDirPath();
  _default += "/.kde/share/apps/kmp3/default";
  savePlaylist(_default);  
}
/*-----------------------------------------------------------------------------
  Routine savePlaylist
-----------------------------------------------------------------------------*/
bool PlaylistDialog::savePlaylist(QString & name) {

  if(name.isEmpty()) return false;

  QFileInfo info(name.data());

  // if the directory doesn't exist => create directory
  if(!(info.dir(true)).exists())
    (info.dir(true)).mkdir(info.dirPath(true));

  // save playlist (directory is stored)
  QFile f(name.data());
  if(f.open( IO_WriteOnly | IO_Translate | IO_Truncate)) {
    QString temp;
    for (int i = 0; i < (int)playlistLB->count(); i++){
      if(cfgData.pl_path)
	temp = playlistLB->text(i);
      else {
	info.setFile( playlistLB->text(i) );
	temp = info.fileName ();
      }
      temp += '\n';
      f.writeBlock(temp.data(),temp.length());
    }
    f.close();
    saved = true;
  }
  else {
    QMessageBox::critical(this, ktr("Save Failure"),
			  ktr("An error occurs during save\n"\
			      "of the playlist. The operation\n"\
			      "had been canceled."), ktr("OK"));
    return false;
  }
  return true;
}

/*-----------------------------------------------------------------------------
  Routine loadDefault
-----------------------------------------------------------------------------*/
void PlaylistDialog::loadDefault(){
  QString _default = QDir::homeDirPath();
  _default += "/.kde/share/apps/kmp3/default";
  loadPlaylist(_default);  
  songlist->clear();

  for(int index = 0; index < (int)playlistLB->count(); index ++){
      //      printf("Appending: <%s>:\n",playlistLB->text(index));
      songlist->append( playlistLB->text(index));
  }    
}


/*-----------------------------------------------------------------------------
  Routine setPlaylist I
-----------------------------------------------------------------------------*/
bool PlaylistDialog::setPlaylist( QString & name ){
  bool ret= loadPlaylist( name );
  songlist->clear();

  for(int index = 0; index < (int)playlistLB->count(); index ++)
      songlist->append( playlistLB->text(index));

  return ret;
}


/*-----------------------------------------------------------------------------
  Routine setPlaylist II
-----------------------------------------------------------------------------*/
void PlaylistDialog::setPlaylist( QStrList * list ){
  songlist->clear();

  for(int index = 0; index < (int)list->count(); index ++){
    songlist->append( list->at(index) );
    playlistLB->insertItem( list->at(index), -1);
  }
} 


/*-----------------------------------------------------------------------------
  Routine loadPlaylist
-----------------------------------------------------------------------------*/
bool PlaylistDialog::loadPlaylist(QString & name) {
  QFile f(name.data());
  QFileInfo info(f);
  int i = 0;
  QString lerror;

  if(f.open( IO_ReadOnly | IO_Translate)) {
    char buffer[1024];
    QString tempstring;
    
    while(!f.atEnd()){
      buffer[0] = (char) 0;
      f.readLine(buffer,511);
      //printf("Found:%s\n",buffer);
      tempstring = buffer;
      tempstring = tempstring.stripWhiteSpace();
      if (!tempstring.isEmpty()){
	info.setFile(tempstring.data());
        // Modified by SMF (10/17/98)
	if( info.isRelative() ) {

	  info.setFile(f);
	  tempstring = info.dirPath() +"/"+ tempstring;
	  info.setFile(tempstring.data());
          // Modified by SMF (10/17/98)
	  info.convertToAbs();
	}
	if(info.exists()) {
	  playlistLB->insertItem(info.filePath(), -1);
	  saved = false;	    
	}
	else i++;
      }
    }
    f.close();
    if(i) {
      lerror.sprintf("%d",i);
      lerror = ktr("The playlist contains ") + lerror
                                             + ktr(" invalid file(s).");
      QMessageBox::warning(this, ktr("Playlist error"),
			   lerror, ktr("OK"));
    }
  }
  else  {
    QMessageBox::critical(this, ktr("Load Failure"),
			  ktr("An error occurs during load\n"\
			      "of the playlist. The operation\n"\
			      "had been canceled."), ktr("OK"));
    return false;
  }
  return true;
}

