// -*- c++ -*-
#ifndef PLAY_LIST_H
#define PLAY_LIST_H

#include <qwidget.h>
#include <qstring.h>
#include <qstrlist.h>
#include <qdir.h>
#include <qdialog.h>
#include <qpopupmenu.h>
#include <qpushbt.h>
#include <qmenubar.h>
#include <qlistbox.h>
#include <qlayout.h>
#include <qaccel.h>

#include <kcombo.h>
#include <kpanner.h>
#include <kdir.h>
#include <kfilefilter.h>
#include <drag.h>

#include "fileSelector.h"
#include "layer.h"

class PlaylistDialog : public QDialog {

  Q_OBJECT

public:
  /* FUNCTIONS */
  PlaylistDialog(QWidget *parent=0, const char *name = 0);
  ~PlaylistDialog();
  void loadDefault();
  void saveDefault();
  bool setPlaylist( QString & name );  
  void setPlaylist( QStrList * list );

  /* DATA */
  QStrList * songlist;
  QString  * playlistName;

private:
  /* FUNCTIONS */
  void updateFS();
  void enqueue(const char * file, bool toplevel);
  bool loadPlaylist(QString &name);   
  bool savePlaylist(QString &name);
  bool wannaSave();
  

  /* DATA */
  enum MenuId { MENU_ID_PNEW =1, MENU_ID_PLOAD,
		MENU_ID_PADD   , MENU_ID_PSAVE,
		MENU_ID_PSAVEAS, MENU_ID_PCLOSE,
		MENU_ID_EADD   , MENU_ID_EDEL,
		MENU_ID_ECLEAR , MENU_ID_ESHUFFLE,
                MENU_ID_OHIDDEN, MENU_ID_OPATH, 
                MENU_ID_OM3U};

  bool              saved;
  Layer           * layer;
  QMenuBar        * menu;
  QPopupMenu      * playlistMenu, * editMenu, * optionMenu;
  KPanner         * panner;
  KCombo          * pathCB;
  fileSelector    * fileSelectorLB;
  KFileFilter     * maskFF;
  QGridLayout     * leftLayout, * rightLayout, * mainLayout ;
  QHBoxLayout     * layout1, * bottomLayout;
  QVBoxLayout     * layout2;
  QPushButton     * addButton, * delButton, * clearButton, 
                  * shuffleButton, * upButton, * downButton;
  QPushButton     * okButton, * cancelButton, * newButton,
                  * loadButton, * addpButton, * saveButton;
  KDir            * dir;
  KDNDDropZone    * DropZone;        // to allow drop files, dirs
  QWidget         * buttonBar, * bottomBar;
  QListBox        * playlistLB;
  QStrList        * highlight;
  int               filter;

private slots:
  // slots for fileSelector ...
  void dirActivated(KFileInfo* info);
  void fileActivated(KFileInfo* info);
  void emptyHighlighted();
  void fileHighlighted(KFileInfo* info);
  void fileArrived(const KFileInfoList* info);
  // slot for menu
  void menuHandler(int id); 
  void viewHidden();
  void includePath();
  void appendM3U();
  // slots for mask ComboBox...
  void maskHasChanged();
  // slots for path ComboBox...
  void pathHasChanged(const char * newVal);
  void completion();
  // slot for Drag N Drop...
  void drop( KDNDDropZone * zone );
  // slots for Playlist Editor...
  void ok();
  void cancel();
  void add();
  void del();
  void clear();
  void shuffle();
  void up();
  void down();
  void newpl();
  void addpl();
  void loadpl();
  bool savepl();
  bool saveplas();
};

#endif
