/* layer.h

  Created by SMF aka Antoine Laydier (laydier@usa.net)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _TAG_
#define _TAG_

/*=============================================================================
  HEADERs
 =============================================================================*/
#include <stdio.h>

/*=============================================================================
  TYPEDEFs
 =============================================================================*/
typedef struct {
    char tag[3];
    char title[30];
    char artist[30];
    char album[30];
    char year[4];
    char comment[30];
    unsigned char genre;
} tag;

/*=============================================================================
  CLASSes
 =============================================================================*/

//-----------------------------------------------------------------------------
// class Tag
//-----------------------------------------------------------------------------
 
class Tag {
 public:
  Tag();
  bool get(FILE * file);
  bool set(FILE * file);
  void copy(Tag * from);

  char * const getTitle(void)   { return title;   }
  char * const getAlbum(void)   { return album;   }
  char * const getArtist(void)  { return artist;  }
  char * const getYear(void)    { return year;    }
  char * const getComment(void) { return comment; }
  char * const getGenre(void)   { return genre;   }
  int          getGenreNum(void) { return gennum; }

  void setTitle(const char * newTitle);
  void setAlbum(const char * newAlbum);
  void setArtist(const char * newArtist);
  void setYear(const char * newYear);
  void setComment(const char * newComment);
  void setGenre(int  newGenre);

  // Added by CP
  void initTagVars();
  
  static const int genre_largest;
  static const char * const genres[];
 private:
  char title[31];
  char artist[31];
  char album[31];
  char year[5];
  char comment[31];
  char genre[31];
  int gennum;
};

#endif
