#include "volume.h"

#include <sys/types.h>
#include <stdio.h>
#include <fcntl.h>

#if defined(_OS_SUNOS_) || defined(_OS_SOLARIS_)
  #include <stropts.h> 
  #include <sys/conf.h>
  #include <sys/filio.h>

  #if defined(_OS_SUNOS_)
    #include <sun/audioio.h>
  #else
    #include <sys/audioio.h>
  #endif

#endif

#if defined(_OS_LINUX_)
  #include <linux/soundcard.h>
#endif

#include <sys/ioctl.h>
#include <unistd.h>

static StereoVolume gVol;

#if defined(_OS_LINUX_)
  static const char *mixer = "/dev/mixer";
#elif defined(_OS_SOLARIS_) || defined(_OS_SUNOS_)
  static const char *mixer = "/dev/audioctl";
#else
  static const char *mixer = "/no/such/device";
#endif


Volume::Volume(){
   mixerid = -1;
   initVol();
}

void Volume::setVolume( int volume ){
   int fd;

   if(volume > 100)
      volume = 100;
   if(volume < 0)
      volume = 0;
   gVol.left = (unsigned char)volume;
   gVol.right = (unsigned char)volume;

   if(mixerid >= 0){
#if !defined(_OS_HPUX_)
     if((fd = open(mixer, O_RDWR, 0)) < 0)
       printf( "Error opening %s\n", mixer);
     else{
#if defined(_OS_LINUX_)
       if(ioctl(fd, MIXER_WRITE(mixerid), &gVol) < 0)
         printf( "Error attempting to change sound volume.\n" );
#endif

#if defined(_OS_SOLARIS_) || defined(_OS_SUNOS_)
         struct audio_info ap;
         
         if(ioctl(fd, AUDIO_GETINFO, &ap) < 0)
            printf("Error attempting to read sound volume.\n");
         ap.play.gain = vol;
         //ap.play.balance = 32; // (gVol.right - gVol.left + 256) >> 3; 
         if(ioctl(fd, AUDIO_SETINFO, &ap) < 0)
            printf("Error attempting to change sound volume.\n");
#endif         
         ::close(fd);
      }
#endif

   }
}



int Volume::getVolume(){

#if !defined(_OS_HPUX_)
   int fd;
   int ret = 0;

   if((fd = open(mixer, O_RDWR, 0)) < 0)
     printf( "Error opening %s\n", mixer);
   else{

#if defined(_OS_LINUX_)
     if(ioctl(fd, MIXER_READ(mixerid), &gVol) < 0)
       printf( "Error attempting to read sound volume.\n" );
     ret = gVol.right>gVol.left?gVol.right:gVol.left;
#endif

#if defined(_OS_SOLARIS_) || defined(_OS_SUNOS_)
      struct audio_info ap;
      if(ioctl(fd, AUDIO_GETINFO, &ap) < 0)
         printf( "Error attempting to read sound volume.\n" );
      ret = ap.play.gain;
#endif

      ::close(fd);
      return ret;
   }
#endif
   return 0;
}
   


void Volume::initVol(){
   int fd;

#if defined(_OS_LINUX_)
  if((fd = open(mixer, O_RDWR, 0)) < 0)
    printf( "Error opening %s\n", mixer);
  else{
    if(mixerid < 0){
      int supported;
         
      if(ioctl(fd, SOUND_MIXER_READ_DEVMASK, &supported) < 0)
        supported = 0xffff;
         
      if(supported & SOUND_MASK_PCM) 
        mixerid = SOUND_MIXER_PCM; //  FOR GUS	
      else if(supported &  SOUND_MASK_VOLUME) 
        mixerid = SOUND_MIXER_VOLUME; 
      }

      if(mixerid >= 0){
        if(ioctl(fd, MIXER_READ(mixerid), &gVol) < 0)
          printf( "Error attempting to read sound volume.\n");

//        setValue(gVol.right < gVol.left ? gVol.left : gVol.right);
      }
      ::close(fd);
   }

#endif

//#if defined(_OS_SOLARIS_) || defined(_OS_SUNOS_)
//      setValue(getVolume());
//#endif

}   
