#include"mp3menu.h"

int stuff::save(char *filename) {
	char s[128];
	int file;

#ifdef LISTDIR
	sprintf(s,"%s",LISTDIR,filename);
#else
	sprintf(s,"%s/.mp3menu/%s",getenv("HOME"),filename);
#endif

	if((file=open(s,O_WRONLY|O_CREAT|O_TRUNC, 0400))==-1) return -1;
        write(file,(char *)&totalfiles, 2);
        write(file,files,filedatasize*totalfiles);
	close(file);
	return 0;
}

int stuff::load(char *filename) {
	char s[128];
	int file;

#ifdef LISTDIR
	sprintf(s,"%s/%s",LISTDIR,filename);
#else
	sprintf(s,"%s/.mp3menu/%s",getenv("HOME"),filename);
#endif

	if((file=open(s,O_RDONLY))==-1) return -1;
        read(file,(char *)&totalfiles, 2);
	files=new filedata[totalfiles];
        read(file,files,filedatasize*totalfiles);
	close(file);
	return 0;
}

void stuff::order(int tolocation, int fromlocation) {
	filedata temp; 
	int i,flag;
	if(tolocation!=fromlocation) {
		if(tolocation>fromlocation) flag=1;
		else flag=-1;
		temp=files[fromlocation];
		for(i=fromlocation;i!=tolocation;i+=flag)
		   files[i]=files[i+flag];
		files[tolocation]=temp;
	}
}

void stuff::swap(filedata *one, filedata *two) {
	filedata temp;
	temp=*one;
	*one=*two;
	*two=temp;
}

int stuff::gimmerand(float total) {
	int rnum;
	rnum=(int)(total*rand()/(RAND_MAX+1.0));
	return rnum;
}

void stuff::initrand(void) {
	time(&time_info);
	srand(time_info);
}

void stuff::playlist(void) {
	int i,hold;
	char s[1024];

	filedata *list;
	list=new filedata[totalfiles];
	
	/*
	 * This randomizing isn't particularly well thought out either
	 * But thats the beauty of it -- i dont care :) it works well
	 * enough for what I need it for.. if i ever get time ill
	 * do it right :)
	 */ 
	for(i=0;i<total();i++) list[i]=files[i]; 

	loop:
	if(random==YES) 
		for(i=0;i<total();i++) {
		hold=gimmerand((float)total());
		swap(&list[i],&list[hold]);
		}	

	for(i=0;i<total();i++) {
		if(list[i].toggled==YES) {
		wclear(screen);
		wrefresh(screen);
		sprintf(s,"Playing: %s\n",list[i].filename);
		dispstr(COLOR_PAIR(3),0,0,s);
		goxy(0,5);
			sprintf(s,"%s \"%s\"",mp3player,list[i].filename);
			system(s);
		}
	}
	if(repeat==YES) {
		wclear(screen);
		wrefresh(screen);
		dispstr(A_BOLD,0,0,"Repeating playlist in 5 seconds, press any key to abort.");
		halfdelay(50);
		i=getch();
		nocbreak();
		cbreak();
		if(i==ERR) goto loop;
	}
	wclear(screen);
	wrefresh(screen);
	i=total();
	page=0;
	if(i>screeny) i=screeny;
	dispdir(0,i);
	delete list;
} 	

void stuff::handleinput(void) {
	int in,done;
	char s[36];
	done=NO;
	goxy(8,location+1);
	while(done==NO) {
  	        goxy(8,((location+1)-(screeny*page)));
		in=wgetch(screen);
		switch(in) {
		   case KEY_NPAGE:		// Next Page
		      if(screeny*(page+1)<totalfiles) {
		        location+=screeny;
		        page++;
			if(location>total()-1) {
				location=total()-1;
				in=total();
			}
			else if(location+screeny>total()) in=total();
		        else in=(((location/screeny)*screeny)+screeny);
		        dispdir((location/screeny)*screeny,in);
		      }
			break;
		   case KEY_PPAGE:		// Previous Page
		      if(location>screeny-1) {
		        location-=screeny;
 	    	        page--;
			dispdir((location/screeny)*screeny,(((location/screeny)*screeny)+screeny));
		      }
			break;
		   case KEY_UP: 
		      if(location!=0) {
		        location--;
			if(location<(screeny*page)) {
		           page--;
			   dispdir((location-screeny+1),location+1);
			}
		      }
		      break;
		   case ' ':
		      toggle(&files[location].toggled);	
		      if(files[location].toggled==YES) dispstr(COLOR_PAIR(1),8,location+1,"Yes");
		      else dispstr(COLOR_PAIR(2),8,location+1,"No ");
		   case KEY_DOWN:
		      if(location<total()-1) {
		      	location++;
			if(location>(screeny*(page+1))-1) {
		           page++;
 			   if((location+screeny)>total()) in=total();
			   else in=location+screeny;
			   dispdir(location,in);
			}
		      }		     
		      break;
		   case 'S': 
		   case 's': 
		      dispstr(COLOR_PAIR(2),26,0, "Enter Filename:             ");
		      wrefresh(screen);
		      goxy(42,0);
		      echo();
		      wgetnstr(screen,s,35);
		      if(save(s)==-1) {
		         dispstr(COLOR_PAIR(1),26,0,"  Error saving.\n");
			 sleep(1);
		      } 
                      else { 
		         dispstr(COLOR_PAIR(1),26,0,"    File saved.\n");
			 sleep(1);
                      } 
		      noecho();
		      if(location+screeny>total()) in=total();
		      else in=(((location/screeny)*screeny)+screeny);
		      dispdir((location/screeny)*screeny,in);
	              break;
		   case 'L':
		   case 'l': 
		      dispstr(COLOR_PAIR(2),26,0,"Enter Filename:             ");
		      wrefresh(screen);
		      goxy(42,0);
		      echo();
		      wgetnstr(screen,s,35);
		      if(load(s)==-1) {
		         dispstr(COLOR_PAIR(1),26,0," Error Loading.\n");
			 sleep(1);
		      } 
                      else {  
		         dispstr(COLOR_PAIR(1),26,0,"   File Loaded.\n");
			 sleep(1);
                      } 
		      noecho();
		      location=0;
		      in=total();
		      if(in>screeny) in=screeny;
		      dispdir(location,in);
		      break;
		   case 'O':
		   case 'o':
		      dispstr(COLOR_PAIR(2),26,0,"[From] Location:             ");
		      wrefresh(screen);
		      goxy(43,0);
		      echo();
		      wgetnstr(screen,s,4);
		      in=atoi(s);
		      dispstr(COLOR_PAIR(2),26,0,"[To] Location:      ");
		      wrefresh(screen);
		      goxy(41,0);
		      wgetnstr(screen,s,4);
		      noecho();
		      if((in<totalfiles)&&(in>=0)&&(atoi(s)<totalfiles)&&(atoi(s)>=0)) 
			      order(atoi(s),in);
		      else { 
		         dispstr(COLOR_PAIR(1),26,0,"Error, values are out of range.");
			 sleep(1);
		      }
		      if(location+screeny>total()) in=total();
		      else in=(((location/screeny)*screeny)+screeny);
		      dispdir((location/screeny)*screeny,in);
		      break;
		   case 'Y':
		   case 'y':
		      for(in=0;in<total();in++) files[in].toggled=YES;
		      wclear(screen);
		      wrefresh(screen);		
		      if(location+screeny>total()) in=total();
		      else in=(((location/screeny)*screeny)+screeny);
		      dispdir((location/screeny)*screeny,in);
		      break;		       
		   case 'N':
		   case 'n':
		      for(in=0;in<total();in++) files[in].toggled=NO;
		      wclear(screen);
		      wrefresh(screen);		
		      if(location+screeny>total()) in=total();
		      else in=(((location/screeny)*screeny)+screeny);
		      dispdir((location/screeny)*screeny,in);
		      break;		       
		   case 'R':
		   case 'r':
		      toggle(&random);
		      dispstr((random==YES?COLOR_PAIR(1):COLOR_PAIR(2)),47,0,(random==YES?"Yes":"No "));
		      break;
		   case 'H':
		   case 'h':
		      wclear(screen);
		      wrefresh(screen);
		      goxy(0,0);
		      wprintw(screen,"Command Summary:\n");
		      wprintw(screen,"----------------\n");
		      wprintw(screen,"H               This Screen\n");
		      wprintw(screen,"R               Toggles Random Ordering\n");
		      wprintw(screen,"C               Toggles Continuous Play\n");
		      wprintw(screen,"Y               Toggles all files to YES\n");
		      wprintw(screen,"N               Toggles all files to NO\n");
		      wprintw(screen,"O               Does Reordering\n");
		      wprintw(screen,"UP  or  DOWN    Moves up and down the current play list\n");
		      wprintw(screen,"PGUP or PGDW    Jumps up or down 1 page\n");
		      wprintw(screen,"P  or  ENTER    Plays Current List\n");
		      wprintw(screen,"L               Loads Current Play List\n");
		      wprintw(screen,"S               Saves Current Play List\n");
		      wprintw(screen,"Q               Quits\n");
		      wprintw(screen,"----------------\n");
		      wprintw(screen,"Press any key to return.\n");
		      wrefresh(screen);
		      wgetch(screen);
		      wclear(screen);
		      wrefresh(screen);
		      if(location+screeny>total()) in=total();
		      else in=(((location/screeny)*screeny)+screeny);
		      dispdir((location/screeny)*screeny,in);
		      break;		
		   case 'C':
		   case 'c':
		      toggle(&repeat);
		      dispstr((repeat==YES?COLOR_PAIR(1):COLOR_PAIR(2)),34,0,(repeat==YES?"Yes":"No "));
		      break;
		   case KEY_ENTER:
		   case 13:
		   case 'P':
		   case 'p':
		      playlist();
		      break;
		   case 'Q':
		   case 'q':
      		      done=YES;
		      break;
		   default: break;
		}
	}
} 
int stuff::total(void) {
	return(totalfiles);
}

void stuff::dispdir(int start, int stop) {
	int i;
	char s[1024];

	goxy(0,0);
	wclear(screen);
	wrefresh(screen);
	dispstr(COLOR_PAIR(3),0,0,"mp3menu version     ----- Repeat:     - Random");
	dispstr(COLOR_PAIR(3),16,0,version);
	dispstr((repeat==YES?COLOR_PAIR(1):COLOR_PAIR(2)),34,0,(repeat==YES?"Yes":"No"));
	dispstr((random==YES?COLOR_PAIR(1):COLOR_PAIR(2)),47,0,(random==YES?"Yes":"No"));

	for(i=start;i<stop;i++) {
		sprintf(s,"[%04d] [   ] %s",i,files[i].filename);
		    dispstr(COLOR_PAIR(3),0,((i+1)-(screeny*page)),s);
		    dispstr((files[i].toggled==YES?COLOR_PAIR(1):COLOR_PAIR(2)),
	                    8,((i+1)-(screeny*page)),
                            (files[i].toggled==YES?"Yes":"No "));
	}
}

void stuff::goxy(int x, int y) {
	wmove(screen,y,x);
	wrefresh(screen);
}

void stuff::dispstr(int attrs, int x, int y, char *msg) {
	goxy(x,y);
        wattron(screen,(attr_t)(attrs | BOLD));
 
	wprintw(screen,"%s",msg);
	wattroff(screen,attrs);
	wrefresh(screen);
}

stuff::stuff(void) {
	char s[128];

	unlink("/tmp/quickout.temp.blah");
#ifndef LISTDIR
	sprintf(s,"%s/.mp3menu",getenv("HOME"));
	mkdir(s,0700);
#endif
	screen=initscr();
        start_color();
        init_pair(1,YESCOLOR,COLOR_BLACK);
        init_pair(2,NOCOLOR,COLOR_BLACK);
        init_pair(3,NORMAL,COLOR_BLACK);
	screen=newwin(0,0,0,0);
	getmaxyx(screen,screeny,location);
	screeny--;
	cbreak();
	keypad(screen,TRUE);
	noecho();
	nodelay(screen,FALSE);
	totalfiles=location=repeat=random=0;
	page=0;
	initrand();
}

stuff::~stuff(void) {
	wclear(screen);
	wrefresh(screen);
	delwin(screen);
	printf("\n");
}

void stuff::rdir(char dir[]) {
	char s[1024];
	/* 
	 * This is bullshit, I know, but hey, it works and its quick
	 * This change thanks to Robert Hardy <rhardy@webcon.net>
	 */

        sprintf(s,"find %s | fgrep -i .mp3 >> /tmp/quickout.temp.blah",dir);
	system(s);
}

int stuff::loaddir(void) {
	int i;
	char s[1024];
	FILE *blah;
	
	if((blah=fopen("/tmp/quickout.temp.blah","rt"))==NULL) {
		return ERROR;
	}
	fgets(s,1024,blah);
	i=0;
	while(!feof(blah)) {
		i++;
		fgets(s,1024,blah);
	}
	if(i==0) {
        	fclose(blah);
		unlink("/tmp/quickout.temp.blah");
		return FALSE;
	}
	totalfiles=i;
	rewind(blah);
	files=new filedata[totalfiles+1];
	for(i=0;i<totalfiles;i++) {
		fgets(s,1024,blah);
		strcpy(files[i].filename,s);
		files[i].filename[strlen(files[i].filename)-1]=0x00;
		files[i].toggled=YES;
	}	
	fclose(blah);
	unlink("/tmp/quickout.temp.blah");
	return TRUE;
}	

void stuff::toggle(int *field) {
	*field=(1-*field);
}

int main(int argc, char *argv[]) {
	stuff mp3menu;
	int i;
	if(argc<2) mp3menu.rdir(".");
	else for(i=1;i<argc;i++) mp3menu.rdir(argv[i]);
	if(mp3menu.loaddir()==ERROR) {
		printf("Error loading temp file.\n");
		exit(ERROR);
	}
	i=mp3menu.total();
	if(i>mp3menu.screeny) i=mp3menu.screeny;
	mp3menu.dispdir(0,i);
	mp3menu.handleinput();
#ifdef RESET
	system("reset");
#endif
	exit(0);
}
