/* 
 * mp3menu Copyright (C) 1997  Rich Condon
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * You may contact me at        mp3menu@darklight.com
 * but don't necessairly except a reply - I'm extremely busy.
*/

/*
 * define reset if you want, at the end, to call the system command
 * reset (some systems have reported problems if the terminal isn't
 * reset properly - this doesn't happen to me but this suspoedl'y
 * fixes it.
 */

#define RESET

/* 
 * These are your color sections
 */
 
/*
 *  Define this if you have a dir that you want your lists saved to.
 *  Make sure to NOT have a trailing / on it. 
 */

//#define LISTDIR "/lists"

#define YESCOLOR COLOR_CYAN 
#define NOCOLOR  COLOR_BLUE
#define NORMAL	 COLOR_BLACK

/*
 * define BOLD to A_BOLD if you want to turn bright colors on
 * define BOLD to 0      if you want to turn bright colors off
 */

#define BOLD	 A_BOLD

#define YES 1
#define NO 0
#define ERROR -1

#include<stdio.h>
#include<stdlib.h>
#include<ctype.h>
#include<ncurses.h>
#include<time.h>
#include<unistd.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>
                     

char *version="0.8";

char *mp3player="splay";

/* Expansion Later */

char *mp2player="null";
char *mp1player="null";
char *wavplayer="wavplay";

struct filedata {
	char filename[1024];
	int toggled;
};

int filedatasize=sizeof(filedata);

class stuff {
	private:
	filedata *files;
	int totalfiles,location,repeat,random,page;
	WINDOW *screen;	
	time_t time_info;

	public:
	int screeny;

	stuff(void);
	~stuff(void);
	int total(void);
	
	// File Functions    -- Groups to be split up later
	void rdir(char dir[]);
	int loaddir(void);
	void toggle(int *field);
	int save(char *filename);
	int load(char *filename);
	
	// Display Functions
	void goxy(int x, int y);
	void dispstr(int attrs, int x, int y, char *msg);
	void dispdir(int start, int stop);	

	// Interaction Functions
	void handleinput(void);
	void playlist(void);		
	void playrand(void);
	void order(int tolocation, int fromlocation);

	// Random Functions
	void initrand(void);
	int gimmerand(float total);	
	void swap(filedata *one, filedata *two);


};	

