##############################################################################
##     Filename:  bind.tcl                              
##
## Descripition:  Sets Display Event Binds
##
##   Procedures:  setBindings
##
##---------------------------------------------------------------------------# 
##                                       
## Revision 1.1  1998/20/04  01:00:00  Mark C. Mains
## Initial revision                                     
##                                       
##############################################################################
proc setBindings {} \
{
	bind .canvas.display <3> { catch {tk_popup .menu.pop %X %Y} }
	.canvas.display bind repeat <1> \
	{
		global status
		set repeat $status(repeat)

		set repeat [expr $repeat+1]
		if {$repeat == 3} { set repeat 0 }

		set status(repeat) $repeat
		set_repeat
	}
	.canvas.display bind shuffle <1> \
	{
		global status

		if {$status(shuffle) == 0} { 
			set status(shuffle) 1
		} else {
			set status(shuffle) 0
		}

		set_shuffle
	}
	.canvas.display bind time <1> \
	{
		global status

		if {$status(play) == 1 && $status(pause) == 0} \
		{
			if {$status(timeleft) == 0} { 
				set status(timeleft) 1
			} else {
				set status(timeleft) 0
			}

			set_time {}
		}
	}
}
##############################################################################
