##############################################################################
##     Filename:  dialog.tcl  
##
## Descripition:  Display Dialog Error Messages
##
##   Procedures:  displayError
##
##---------------------------------------------------------------------------#
##
## Revision 1.1  1998/20/04  01:00:00  Mark C. Mains
## Initial revision
##
##############################################################################
proc displayError {mesg} \
{
	global defaults

	toplevel .dialog
	wm title .dialog "Error in Audio Control"
	wm resizable .dialog false false

	frame .dialog.error -borderwidth 2 -relief groove
	pack .dialog.error

	label .dialog.error.bitmap -bitmap error
	label .dialog.error.msg  -font $defaults(ERRORfont) -text \
		"ERROR:  $mesg" -width [expr [string length $mesg]+10]

	pack .dialog.error.bitmap -side left -padx 8 -pady 5
	pack .dialog.error.msg    -side top  -padx 8 -pady 8

	button .dialog.ok -text OK -command "destroy .dialog" -width 5
	pack .dialog.ok -side top -ipadx 0 -ipady 0 -padx 2 -pady 8

	catch {grab .dialog}
	tkwait window .dialog
}
##############################################################################
