##############################################################################
##     Filename:  display.tcl  
##
## Descripition:  Draws Display and Defines Commands Strictly For Display
##                Manipulation
##
##   Procedures:  createDisplay
##                createNumber
##                createMiniNumber
##                setNumber
##                set_rate
##                set_freq
##                set_time
##                set_layer
##                set_stereo
##                set_repeat
##                set_shuffle
##                set_song
##                clear_status
##                clear_display
##                update_display
##                display_shuffle
##                random
##
##---------------------------------------------------------------------------#
##
## Revision 1.1  1998/20/04  01:00:00  Mark C. Mains
## Initial revision
##
##############################################################################
proc createDisplay {} \
{
	global defaults

	frame .canvas -borderwidth 2 -relief groove
	pack .canvas -padx 2 -pady 2 -side top

	canvas .canvas.display -width 265 -height 145 -borderwidth 2 \
		-relief sunken -highlightthickness 0
	.canvas.display create rectangle 0 0 267 147 -outline {} -fill black
	pack .canvas.display -padx 3 -pady 3

	#-- Displays Kbps and KHz Text --#
	set defaults(songdisplay) [.canvas.display create text 134 15 \
		-text {} -font 6x13 -fill $defaults(colorON) -tags display]

	#-- Displays Stereo Bitmaps --#
	set defaults(stereo) [.canvas.display create bitmap 232 132 -bitmap \
		@$defaults(bmppath)/stereo.xbm \
		-background $defaults(stcolorOFF) -foreground black]
	set defaults(mono) [.canvas.display create bitmap 232 132 -bitmap \
		@$defaults(bmppath)/mono.xbm \
		-background $defaults(stcolorOFF) -foreground black]

	#-- Sets the Time Bind Box --#
	.canvas.display create rectangle 15 40 177 100 -outline {} \
		-fill black -tags time

	#-- Displays Song Number Bitmaps --#
	createNumber Time_TenMins 30 70
	createNumber Time_OneMins 70 70
	createNumber Time_TenSecs 120 70
	createNumber Time_OneSecs 160 70

	#-- Displays Kbps Number Bitmaps --#
	createMiniNumber Rate_Hunds 25 130
	createMiniNumber Rate_Tens 38 130
	createMiniNumber Rate_Ones 51 130

	#-- Displays KHz Number Bitmaps --#
	createMiniNumber Freq_Tens 122 130
	createMiniNumber Freq_Ones 135 130

	#-- Displays Time Colon Bitmaps --#
	.canvas.display create rectangle 93 58 98 63 \
		-outline {} -fill $defaults(colorON) -tags display
	.canvas.display create rectangle 93 78 98 83 \
		-outline {} -fill $defaults(colorON) -tags display

	#-- Displays Kbps and KHz Text --#
	.canvas.display create text 78 135  -text Kbps -font 7x14 -fill \
		$defaults(colorON) -tags display
	.canvas.display create text 157 135 -text KHz  -font 7x14 -fill \
		$defaults(colorON) -tags display

	#-- Displays Repeat Text --#
	set defaults(repeat) [.canvas.display create text 227 98 -text Repeat \
		-font 6x13 -fill $defaults(colorOFF) -tags repeat]
	set defaults(repeat1) [.canvas.display create text 252 98 -text 1 \
		-font 6x13 -fill $defaults(colorOFF) -tags repeat]

	#-- Displays Shuffle Text --#
	set defaults(shuffle) [.canvas.display create text 231 80 -text Shuffle \
		-font 6x13 -fill $defaults(colorOFF) -tags shuffle]

	#-- Displays Layer Text --#
	.canvas.display create text 232 43 -text Layer -font 6x13 -fill \
		$defaults(colorON) -tags display
	set defaults(layer1) [.canvas.display create text 223 63 -text 1   \
		-font 6x13 -fill $defaults(colorOFF)]
	set defaults(layer2) [.canvas.display create text 231 61 -text 2   \
		-font 6x13 -fill $defaults(colorOFF)]
	set defaults(layer3) [.canvas.display create text 240 58 -text 3   \
		-font 6x13 -fill $defaults(colorOFF)]
}
##############################################################################
proc createMiniNumber {name x y} \
{
	global defaults
	upvar #0 $name seg

	set seg(1) [.canvas.display create bitmap $x [expr $y-9] \
		-bitmap @$defaults(bmppath)/mini-top.xbm \
		-background $defaults(colorOFF) -foreground black]
	set seg(2) [.canvas.display create bitmap [expr $x+5] [expr $y-5] \
		-bitmap @$defaults(bmppath)/mini-right.xbm \
		-background $defaults(colorOFF) -foreground black]
	set seg(3) [.canvas.display create bitmap [expr $x+5] [expr $y+4] \
		-bitmap @$defaults(bmppath)/mini-right.xbm \
		-background $defaults(colorOFF) -foreground black]
	set seg(4) [.canvas.display create bitmap $x [expr $y+9] \
		-bitmap @$defaults(bmppath)/mini-bottom.xbm \
		-background $defaults(colorOFF) -foreground black]
	set seg(5) [.canvas.display create bitmap [expr $x-4] [expr $y+4] \
		-bitmap @$defaults(bmppath)/mini-left.xbm \
		-background $defaults(colorOFF) -foreground black]
	set seg(6) [.canvas.display create bitmap [expr $x-4] [expr $y-5] \
		-bitmap @$defaults(bmppath)/mini-left.xbm \
		-background $defaults(colorOFF) -foreground black]
	set seg(7) [.canvas.display create bitmap $x $y \
		-bitmap @$defaults(bmppath)/mini-bottom.xbm \
		-background $defaults(colorOFF) -foreground black]
}
##############################################################################
proc createNumber {name x y} \
{
	global defaults
	upvar #0 $name seg

	set seg(1) [.canvas.display create bitmap $x [expr $y-27] \
		-bitmap @$defaults(bmppath)/middle.xbm -background $defaults(colorOFF) \
		-foreground black -tags time]
	set seg(2) [.canvas.display create bitmap [expr $x+14] [expr $y-13] \
		-bitmap @$defaults(bmppath)/right.xbm -background $defaults(colorOFF) \
		-foreground black -tags time]
	set seg(3) [.canvas.display create bitmap [expr $x+14] [expr $y+13] \
		-bitmap @$defaults(bmppath)/right.xbm -background $defaults(colorOFF) \
		-foreground black -tags time]
	set seg(4) [.canvas.display create bitmap $x [expr $y+27] \
		-bitmap @$defaults(bmppath)/middle.xbm -background $defaults(colorOFF) \
		-foreground black -tags time]
	set seg(5) [.canvas.display create bitmap [expr $x-13] [expr $y+14] \
		-bitmap @$defaults(bmppath)/left.xbm -background $defaults(colorOFF) \
		-foreground black -tags time]
	set seg(6) [.canvas.display create bitmap [expr $x-13] [expr $y-13] \
		-bitmap @$defaults(bmppath)/left.xbm -background $defaults(colorOFF) \
		-foreground black -tags time]
	set seg(7) [.canvas.display create bitmap $x $y \
		-bitmap @$defaults(bmppath)/middle.xbm -background $defaults(colorOFF) \
		-foreground black -tags time]
}
##############################################################################
proc setNumber {name value} \
{
	global defaults
	global number
	upvar #0 $name seg

	for {set i 1} {$i<=7} {incr i} \
	{
		set color "color[lindex $number($value) [expr $i-1]]"
		.canvas.display itemconfigure $seg($i) -background $defaults($color)
	}
}
##############################################################################
proc set_rate {clear} \
{
	global status
	set num $status(rate)

	if {$clear == "clear"} \
	{
		setNumber Rate_Hunds CLEAR
		setNumber Rate_Tens  CLEAR
		setNumber Rate_Ones  CLEAR

		return
	}

	set hunds [expr $num/100]
	set tens [expr [expr $num-[expr $hunds*100]]/10]
	set ones [expr [expr $num-[expr $hunds*100]]-[expr $tens*10]]
	
	if {$hunds!=0} {
		setNumber Rate_Hunds $hunds
	}
	setNumber Rate_Tens $tens
	setNumber Rate_Ones $ones
}
##############################################################################
proc set_freq {clear} \
{
	global status
	set num $status(freq)

	if {$clear == "clear"} \
	{
		setNumber Freq_Tens CLEAR
		setNumber Freq_Ones CLEAR

		return
	}

	set num [expr $num/1000]
	set tens [expr $num/10]
	set ones [expr $num-[expr $tens*10]]

	setNumber Freq_Tens $tens
	setNumber Freq_Ones $ones
}
##############################################################################
proc set_time {clear} \
{
	global status
	set num $status(time)

	if {$clear == "clear"} \
	{
		setNumber Time_TenMins CLEAR
		setNumber Time_OneMins CLEAR
		setNumber Time_TenSecs CLEAR
		setNumber Time_OneSecs CLEAR

		update idletasks
		return
	}

	set minutes [expr $num/60]
	set seconds [expr $num%60]

	set tenMins [expr $minutes/10]
	set oneMins [expr $minutes-[expr $tenMins*10]]
	set tenSecs [expr $seconds/10]
	set oneSecs [expr $seconds-[expr $tenSecs*10]]

	if {$tenMins!=0} {
		setNumber Time_TenMins $tenMins
	} elseif {$status(timeleft) == 1} {
		setNumber Time_TenMins NEG
	} else {
		setNumber Time_TenMins CLEAR
	}

	setNumber Time_OneMins $oneMins
	setNumber Time_TenSecs $tenSecs
	setNumber Time_OneSecs $oneSecs

	update idletasks
}
##############################################################################
proc set_layer {clear} \
{
	global defaults
	global status
	set num $status(layer)

	if {$clear == "clear"} \
	{
		.canvas.display itemconfigure $defaults(layer1) -fill \
			$defaults(colorOFF)
		.canvas.display itemconfigure $defaults(layer2) -fill \
			$defaults(colorOFF)
		.canvas.display itemconfigure $defaults(layer3) -fill \
			$defaults(colorOFF)
	}

	switch $num {
		1 { .canvas.display itemconfigure $defaults(layer1) -fill \
				$defaults(colorON)}
		2 { .canvas.display itemconfigure $defaults(layer2) -fill \
				$defaults(colorON)}
		3 { .canvas.display itemconfigure $defaults(layer3) -fill \
				$defaults(colorON)}
	}
}
##############################################################################
proc set_stereo {clear} \
{
	global defaults
	global status
	set num $status(stereo)

	if {$clear == "clear"} \
	{
		.canvas.display itemconfigure $defaults(mono)  \
			-background $defaults(stcolorOFF)
		.canvas.display itemconfigure $defaults(stereo) \
			-background $defaults(stcolorOFF)
	}

	if {$num == 1 | $num == 2} {
		.canvas.display itemconfigure $defaults(mono) -background \
			$defaults(stcolorON)
	}
	if {$num == 2} {
		.canvas.display itemconfigure $defaults(stereo) \
			-background $defaults(stcolorON)
	}
}
##############################################################################
proc set_repeat {} \
{
	global defaults
	global status
	set num $status(repeat)

	.canvas.display itemconfigure $defaults(repeat)  -fill $defaults(colorOFF) 
    .canvas.display itemconfigure $defaults(repeat1) -fill $defaults(colorOFF)

	if {$num == 1 | $num == 2} {
		.canvas.display itemconfigure $defaults(repeat) -fill \
			$defaults(colorON)
	}
	if {$num == 2} {
		.canvas.display itemconfigure $defaults(repeat1) -fill \
			$defaults(colorON)
	}
}
##############################################################################
proc set_shuffle {} \
{
	global defaults
	global status
	set num $status(shuffle)

	if {$num == 1} {
		.canvas.display itemconfigure $defaults(shuffle) -fill \
			$defaults(colorON)
	} else {
		.canvas.display itemconfigure $defaults(shuffle) -fill \
			$defaults(colorOFF)
	}
}
##############################################################################
proc set_song {clear} \
{
	global defaults
	global status

	if {$clear == "clear"} \
	{
		.canvas.display itemconfigure $defaults(songdisplay) -text {}
	} else {
		.canvas.display itemconfigure $defaults(songdisplay) -text \
			$status(songtitle)
	}
}
##############################################################################
proc clear_status {} \
{
	global status

    set status(songtitle) {}
    set status(song_pos)  0
    set status(blink)     0
    set status(rate)      0
    set status(freq)      0
    set status(layer)     0
    set status(stereo)    0
    set status(time)      0
    set status(totaltime) 0
    set status(BPF)       0
    set status(frame)     0
    set status(play)      0
    set status(pause)     0
	set status(pid)       0

	enableGain
}
##############################################################################
proc clear_display {} \
{
	global defaults
	global status

	.canvas.display itemconfigure display -fill $defaults(colorON)

	FAKESPEC   clear

	set_song   clear
	set_rate   clear
	set_freq   clear
	set_time   clear
	set_layer  clear
	set_stereo clear
	set_repeat
	set_shuffle
}
##############################################################################
proc update_display {} \
{
	global defaults

	set_song   {}
	set_rate   {}
	set_freq   {}
	set_time   {}
	set_layer  {}
	set_stereo {}
	set_repeat
	set_shuffle
}
##############################################################################
proc display_shuffle {} \
{
	global defaults

	set loop $defaults(shuff_loop)

	for {set i 0} {$i < $loop} {incr i} \
	{
		foreach ani {SUF1 SUF2 SUF3 SUF4 SUF5 SUF6} {
			foreach num {Rate_Hunds Rate_Tens Rate_Ones \
						Freq_Tens Freq_Ones Time_TenMins \
						Time_OneMins Time_TenSecs Time_OneSecs} \
			{
				setNumber $num $ani
			}
			update idletasks
			after 50
		}
	}
	clear_display
}
##############################################################################
