##############################################################################
##     Filename:  gain.tcl  
##
## Descripition:  Draws Gain Bar and Defines Commands Strictly For Gain
##                Manipulation
##
##   Procedures:  createGain
##                hideGain
##                showGain
##                enableGain
##                disableGain
##
##---------------------------------------------------------------------------#
##
## Revision 1.1  1998/20/04  01:00:00  Mark C. Mains
## Initial revision
##
##############################################################################
proc createGain {} \
{
	global defaults

	frame .gain -borderwidth 2 -relief groove
	if {$defaults(GAINshow) == 1} {
		.menu.pop.setup entryconfigure 0 -label " Hide Gain Bar"
		pack .gain -side top
	}

    label .gain.label -font $defaults(font2) -text GAIN
    pack .gain.label -padx 3 -side left

    scale .gain.bar -troughcolor black -length 231 \
		-from $defaults(GAINmin) -to $defaults(GAINmax) \
        -orient horizontal -showvalue 0 -highlightthickness 0 \
        -variable defaults(GAINset)
    pack .gain.bar -padx 2 -pady 2 -side left
}
##############################################################################
proc hideGain {} \
{
	global defaults

	pack forget .gain
	set defaults(GAINshow) 0
}
##############################################################################
proc showGain {} \
{
	global defaults

	pack .gain -side top -after .controls
	set defaults(GAINshow) 1
}
##############################################################################
proc enableGain {} \
{
    .gain.bar configure -state normal
}
##############################################################################
proc disableGain {} \
{
    .gain.bar configure -state disabled
}
##############################################################################
