##############################################################################
##     Filename:  init.tcl  
##
## Descripition:  Initializes Globals and Read Default File
##
##   Procedures:  Initialize
##                load_defaults
##                save_defaults
##
##---------------------------------------------------------------------------#
##
## Revision 1.1  1998/20/04  01:00:00  Mark C. Mains
## Initial revision
##
##############################################################################
proc Initialize {} \
{
	global env
	global status
	global colors
	global number
	global defaults
	global mp3playrc

	set defaults(platform) [exec uname]

	if {$defaults(platform) == "HP-UX"} {
		set colors(orangeON)      #ffaa00
		set colors(orangeOFF)     #443300
		set colors(greenON)       #00ff00
		set colors(greenOFF)      #004400
		set colors(stereoON)      #ffff00
		set colors(stereoOFF)     #444400
		set colors(specRedON)     #ff0000
		set colors(specRedOFF)    #550000
		set colors(specYellowON)  #ffff00
		set colors(specYellowOFF) #555500
		set colors(specGreenON)   #00ff00
		set colors(specGreenOFF)  #005500
	} elseif {$defaults(platform) == "Linux"} {
		set colors(orangeON)      #ffaa00
		set colors(orangeOFF)     #332200
		set colors(greenON)       #00ff00
		set colors(greenOFF)      #003300
		set colors(stereoON)      #ffff00
		set colors(stereoOFF)     #333300
		set colors(specRedON)     #ff0000
		set colors(specRedOFF)    #440000
		set colors(specYellowON)  #ffff00
		set colors(specYellowOFF) #444400
		set colors(specGreenON)   #00ff00
		set colors(specGreenOFF)  #004400
	}

	set defaults(ParameterList) {
		song_dir
		list_dir
		COLOR
		SPECshow
		GAINshow
		GAINset
		output
	}

	load_defaults

	set defaults(updateMS)   50
	set defaults(colorON)    $colors($defaults(COLOR)ON)
	set defaults(colorOFF)   $colors($defaults(COLOR)OFF)
	set defaults(player)     "mpg123"
	set defaults(bmppath)    "$env(MP3PLAY_DIR)/xbm"
	set defaults(tmppath)    "/tmp"
	set defaults(MP3pid)     [pid]
	set defaults(font)       6x13
	set defaults(font2)      6x13bold
	set defaults(ERRORfont)  "-adobe-times-bold-r-normal--14-140-75-75-*-77-*-1"
	set defaults(shuff_loop) 7
	set defaults(randomSeed) 0
	set defaults(stcolorON)  $colors(stereoON)
	set defaults(stcolorOFF) $colors(stereoOFF)

	if {$defaults(platform) == "HP-UX"} {
		set defaults(SIGSTOP)    24
		set defaults(SIGCONT)    26
		set defaults(GAINmin)    -50
		set defaults(GAINmax)    50
	} elseif {$defaults(platform) == "Linux"} {
		set defaults(SIGSTOP)    19
		set defaults(SIGCONT)    18
		set defaults(GAINmin)    0
		set defaults(GAINmax)    100
	}

	set defaults(specX)       7
	set defaults(specY)       3
	set defaults(specColSpc)  16
	set defaults(specCols)    16
	set defaults(specColsThk) 2
	set defaults(specVertSpc) 5
	set defaults(specHorzLen) 15
	set defaults(Color0_OFF)  $colors(specRedOFF)
	set defaults(Color1_OFF)  $colors(specRedOFF)
	set defaults(Color2_OFF)  $colors(specYellowOFF)
	set defaults(Color3_OFF)  $colors(specYellowOFF)
	set defaults(Color4_OFF)  $colors(specYellowOFF)
	set defaults(Color5_OFF)  $colors(specGreenOFF)
	set defaults(Color6_OFF)  $colors(specGreenOFF)
	set defaults(Color7_OFF)  $colors(specGreenOFF)
	set defaults(Color8_OFF)  $colors(specGreenOFF)
	set defaults(Color0_ON)   $colors(specRedON)
	set defaults(Color1_ON)   $colors(specRedON)
	set defaults(Color2_ON)   $colors(specYellowON)
	set defaults(Color3_ON)   $colors(specYellowON)
	set defaults(Color4_ON)   $colors(specYellowON)
	set defaults(Color5_ON)   $colors(specGreenON)
	set defaults(Color6_ON)   $colors(specGreenON)
	set defaults(Color7_ON)   $colors(specGreenON)
	set defaults(Color8_ON)   $colors(specGreenON)

	set status(fileSelect) {}
	set status(songtitle)  {}
	set status(playlist)   {}
	set status(templist)   {}
	set status(shufflist)  {}
	set status(list_index) 0
	set status(song_pos)   0
	set status(blink)      0
	set status(rate)       0
	set status(freq)       0
	set status(layer)      0
	set status(stereo)     0
	set status(time)       0
	set status(timeleft)   0
	set status(totaltime)  0
	set status(updatetime) 0
	set status(BPF)        0
	set status(frame)      0
	set status(repeat)     0
	set status(shuffle)    0
	set status(play)       0
	set status(pause)      0

	set number(1)     {OFF ON  ON  OFF OFF OFF OFF}
	set number(2)     {ON  ON  OFF ON  ON  OFF ON }
	set number(3)     {ON  ON  ON  ON  OFF OFF ON }
	set number(4)     {OFF ON  ON  OFF OFF ON  ON }
	set number(5)     {ON  OFF ON  ON  OFF ON  ON }
	set number(6)     {ON  OFF ON  ON  ON  ON  ON }
	set number(7)     {ON  ON  ON  OFF OFF OFF OFF}
	set number(8)     {ON  ON  ON  ON  ON  ON  ON }
	set number(9)     {ON  ON  ON  ON  OFF ON  ON }
	set number(0)     {ON  ON  ON  ON  ON  ON  OFF}
	set number(SUF1)  {OFF ON  ON  ON  ON  ON  OFF}
	set number(SUF2)  {ON  OFF ON  ON  ON  ON  OFF}
	set number(SUF3)  {ON  ON  OFF ON  ON  ON  OFF}
	set number(SUF4)  {ON  ON  ON  OFF ON  ON  OFF}
	set number(SUF5)  {ON  ON  ON  ON  OFF ON  OFF}
	set number(SUF6)  {ON  ON  ON  ON  ON  OFF OFF}
	set number(NEG)   {OFF OFF OFF OFF OFF OFF ON }
	set number(CLEAR) {OFF OFF OFF OFF OFF OFF OFF}
}
##############################################################################
proc load_defaults {} \
{
	global defaults
	global version
	global mp3playrc

	set loaded 0

	if {[file isfile $mp3playrc]} {
		set file [open $mp3playrc r]
		while {[gets $file line] >= 0} {
			set parameter [lindex $line 0]
			set setting   [lindex $line 1]

			if {[string match $parameter MP3Play] && \
				[string match $setting $version]} \
			{
				set loaded 1
			} else {
				set defaults($parameter) $setting
			}
		}
		close $file
	}

	if {$loaded == 0} {
		set defaults(song_dir)   [pwd]
		set defaults(list_dir)   [pwd]
		set defaults(COLOR)      orange
		set defaults(SPECshow)   0
		set defaults(GAINshow)   0

		if {$defaults(platform) == "HP-UX"} {
			set defaults(GAINset)    50
			set defaults(output)     oh
		} elseif {$defaults(platform) == "Linux"} {
			set defaults(GAINset)    100
			set defaults(output)     os
		}
	}
}
##############################################################################
proc save_defaults {} \
{
	global defaults
	global version
	global mp3playrc

	set file [open $mp3playrc w]
	puts $file "MP3Play $version"

	foreach parameter $defaults(ParameterList) {
		puts $file "$parameter $defaults($parameter)"
	}
	close $file
}
##############################################################################
