##############################################################################
##     Filename:  list.tcl  
##
## Descripition:  Defines Play List Commands
##
##   Procedures:  add_file
##                remove_file
##                play_song
##                next_song
##                next_shuff
##                prev_song
##                load_list
##                save_list
##                swap_songs
##                random
##
##---------------------------------------------------------------------------#
##
## Revision 1.1  1998/20/04  01:00:00  Mark C. Mains
## Initial revision
##
##############################################################################
proc add_file {file list} \
{
	global status

	if {$file == "clear"} {
		catch {set status($list) [lreplace $status($list) 0 end]}
#		set status(list_index) 0

	} else {
		set status($list) [linsert $status($list) end "$file"]
	}
}
##############################################################################
proc remove_file {index list} \
{
	global status

	set status($list)  [lreplace $status($list) $index $index]
}
##############################################################################
proc play_song {} \
{
	global status

	# List Empty
    if {[llength $status(playlist)] == 0} {
        displayError "No File(s) Selected!"
        return
    }
    
	# Paused, UNPause It
    if {$status(pause) == 1} {
        pause_file
        return
    }
    
	# Already Playing, Do Nothing
    if {$status(play) == 1} { return }

	# If Shuffle, Select Random and Play 
	if {$status(shuffle) == 1} {
		next_shuff

	# Just Play the Dang Thang
	} else {
		play_file
	}
}
##############################################################################
proc next_song {} \
{
	global status

	# If Shuffle, Select Random and Play
	if {$status(shuffle) == 1} {
		next_shuff
		return
	}

	# More Songs in List
	if {$status(list_index) < [expr [llength $status(playlist)]-1]} {
		if {$status(play)==1} {
			incr status(list_index)

		} elseif {$status(repeat)!=2} {
			incr status(list_index)
		}
    	if {$status(play) == 1} { stop_file }
		play_file


	# End of List, which is > 1
	} elseif {$status(play)!=1} {

		if {$status(repeat)==1} {
			set status(list_index) 0
    		if {$status(play) == 1} { stop_file }
			play_file

		} elseif {$status(repeat)==2} {
    		if {$status(play) == 1} { stop_file }
			play_file

		} else {
			set status(list_index) 0
		}
	}
}
##############################################################################
proc next_shuff {} \
{
	global status

   	if {$status(play) == 1} { stop_file }

	if {$status(repeat)==2} {
    	if {$status(play) == 1} { stop_file }
		play_file
		return
	}

	if {[llength $status(playlist)] == [llength $status(shufflist)]} {
		add_file clear shufflist
		if {$status(repeat)!=1} { return }
	}

	set FOUND 1
	while {$FOUND == 1} {
		set FOUND 0
		set status(list_index) [random [llength $status(playlist)] 0]
		foreach song $status(shufflist) {
			if {$song == $status(list_index)} { set FOUND 1 }
		}
	}
	set status(shufflist) [linsert $status(shufflist) end $status(list_index)]

	display_shuffle
	play_file
}
##############################################################################
proc prev_song {} \
{
	global status

	# If Song is Paused Do Nothing
	if {$status(pause) == 1} { return }

	# Set Time into Song
	if {$status(timeleft) == 1} {
		set seconds [expr $status(totaltime)-$status(time)]
	} else {
		set seconds $status(time)
	}

	# Greater Than 10 Seconds into Song, Reset Song
	if {$seconds > 0 || $status(shuffle) == 1} {
   		if {$status(play) == 1} { stop_file }
		play_file

	} else {
		# Not Begining of List
		if {$status(list_index) > 0} {
			incr status(list_index) -1
   			if {$status(play) == 1} { stop_file }
			play_file
		}
	}
}
##############################################################################
proc load_list {filename list} \
{
	global status

	# Clear List
	add_file clear $list

	set playlist [open $filename r]
	while {[gets $playlist file] >=0} {
		add_file $file $list
	}
	close $playlist
}
##############################################################################
proc save_list {filename} \
{
	global status

	# Make Sure File Ends With 'lst' Extension
	if {[file extension $filename] == ".lst"} {
		set save_file $filename
	} else {
		set save_file "$filename.lst"
	}

	set playlist [open $save_file w]
	foreach song $status(templist) {
		puts $playlist $song
	}
	close $playlist
}
##############################################################################
proc swap_songs {first second list} \
{
	global status

	set temp [lindex $status($list) $first]
	set status($list) [lreplace $status($list) $first $first \
		"[lindex $status($list) $second]"]
	set status($list) [lreplace $status($list) $second $second $temp]
}
##############################################################################
proc random {{max 1.0} {min 0.0}} \
{
	global defaults

	set defaults(randomSeed) [clock clicks]

	set defaults(randomSeed) [expr (7141*$defaults(randomSeed)+54773) % 259200]
	set num  [expr $defaults(randomSeed)/259200.0*($max-$min)+$min]
	return [expr int($num)]
}
##############################################################################
