##############################################################################
##     Filename:  menu.tcl  
##
## Descripition:  Creates Menu Bar for Display
##
##   Procedures:  createMenuBar
##
##---------------------------------------------------------------------------#
##
## Revision 1.1  1998/20/04  01:00:00  Mark C. Mains
## Initial revision
##
##############################################################################
proc createMenuBar {} \
{
   global defaults
 
   if {![winfo exists .menu]} { frame .menu }

   # create the menu bar frame
   menu .menu.pop -font $defaults(font) -tearoff false

   .menu.pop add cascade -label " File  " -menu .menu.pop.file
   .menu.pop add cascade -label " Color " -menu .menu.pop.color
   .menu.pop add cascade -label " Setup " -menu .menu.pop.setup
   .menu.pop add cascade -label " Help  " -menu .menu.pop.help

   # create the file menu for menu.pop
   menu .menu.pop.file -font $defaults(font) -tearoff false
   .menu.pop.file add command -label " Play a Song" -command \
		{
			load_file $defaults(song_dir) "*.mp3"

			if {$status(fileSelect) != ""} {
				set defaults(song_dir) [file dirname $status(fileSelect)]

				add_file clear playlist
				add_file clear shufflist
				add_file "$status(fileSelect)" playlist
				if {$status(play) == 1} { stop_file }
				play_song
			}
		}
   .menu.pop.file add command -label " Play a List" -command \
		{
			load_file $defaults(list_dir) "*.lst"

			if {$status(fileSelect) != ""} {
				set defaults(list_dir) [file dirname $status(fileSelect)]

				load_list "$status(fileSelect)" playlist
				if {$status(play) == 1} { stop_file }
				add_file clear shufflist
				play_song
			}
		}
   .menu.pop.file add command -label " Build a List" -command \
		{
			build_list $defaults(song_dir) "*.mp3"

			if {$status(fileSelect) == "NEWLIST"} {
				if {$status(play) == 1} { stop_file }
				add_file clear shufflist
				play_song
			}
		}

   # create the color menu for menu.pop
   menu .menu.pop.color -font $defaults(font) -tearoff false
   .menu.pop.color add radiobutton -label " Green" -variable defaults(COLOR) \
		-value green -command \
		{
			if {$defaults(colorON) == $colors(orangeON)} \
			{
				set defaults(colorON) $colors(greenON)
				set defaults(colorOFF) $colors(greenOFF)
			}
			clear_display
			if {$status(play) == 1} { update_display }
		}
   .menu.pop.color add radiobutton -label " Orange" -variable defaults(COLOR) \
		-value orange -command \
		{
			if {$defaults(colorON) == $colors(greenON)} \
			{
				set defaults(colorON) $colors(orangeON)
				set defaults(colorOFF) $colors(orangeOFF)
			}
			clear_display
			if {$status(play) == 1} { update_display }
		}

   # create the setup menu for menu.pop
   menu .menu.pop.setup -font $defaults(font) -tearoff false
   .menu.pop.setup add command -label " Show Gain Bar" -command \
		{
			if {$defaults(GAINshow) == 1} {
				.menu.pop.setup entryconfigure 0 -label " Show Gain Bar"
				hideGain
			} else {
				.menu.pop.setup entryconfigure 0 -label " Hide Gain Bar"
				showGain
			}
		}
   .menu.pop.setup add command -label " Show Spectrum" -command \
		{
			if {$defaults(SPECshow) == 1} {
				.menu.pop.setup entryconfigure 1 -label " Show Spectrum"
				hideSpectrum
			} else {
				.menu.pop.setup entryconfigure 1 -label " Hide Spectrum"
				showSpectrum
			}
		}
   .menu.pop.setup add cascade -label " Set Output" -menu \
		.menu.pop.setup.outputs
   .menu.pop.setup add separator
   .menu.pop.setup add command -label " Save Defaults" -command \
		{
			save_defaults
		}

   # create the help menu for menu.pop
   menu .menu.pop.help -font $defaults(font) -tearoff false
   .menu.pop.help add command -label " About" -command { aboutMP3Play }


   # create the output menu for menu.pop.setup
   menu .menu.pop.setup.outputs -font $defaults(font) -tearoff false
   .menu.pop.setup.outputs add radiobutton -label " Line Out" -variable \
		defaults(output) -value ol
   .menu.pop.setup.outputs add radiobutton -label " Speaker" -variable \
		defaults(output) -value os
   .menu.pop.setup.outputs add radiobutton -label " HeadPhones" -variable \
		defaults(output) -value oh
}
##############################################################################
