##############################################################################
##     Filename:  specturm.tcl  
##
## Descripition:  Draws Spectrum Graph and Defines Commands Strictly For the
##                Spectrum Manipulation
##
##   Procedures:  createSpectrum
##                hideSpectrum
##                showSpectrum
##
##---------------------------------------------------------------------------#
##
## Revision 1.1  1998/20/04  01:00:00  Mark C. Mains
## Initial revision
##
##############################################################################
proc createSpectrum {} \
{
	global defaults

	frame .spectrum -borderwidth 2 -relief groove
	if {$defaults(SPECshow) == 1} {
		.menu.pop.setup entryconfigure 1 -label " Hide Spectrum"
		showSpectrum
	}

	canvas .spectrum.scope -width 267 -height 45 -borderwidth 2 \
		-relief sunken -highlightthickness 0
    .spectrum.scope create rectangle 0 0 269 47 -outline {} -fill black
	pack .spectrum.scope -padx 2 -pady 2

	# Create Spectrum
	for {set i 0} {$i<$defaults(specCols)} {incr i} {
		CreateSpectrumBar $i [expr [expr $i*$defaults(specColSpc)] + \
			$defaults(specX)] $defaults(specY)
	}
}
##############################################################################
proc hideSpectrum {} \
{
	global defaults

	pack forget .spectrum
	set defaults(SPECshow) 0
}
##############################################################################
proc showSpectrum {} \
{
	global defaults

	if {$defaults(GAINshow) == 1} {
		pack .spectrum -side top -after .gain
	} else {
		pack .spectrum -side top -after .controls
	}

	set defaults(SPECshow) 1
}
##############################################################################
proc CreateSpectrumBar {tag x y} \
{
	global defaults

	set x1 $x
	set x2 [expr $x+$defaults(specHorzLen)]

	for {set i 0} {$i<9} {incr i} {
		set y1 [expr [expr $i*$defaults(specVertSpc)]+$y]
		set y2 [expr $y1+$defaults(specColsThk)]
    	.spectrum.scope create rectangle $x1 $y1 $x2 $y2 \
			-outline {} -fill $defaults(Color${i}_OFF) -tags COL${tag}_${i}
	}
}
##############################################################################
proc SetSpectrumBar {tag num} \
{
	global defaults

	for {set i 0} {$i<[expr 9-$num]} {incr i} {
    	.spectrum.scope itemconfigure ${tag}_${i} -fill $defaults(Color${i}_OFF)
	}

	for {set i [expr 9-$num]} {$i<9} {incr i} {
    	.spectrum.scope itemconfigure ${tag}_${i} -fill $defaults(Color${i}_ON)
	}
}
##############################################################################
proc FAKESPEC {clear} \
{
	global defaults

	if {$clear == "clear"} {
		for {set i 0} {$i<$defaults(specCols)} {incr i} {
			SetSpectrumBar COL${i} 0
		}

	} else {
		for {set i 0} {$i<$defaults(specCols)} {incr i} {
			SetSpectrumBar COL${i} [random 10 0]
		}
	}
}
##############################################################################
