##############################################################################
##     Filename:  controls.tcl  
##
## Descripition:  Creates and Defines Controls Commands
##
##   Procedures:  createControls
##                play_file
##                stop_file
##                pause_file
##                update_time
##                blink_time
##
##---------------------------------------------------------------------------#
##
## Revision 1.1  1998/20/04  01:00:00  Mark C. Mains
## Initial revision
##
##############################################################################
proc createControls {} \
{
	global defaults
	global status

	frame .controls -borderwidth 2 -relief groove
	pack .controls -padx 2 -pady 2 -side top

	button .controls.revskip -bitmap @$defaults(bmppath)/revskip.xbm \
		-highlightthickness 0 -command \
		{ if {$status(play) == 1} { prev_song } }

	button .controls.play -bitmap @$defaults(bmppath)/play.xbm \
		-highlightthickness 0 -command { play_song }

	button .controls.pause -bitmap @$defaults(bmppath)/pause.xbm \
		-highlightthickness 0 -command \
		{ if {$status(play) == 1} { pause_file } }

	button .controls.stop -bitmap @$defaults(bmppath)/stop.xbm \
		-highlightthickness 0 -command \
		{ if {$status(play) == 1} { stop_file } }

	button .controls.forskip -bitmap @$defaults(bmppath)/forskip.xbm \
		-highlightthickness 0 -command \
		{ if {$status(play) == 1} { next_song } }

	button .controls.quit -bitmap @$defaults(bmppath)/eject.xbm \
		-highlightthickness 0 -command \
		{ _exit }

	#
	# Pack sub-assemblies of widgets:
	#
	pack .controls.revskip -side left -expand yes -padx 3 -pady 4
	pack .controls.play -side left -expand yes -padx 3 -pady 4
	pack .controls.pause -side left -expand yes -padx 3 -pady 4
	pack .controls.stop -side left -expand yes -padx 3 -pady 4
	pack .controls.forskip -side left -expand yes -padx 3 -pady 4
	pack .controls.quit -side left -expand yes -padx 3 -pady 4
}
##############################################################################
proc play_file {} \
{
	global defaults
	global status

	set filename [lindex $status(playlist) $status(list_index)]

	set code [catch {exec $defaults(player) -$defaults(output) -v -n 1 \
		$filename  2>$defaults(tmppath)/mp3_hdr.$defaults(MP3pid)}]
	if {$code != 0} {
		displayError "(1) Could not start audio player!"
		return
	}

	set title "[file tail $filename]"
	set size [file size $filename]
	set status(songtitle) "[file rootname $title]"
	
	set pattern1 "Layer:"
	set pattern2 "Bitrate:"

	set header [open $defaults(tmppath)/mp3_hdr.$defaults(MP3pid) r]
	while {[gets $header line] >= 0} {
		if {[regexp $pattern1 $line]} {
			set decode1 $line
		}
		if {[regexp $pattern2 $line]} {
			set decode2 $line
		}
	}
	close $header

	scan "$decode1" \
		"MPEG %f, Layer: %s Freq: %d, mode: %s modext: %d, BPF : %d" \
		null_1 layer freq mode null_2 BPF
	scan "$decode2" \
		"Bitrate: %d Kbits/s, Extension value: %d" \
		rate null_1

	set status(rate)      $rate
	set status(layer)     [expr [string length $layer]-1]
	set status(freq)      $freq
	set status(stereo)    [expr [regexp "Stereo" $mode]+1]
	set status(BPF)       $BPF
	set status(totaltime) [expr [expr [expr [expr $size*8]-44]/1024]/$rate]

	set code [catch {set status(pid) [exec $defaults(player) \
		-$defaults(output) -g $defaults(GAINset) -v -b 0 $filename \
		2>$defaults(tmppath)/mp3_bdy.$defaults(MP3pid) &]}]
	if {$code != 0} {
		displayError "(2) Could not start audio player!"
		clear_status
		return
	}

	set status(play) 1
	set status(time) 0

	disableGain

	update_display
	if {$status(updatetime) == 0} {
		update_time
	}
}
##############################################################################
proc stop_file {} \
{
	global defaults
	global status

	set code [catch {exec kill $status(pid) >&/dev/null}]
	if {$code != 0} {
		displayError "Could not stop audio!"
	}

	if {$status(pause) == 1} { pause_file }

	clear_status
	clear_display
}
##############################################################################
proc pause_file {} \
{
	global defaults
	global status

	if {$status(pause) == 1} {
		set code [catch {exec kill -$defaults(SIGCONT) \
			$status(pid) >&/dev/null}]
		if {$code != 0} {
			displayError "Could not unpause audio!"
		}
		set status(pause) 0

	} else {
		set code [catch {exec kill -$defaults(SIGSTOP) \
			$status(pid) >&/dev/null}]
		if {$code != 0} {
			displayError "Could not pause audio!"
		}
		set status(pause) 1
		blink_time
	}
}
##############################################################################
proc update_time {} \
{
	global defaults
	global status

	if {$status(play) != 1} \
	{
		set status(updatetime) 0

	} else {
		if {$status(pause) == 1} {
			after $defaults(updateMS) [list update_time]
			return
		}

		catch {set frame [lindex [exec tail -1 \
			$defaults(tmppath)/mp3_bdy.$defaults(MP3pid)] end]} { return }

		set status(frame) $frame

		if {$frame == "finished."} {
			set status(play) 0
			set status(updatetime) 0

			while {![catch {string match "" [exec ps -p $status(pid) \
				>&/dev/null]}]} {}
			clear_status
			clear_display
			next_song

		} else {
			if {$status(timeleft) == 1} {
				catch {set status(time) [expr $status(totaltime)-[expr [expr \
					[expr [expr $frame*$status(BPF)]*8]/1024]/$status(rate)]]}
				set status(song_pos) [expr 100*[expr 1-[expr \
					$status(time).0/$status(totaltime)]]]
			} else {
				catch {set status(time) [expr [expr [expr [expr \
					$frame*$status(BPF)]*8]/1024]/$status(rate)]}
				set status(song_pos) [expr 100*[expr \
					$status(time).0/$status(totaltime)]]
			}

			if {$defaults(SPECshow) == 1} {
				FAKESPEC {}
			}

			set status(updatetime) 1
			set_time {}

			after $defaults(updateMS) [list update_time]
		}
	}
}
##############################################################################
proc blink_time {} \
{
	global status

	if {$status(pause) == 1} \
	{
		if {$status(blink) == 0} {
			set status(blink) 1
			set_time clear
		} else {
			set status(blink) 0
			set_time {}
		}
		after 500 [list blink_time]

	} else {
		set status(blink) 0
		if {$status(play) == 1} { set_time {} }
	}
}
##############################################################################
