##############################################################################
##     Filename:  mp3play.tcl  
##
## Descripition:  Main Application Script for MP3Play
##
##   Procedures:  aboutMP3Play
##
##---------------------------------------------------------------------------#
##
## Revision 1.1  1998/20/04  01:00:00  Mark C. Mains
## Initial revision
##
##############################################################################
set auto_path [linsert $auto_path 0 $env(MP3PLAY_DIR)]
##############################################################################
proc aboutMP3Play {} \
{
	set mesg ""
	append mesg "\nReport any bugs or desired functionality\n"
	append mesg "  to Mark at the following address:\n"

	toplevel .about
	wm title .about "About MP3Play"
	wm resizable .about false false
	label .about.name  -text "\nMP3Play"
	label .about.ver   -text "Version 1.1"
	label .about.impl  -text "Written in Tcl/Tk"
	label .about.auth  -text "by Mark C. Mains"
	label .about.date  -text "5/7/98"
	label .about.msg   -text $mesg
	label .about.email -text "debug@cyberramp.net\n\n"
	pack  .about.name
	pack  .about.ver
	pack  .about.impl
	pack  .about.auth
	pack  .about.date
	pack  .about.msg
	pack  .about.email

	button .about.ok -text OK -width 5 -highlightthickness 0 \
		-command "destroy .about"
	pack .about.ok -side top -ipadx 0 -ipady 0 -padx 3 -pady 5
	catch {grab .about}
	tkwait window .about
}
##############################################################################
# initialize values and defaults for mp3play
set version 1.1b2
set mp3playrc "~/.mp3playrc"
Initialize
##############################################################################
# show the window title
wm title . "MP3Play"
##############################################################################
# create all menus
createMenuBar
##############################################################################
# Create Display
createDisplay
##############################################################################
# Create Scale
createScale
##############################################################################
# Create Controls
createControls
##############################################################################
# Create Gain Bar
createGain
##############################################################################
# Create Spectrum
createSpectrum
##############################################################################
# Set Bindings
setBindings
##############################################################################
# make window not resizable
wm resizable . false false
##############################################################################
# catch the quit command for toplevel
wm protocol . WM_DELETE_WINDOW _exit
##############################################################################
