#
#  Input box centered on the screen
#

package provide mpTk 0.6.15

namespace eval mpTk {
    namespace eval Inp {
	namespace import ::mpTk::Misc::centerwin
    }
}


proc mpTk::Inp::inputbox {w transient width title label select} {
    variable input
    variable inp

    set inp(oldFocus) [focus]
    catch {destroy $w}
    toplevel $w -relief raised -bd 2 -class Input
    if {$transient} {
	if {$inp(oldFocus) != ""} {
	    if {[wm transient [winfo toplevel $inp(oldFocus)]] == ""} {
		wm transient $w [winfo toplevel $inp(oldFocus)]
	    }
	} else {
	    wm transient $w .
	}
    } else {
	wm title $w $title
    }
	
    if {$label != ""} {
	frame $w.spacer1 -width 1.5m
	pack $w.spacer1 -side left -pady 5m
	label $w.label -text $label
	entry $w.entry -textvariable mpTk::Inp::input -width $width
	pack $w.label $w.entry -side left -padx 1m -pady 5m
	frame $w.spacer2 -width 3m
	pack $w.spacer2 -side left -pady 5m
    } else {
	entry $w.entry -textvariable mpTk::Inp::input -width $width
	pack $w.entry -side left -padx 3.5m -pady 5m
    }

    centerwin $w

    bind $w.entry <Return> { 
	focus $mpTk::Inp::inp(oldFocus)
	destroy [winfo toplevel %W]
    }
    bind $w.entry <Escape> {
	set mpTk::Inp::input ""
	focus  $mpTk::Inp::inp(oldFocus)
	destroy [winfo toplevel %W]
    }

    if {$select} {
	$w.entry selection range 0 end
    }
    update
    focus $w.entry
    tkwait window $w
}


# Generic input

proc mpTk::Inp::get_input {args} {
    variable input
 
    set input [lindex $args 0]
    set prompt [lindex $args 1]
    set length 20
    if {[llength $args] > 2} {
	set length [lindex $args 2]
    }
    inputbox .input 1 $length {} $prompt: 1
    update; update; update
    return $input
}
