#
#  Lists
#

package provide mpTk 0.6.15


# Simple list with (optionally) horizontal and vertical scrollbars.

proc mpTk::List::listscroll {frame width height xscroll} {
    scrollbar $frame.yscroll -width 10 -orient vertical \
	    -command [list $frame.list yview]
    if {$xscroll} {
	scrollbar $frame.xscroll -width 10 -orient horizontal \
		-command [list $frame.list xview]
    }

    set cmd [list listbox $frame.list]
    lappend cmd -yscroll [list $frame.yscroll set]
    if {$xscroll} {
	lappend cmd -xscroll [list $frame.xscroll set]
    }
    lappend cmd -width $width -height $height -setgrid 1
    eval $cmd

    pack $frame.yscroll -side right -fill y
    if {$xscroll} {
	pack $frame.xscroll -side bottom -fill x
    }
    pack $frame.list -side left -expand yes -fill both
}
