#
#  Text
#

package provide mpTk 0.6.15


# Text window with (optionally) horizontal and vertical scrollbars.

proc mpTk::Text::textscroll {frame width height xscroll} {
    scrollbar $frame.yscroll -width 10 -orient vertical \
	    -command [list $frame.text yview]
    if {$xscroll} {
	scrollbar $frame.xscroll -width 10 -orient horizontal \
		-command [list $frame.text xview]
    }

    set cmd [list text $frame.text]
    lappend cmd -yscroll [list $frame.yscroll set]
    if {$xscroll} {
	lappend cmd -xscroll [list $frame.xscroll set]
    }
    lappend cmd -width $width -height $height -setgrid 1
    eval $cmd

    pack $frame.yscroll -side right -fill y
    if {$xscroll} {
	pack $frame.xscroll -side bottom -fill x
    }
    pack $frame.text -side left -expand yes -fill both
}
