/*
 Handling of MPEG Audio Headers.
 */

#include <unistd.h> 
#include <stdio.h>
#include <stdlib.h>
#include "mp3info.h"

char *mode_names[5] = { "stereo", "j-stereo", "dual-ch", "single-ch" , "multi-ch"};
char *layer_names[3] = { "I", "II", "III" };
char *version_names[3] = { "MPEG-1", "MPEG-2 LSF", "MPEG-2.5" };
char *version_nums[3] = { "1", "2", "2.5" };


int     bitrate[3][3][15] = {
     {
	  {0,32,64,96,128,160,192,224,256,288,320,352,384,416,448},
	  {0,32,48,56,64,80,96,112,128,160,192,224,256,320,384},
	  {0,32,40,48,56,64,80,96,112,128,160,192,224,256,320}
     },{
	  {0,32,48,56,64,80,96,112,128,144,160,176,192,224,256},
	  {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160},
	  {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160}
     },{
	  {0,32,48,56,64,80,96,112,128,144,160,176,192,224,256},
	  {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160},
	  {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160}
     }};


double  s_freq[3][4] = {
     {44.1, 48, 32, 0},
     {22.05, 24, 16, 0},
     {22.05, 24, 16, 0} /* bugy.. */
};



int gethdr(int fd,layer *hdr) {
   unsigned char buffer[5];
   int temp;
   
   lseek(fd, 0, SEEK_SET) ;
   temp=read(fd,&buffer,4);
   
   temp=((buffer[0]<<4) & 0xFF0) | ((buffer[1]>>4) & 0xE);
   if (temp != 0xFFE) {
      return(0);
   } else {
      switch((buffer[1]>>2 & 0x3)) {
        case 2:
          hdr->version = 0;
          break;
        case 3:
          hdr->version = 1;
          break;
        case 0:
          hdr->version = 2;
          break;
        default:
          return(0);
      }
      hdr->lay = 4-((buffer[1]>>1) & 0x3);
      hdr->error_protection = !(buffer[1] & 0x1);
      hdr->bitrate_index = (buffer[2]>>4) & 0x0F;
      hdr->sampling_frequency = (buffer[2]>>2) & 0x3;
      hdr->padding = (buffer[2]>>1) & 0x01;
      hdr->extension = buffer[2] & 0x01;
      hdr->mode = (buffer[3]>>6) & 0x3;
      hdr->mode_ext = (buffer[3]>>4) & 0x3;
      hdr->copyright = (buffer[3]>>3) & 0x1;
      hdr->original = (buffer[3]>>2) & 0x1;
      hdr->emphasis = ( buffer[3] ) & 0x3;
      hdr->stereo = (hdr->mode == MPG_MD_MONO) ? 1 : 2; 
      
      return(1);
   }
}

void mp3calc(mp3file *mp3) {
   mp3->length=(mp3->filelen) /
     (bitrate[mp3->hdr.version][mp3->hdr.lay-1][mp3->hdr.bitrate_index] * 125);
}
