#ifndef __MP3INFO_H
#define __MP3INFO_H

#define FORMAT_LEN 512
#define STD_BUF_LEN 2048

typedef struct {
   int version;
   int lay;
   int error_protection;
   int bitrate_index;
   int sampling_frequency;
   int padding;
   int extension;
   int mode;
   int mode_ext;
   int copyright;
   int original;
   int emphasis;
   int stereo;
} layer;

/* MPEG Header Definitions - Mode Values */

#define         MPG_MD_STEREO           0
#define         MPG_MD_JOINT_STEREO     1
#define         MPG_MD_DUAL_CHANNEL     2
#define         MPG_MD_MONO             3

/* Mode Extention */

#define         MPG_MD_LR_LR             0
#define         MPG_MD_LR_I              1
#define         MPG_MD_MS_LR             2
#define         MPG_MD_MS_I              3


typedef struct {
   char tag[3] ;
   char title[30] ;
   char artist[30] ;
   char album[30] ;
   char year[4] ;
   char comment[30] ;
   unsigned char genre ;
} tag ;

typedef struct {
   char title[32] ;
   char artist[32] ;
   char album[32] ;
   char year[7] ;
   char comment[32] ;
   char genre[32] ;
   int gennum;
} tune ;

typedef struct {
   layer hdr;
   tune tag;
   int hashdr;
   int hastag;
   size_t filelen;  
   unsigned long length;
} mp3file ;

extern char *mode_names[5];
extern char *layer_names[3];
extern char *version_names[3];
extern char *version_nums[3];
extern double s_freq[3][4];
extern int bitrate[3][3][15];
extern char *genres[];
extern int shall_debug;

int mp3open(mp3file *mp3, char *fname, int rdwr);
int gethdr(int fd,layer *hdr);
void mp3calc(mp3file *mp3);
int gettag(int fd, tune *info);
void printstd(mp3file *mp3, char *format, char *fname, char *out);

#endif
