/*
 Parse and print std header.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <fcntl.h>
#include "mp3info.h"

int parseif(mp3file *mp3,char what) {
   switch (what) {
    case 'T' :
      return (mp3->hastag) ;
      break ;
    case 'H' :
      return (mp3->hashdr) ;
      break ;
    case 'a' :
      return (mp3->tag.artist[0]) ;
      break;
    case 'n' :
      return (mp3->tag.title[0]) ;
      break;
    case 't' :
      return (mp3->tag.title[0]) ;
      break;
    case 'l' :
      return (mp3->tag.album[0]) ;
      break;
    case 'y' :
      return (mp3->tag.year[0]) ;
      break;
    case 'c' :
      return (mp3->tag.comment[0]) ;
      break;
    case 'C' :
      return (mp3->hdr.error_protection) ;
      break;
    case 'O' :
      return (mp3->hdr.copyright) ;
      break;
    case 'o' :
      return (mp3->hdr.original) ;
      break;
    case 'S' :
      return (mp3->hdr.stereo) ;
      break;
    default :
      fprintf(stderr,"Warning: If-Format unknown.");
      return (0);
   }
}

void printstd(mp3file *mp3, char *format, char *fname, char *out) {
   char buffer[STD_BUF_LEN+31];
   char *from=format;
   int ifnest=0;
   int ifinc=0;
   int to=0;
   
   while ((from[0]!=0) && (to<STD_BUF_LEN)) {
      if (from[0]=='%') {
	 from++;
	 switch (from[0]) {
	  case 'I' :
	    from++;
	    if (from[0]=='E') {
	       if (ifnest==ifinc) ifinc--;
	       ifnest--;
	    } else {
	       if ((ifinc==ifnest) && parseif(mp3,from[0])) ifinc++;
	       ifnest++;
	    }
	    break;
	  case '!' :
	    from++;
	    if (from[0]=='E') {
	       if (ifnest==(ifinc+1)) ifinc++;
	         else if (ifnest==ifinc) ifinc--;
	    } else {
	       if ((ifinc==ifnest) && !parseif(mp3,from[0])) ifinc++;
	       ifnest++;
	    }
	    break;
	  default :
	    if (ifnest==ifinc) {
	       switch(from[0]) {
		case 'a' :
		  to+=strlen(strncpy(&buffer[to],mp3->tag.artist,STD_BUF_LEN-to));
                  break;
                case 't' :
		  to+=strlen(strncpy(&buffer[to],mp3->tag.title,STD_BUF_LEN-to));
		  break;
                case 'n' :
		  to+=strlen(strncpy(&buffer[to],mp3->tag.title,STD_BUF_LEN-to)); 
		  break;
		case 'l' :
		  to+=strlen(strncpy(&buffer[to],mp3->tag.album,STD_BUF_LEN-to));
		  break;
		case 'y' :
		  to+=strlen(strncpy(&buffer[to],mp3->tag.year,STD_BUF_LEN-to));
		  break;
		case 'c' :
		  to+=strlen(strncpy(&buffer[to],mp3->tag.comment,STD_BUF_LEN-to));
		  break;
		case 'g' :
		  to+=strlen(strncpy(&buffer[to],mp3->tag.genre,STD_BUF_LEN-to));
		  break;
		case '#' :
		  to+=sprintf(&buffer[to],"%i",mp3->tag.gennum);
		  break;
		case 'v' :
		  to+=strlen(strncpy(&buffer[to],version_nums[mp3->hdr.version],STD_BUF_LEN-to));
		  break;
		case 'L' :
		  to+=strlen(strncpy(&buffer[to],layer_names[mp3->hdr.lay-1],STD_BUF_LEN-to));
		  break;
		case 'C' :
		  to+=sprintf(&buffer[to],"%i",mp3->hdr.error_protection);
		  break;
		case 'b' :
		  to+=sprintf(&buffer[to],"%i",bitrate[mp3->hdr.version][mp3->hdr.lay-1][mp3->hdr.bitrate_index]);
		  break;
		case 'F' :
		  to+=sprintf(&buffer[to],"%.1f",s_freq[mp3->hdr.version][mp3->hdr.sampling_frequency]);
		  break;
		case 'M' :
		  to+=strlen(strncpy(&buffer[to],mode_names[mp3->hdr.mode],STD_BUF_LEN-to));
		  break;
		case 'O' :
		  to+=sprintf(&buffer[to],"%i",mp3->hdr.copyright);
		  break;
		case 'o' :
		  to+=sprintf(&buffer[to],"%i",mp3->hdr.original);
		  break;  
		case 'm' :
		  to+=sprintf(&buffer[to],"%lu",mp3->length/60);
		  break;
		case 's' :
		  to+=sprintf(&buffer[to],"%lu",mp3->length%60);
		  break;
		case 'S' :
		  to+=sprintf(&buffer[to],"%lu",mp3->length);
		  break;
		case 'N' :
		  to+=sprintf(&buffer[to],"\n");
		  break;
		case 'f' :
		  to+=strlen(strncpy(&buffer[to],fname,STD_BUF_LEN-to));
		  break;
		case 'i' :
		  to+=sprintf(&buffer[to],"%u",mp3->filelen);
		  break;
		default :
		  buffer[to]=from[0];
		  to++;
	       }
	    }
	 }
      } else {
	 if (ifnest==ifinc) {
	    buffer[to]=from[0];
	    to++;
	 }
      }
      from++;
   }
   if (to>STD_BUF_LEN) to=STD_BUF_LEN;
   buffer[to]=0;
   if (to>=STD_BUF_LEN) fprintf(stderr,"Warning: Output too large, cut.");
   if (out==NULL) { 
     if (to) printf("%s\n",buffer);
   } else {
     strcpy(out,buffer);
   }
}  

