/**********************************************************************
 playmp3 - Copyright (C) 1997 - Hans Petter Bieker
<zerium@pe049.persbraten.vgs
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
***********************************************************************/

#ifdef HAVE_LIBPTHREAD
#  define PTHREADEDMPEG 1
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

#include <mpegsound.h>
#include "playmp3.h"

extern "C" struct progoptions_t progoptions;
extern "C" void print_mp3info(char * filename);
extern "C" char * program_name;

static char *Sounderrors[SOUND_ERROR_UNKNOWN]=
{ "Failed to open sound device.",
  "Sound device is busy.",
  "Buffersize of sound device is wrong.",
  "Sound device control error.",

  "Failed to open file for reading.",
  "Failed to read file.",

  "Memory is not enough.",
  "Unexpected EOF.",
  "Bad sound file format.",

  "Cannot make thread.",

  "Unknown error.",
};

inline void error(int n)
{
  fprintf(stderr,"%s: %s\n",program_name,Sounderrors[n-1]);
  return;
}

int playingthread(Mpegfileplayer *player)
{
  if(player->geterrorcode()>0)error(player->geterrorcode());
  else
  {
    player->setforcetomono(progoptions.forcetomonoflag != 0);
    player->playingwiththread(progoptions.verbose,progoptions.threadstore);
    if(player->geterrorcode()>0)error(player->geterrorcode());
  }
  return 0;
}

int playing(Fileplayer *player)
{
  if(player->geterrorcode()>0)error(player->geterrorcode());
  else
  {
    player->setforcetomono(progoptions.forcetomonoflag);
    player->playing(progoptions.verbose);
    if(player->geterrorcode()>0)error(player->geterrorcode());
  }
  return 0;
}

extern "C" void play(char *filename)
{
  Fileplayer *player;

  if (!progoptions.quiet) print_mp3info(filename);

  player=new Mpegfileplayer;
  player->openfile(filename, progoptions.audiodev);
#ifdef HAVE_LIBPTHREAD
  playingthread((Mpegfileplayer *)player);
#else
  playing(player);
#endif
  delete player;
}
