/**********************************************************************
 playmp3 - Copyright (C) 1997 - Hans Petter Bieker <zerium@pe049.persbraten.vgs
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
***********************************************************************/

#ifndef __PLAYMP3_H
#define __PLAYMP3_H

#define GLOBCFGFILE     "/usr/local/lib/playmp3rc" /* global configuration file */
#define LOCCFGFILE      "/.playmp3rc"              /* local configuration file */

#define DEFTHREADSTORE 500
#define MINTHREADSTORE 1

#define DEFVERBOSE 0
#define DEFRECURSIVE 0
#define DEFQUIET 0
#define DEFSHUFFLE 0
#define DEFFORCEMONO 0
#define DEFAUDIODEV "/dev/dsp"

extern char * program_name;

typedef struct {
  int numfiles; /* number of files in playlist. 0 == non */
  char ** files;
} playlist_t;

typedef unsigned long ulongT;
typedef unsigned short ushortT;

void err(int syserrflg,char *text);

struct progoptions_t{
  int verbose;
  int recursive;
  int quiet;
  int shuffle;
  int show_help;
  int show_version;
#ifdef HAVE_LIBPTHREAD
  int threadstore;
#endif
  int forcetomonoflag;
  int defaultplaypathflag;
  char * defaultplaypath;
  char * audiodev;
};
              

#endif  __PLAYMP3_H
