/*
 File handling for reading and writing MP3-TAG, a format by Damaged 
 Cybernetics.
 * 
 Source by Thorvald Natvig
 */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mp3info.h"

/* This one includes the table of the genres. Autogenerated */
#include "genre.h"

void safecopy(char *to,char *from, int maxlen) {
   int where;
   strncpy(to,from,maxlen);
   to[maxlen]=0;
   for ( where=maxlen-1 ; ((where>=0) && (to[where]==' ')) ; where-- ) {
      to[where]=0 ;
   }
}

void spacecopy(char *to,char *from, int maxlen) {
   int where;
   strncpy(to,from,maxlen);
   for ( where=maxlen-1 ; ((where>=0) && (to[where]==0)) ; where--) {
      to[where]=' ';
   }
}

int wipetag(int fd,size_t filesize) {
   int temp;
   char buffer[4];
   lseek(fd,-128,SEEK_END);
   temp=read(fd,&buffer,3);
   if (! strncmp(buffer,"TAG",3)) {
      lseek(fd,0,SEEK_SET);
      if(ftruncate(fd,filesize-128)==0)
	return(1);
      else return(0);
   } else {
      return(1);
   }
}


int gettag(int fd, tune *info) {
   int temp;
   tag song;
   lseek(fd, -128, SEEK_END) ;
   temp=read(fd, &song, 128);
   
   if (! strncmp(song.tag,"TAG",3)) {
      safecopy(info->title,song.title,30);
      safecopy(info->artist,song.artist,30);
      safecopy(info->album,song.album,30);
      safecopy(info->year,song.year,4);
      safecopy(info->comment,song.comment,30);
      info->gennum= song.genre & 0xFF;
      if (info->gennum >= GENRE_LARGEST) {
	 info->gennum = GENRE_LARGEST;
      }
      strcpy(info->genre,genres[info->gennum]);
      return(1);
   } else {
      return(0);
   }
}

void jointag(tune *to, tune *from) {
   if (from->title[0]) strncpy(to->title,from->title,30);
   if (from->artist[0]) strncpy(to->artist,from->artist,30);
   if (from->album[0]) strncpy(to->album,from->album,30);
   if (from->year[0]) strncpy(to->year,from->year,4);
   if (from->comment[0]) strncpy(to->comment,from->comment,30);
   if (from->gennum != -1 ) to->gennum=from->gennum;
   if (to->gennum >= GENRE_LARGEST) {
      to->gennum=0;
   }
   strcpy(to->genre,genres[to->gennum]);
}

void printgenres(void) {
  int i;
  for (i=0; i<=GENRE_LARGEST;i++) {
    printf("%2i : %s\n",i,genres[i]);
  }
}

