/********************************************************
 * add -- Dump the directories on the rio.  (Debug tool)*
 *							*
 * Usage is: add [-p <base>] {i,o}			*
 * 	-p <base>	-- Set I/O port base		*
 ********************************************************/
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<time.h>
#include	<sys/stat.h>
#include	"rio.h"
#include 	"common.h"

/********************************************************
 * dump_dir -- Write out directory information		*
 ********************************************************/
static void dump_dir(
    rio_class& rio_info, 		// The RIO information
    const enum MEM_TYPE external_flag	// Display external memory
)
{
    rio_info.set_mem_type(external_flag);

    // The current directory block
    const rio_dir_struct& dir_block = rio_info.get_directory();

    // The current directory block header
    const rio_dir_header& dir_header = dir_block.header;

    printf( "\n" );
    printf("------------------------------------------------------------\n");
    printf("Header\n");
    printf("entry_count %hu\n", dir_header.entry_count);
    printf("blocks_available %hu\n", dir_header.blocks_available);
    printf("blocks_used %hu\n", dir_header.blocks_used);
    printf("blocks_remaining %hu\n", dir_header.blocks_remaining);
    printf("bad_block_count %hu\n", dir_header.bad_block_count);
    printf("update_time %ld\n", dir_header.update_time);
    printf("check_sum1 %hd\n", dir_header.check_sum1);
    printf("check_sum2 %hd\n", dir_header.check_sum2);
    printf("One 0x%hx\n", dir_header.one);
    printf("version 0x%hx\n", dir_header.version);

    // Number of entries in the directory 
    u_int entry_count = dir_header.entry_count;

    if ( entry_count > CRIO_MAX_DIRENTRY )
	entry_count = CRIO_MAX_DIRENTRY;

    unsigned int cur_entry;	// Current entry 

    for (cur_entry = 0; cur_entry < entry_count; ++cur_entry) {
	printf("Entry %2d =================================\n", cur_entry);
        printf("    file_position %hu\n", 
		dir_block.dir_entry[cur_entry].file_position);

        printf("    file_size_in_32K %hu\n", 
		dir_block.dir_entry[cur_entry].file_size_in_32k);

        printf("    file_size_blocks %hu\n", 
		dir_block.dir_entry[cur_entry].file_size_blocks);

        printf("    file_size_rem %ld\n", 
		dir_block.dir_entry[cur_entry].file_size_rem);

	printf("    NotUsed 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X\n",
	    dir_block.dir_entry[cur_entry].not_used[0] & 0xFF,
	    dir_block.dir_entry[cur_entry].not_used[1] & 0xFF,
	    dir_block.dir_entry[cur_entry].not_used[2] & 0xFF,
	    dir_block.dir_entry[cur_entry].not_used[3] & 0xFF,
	    dir_block.dir_entry[cur_entry].not_used[4] & 0xFF);

        printf("    upload_time %ld\n", 
		dir_block.dir_entry[cur_entry].upload_time);

        printf("    Property 0x%02X 0x%02X 0x%02X 0x%02X\n",
		dir_block.dir_entry[cur_entry].mp3_property[0] & 0xFF,
		dir_block.dir_entry[cur_entry].mp3_property[1] & 0xFF,
		dir_block.dir_entry[cur_entry].mp3_property[2] & 0xFF,
		dir_block.dir_entry[cur_entry].mp3_property[3] & 0xFF);

	printf("    not_used_3 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X\n",
		dir_block.dir_entry[cur_entry].not_used_3[0],
		dir_block.dir_entry[cur_entry].not_used_3[1],
		dir_block.dir_entry[cur_entry].not_used_3[2],
		dir_block.dir_entry[cur_entry].not_used_3[3],
		dir_block.dir_entry[cur_entry].not_used_3[4]);
	printf("    Name %s\n", dir_block.dir_entry[cur_entry].name);
	int i;

	for (i = 0; i < (128-28); ++i) {
	    printf("%02X ", dir_block.dir_entry[cur_entry].name[i]);
	    if (((i % 16) == 0) && (i != 0))
		printf("\n");
	}
	printf("\n");
    }
    unsigned int i;	// General purpose index

    printf("============  32KBlocksUsed ============\n");
    for (i = 0; i < CRIO_MAX_32KBLOCK; ++i) {
	if (((i % 16) == 0) && (i != 0))
	    printf("\n");
	if ((i % 16) == 0)
	    printf("%4d: ", i);
	printf("%02X ", dir_block.block_used[i]);
    }
    printf("\n");

    printf("============  FAT ============\n");
    for (i = 0; i < CRIO_MAX_32KBLOCK; ++i) {
	if (((i % 8) == 0) && (i != 0))
	    printf("\n");
	if ((i % 8) == 0)
	    printf("%4d: ", i);
	printf("%04X ", dir_block.FAT[i]);
    }
    printf("\n");
    printf("========= Bad list ==========\n");
    for (i = 0; i < CRIO_MAX_32KBLOCK; ++i) {
	if (dir_block.block_used[i] == CRIO_ID_32KBLOCK_BAD)
	    printf("%d ", i);
    }
    printf("\n");
}

/********************************************************
 * usage -- Tell the user what to do.			*
 ********************************************************/
static void usage(void)
{
    fprintf(stderr,"Usage is: add [-p <base>] \n");
    fprintf(stderr,"	-p <base>	-- Set I/O port base\n");
    exit (EXIT_USAGE);
}

/*------------------------------------------------------*/
int main(int argc, char* argv[])
{
    try {
	// The port base for the ls
	int port_base = PORT_BASE_DEFAULT;	// I/O port to use
	rio_class rio_info;			// The RIO informaiton


	while (1) {
	    // The current option
	    int opt = getopt(argc, argv, "p:");

	    if (opt == EOF)
		break;

	    switch (opt) {
		case 'p':
		    sscanf(optarg, "%x", &port_base);
		    break;
		default:
		    usage();
		    break;
	    }
	}

	// setup
	rio_info.set_io_address(port_base);

	dump_dir(rio_info, MEM_INTERNAL);
	dump_dir(rio_info, MEM_EXTERNAL);
    }

    catch (rio_error &error) {
	fprintf(stderr, "ERROR: %s (%d)\n", error.msg, error.error_code);
	exit (EXIT_IO_ERROR);
    }
    catch (...) {
	fprintf(stderr, "ERROR: Unknown exception\n");
	exit (EXIT_IO_ERROR);
    }
    // restore
    return(EXIT_GOOD);
}
