/********************************************************
 * arm -- Remove files from the rio.			*
 *							*
 * Usage:						*
 *	arm [-i] [-v] [-p port] <files..>		*
 *							*
 *	-i -- interactive				*
 *	-v -- verbose					*
 *	-p <port> -- specify port.			*
 ********************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <sys/stat.h>
#include "rio.h"
#include "common.h"
#include "set_ix.h"
#include "rio_glob.h"

static bool interactive = false;
static void usage(void)
{
    fprintf(stderr, "Usage is: arm [-i] [-v] [-p port] <files..>\n");
    exit (EXIT_USAGE);
}

int main( int argc, char* argv[] )
{
    try {
	// default settings
	bool verbose_flag = false;

	int port_base = PORT_BASE_DEFAULT;
	rio_class rio_info;			// The RIO informaiton

	while (1) {
	    int opt = getopt(argc, argv, "p:v");

	    if (opt == EOF)
		break;

	    switch (opt) {
		case 'i':
		    interactive = true;
		    break;
		case 'v':
		    verbose_flag = true;
		    break;
		case 'p':
		    sscanf(optarg, "%x", &port_base);
		    break;
		default:
		    usage();
		    break;
	    }
	}

	// setup
	rio_info.set_io_address(port_base);

	string_list file_list = rio_glob(rio_info, argc, argv, optind);
	string_list::iterator cur_string;

	for (cur_string = file_list.begin(); 
	     cur_string != file_list.end();
	     ++cur_string) {

	    if ( verbose_flag )
		printf("Deleting %s\n", (*cur_string).c_str());

	    if (! set_ix(rio_info, false, (*cur_string).c_str())) {
		fprintf(stderr, "Could not set memory type\n");
		exit (EXIT_IO_ERROR);
	    }
	    if (interactive) {
		char answer[5];	// Answer to "Remove -i" question

		printf("Remove %s? ", (*cur_string).c_str());
		fgets(answer, sizeof(answer), stdin);
		if (answer[0] != 'y')
		    continue;
	    }
	    rio_info.remove_file(&(*cur_string).c_str()[2]);
	}
	rio_info.flush();

    }

    catch (rio_error &error) {
	fprintf(stderr, "ERROR: %s (%d)\n", error.msg, error.error_code);
	exit (EXIT_IO_ERROR);
    }
    catch (...) {
	fprintf(stderr, "ERROR: Unknown exception\n");
	exit (EXIT_IO_ERROR);
    }

    return(EXIT_GOOD);
}

