/********************************************************
 * Common definitions and include files.		*
 *							*
 * Try and make up for compiler differences.		*
 ********************************************************/

#ifndef		_COMMON_
#define		COMMON_

// platform dependencies
#if defined(_WINNT)
    // MS VC++ v5.0 for WinNT v4
    #include	<stdlib.h>
    #define		SIZE_MAXPATH	_MAX_PATH
    #define		DELETEARRAY	delete[]

#elif defined(_WIN32)
    // MS VC++ v5.0 for Win9x
    #include	<stdlib.h>
    #define		SIZE_MAXPATH	_MAX_PATH
    #define		DELETEARRAY	delete[]

#elif defined(__linux__)
    // linux g++
    #include	<unistd.h>
    #include	<values.h>
    #if defined(PATH_MAX)
	#define		SIZE_MAXPATH	PATH_MAX
    #else
	#define		SIZE_MAXPATH	256
    #endif
    #define		DELETEARRAY	delete[]

#elif defined(__TURBOC__)
	// turboc v1.01
	#include	<dir.h>
	#define		SIZE_MAXPATH	MAXPATH
	#define		DELETEARRAY	delete

#else
	// not supported
	#error ! ! compiler/platform not supported ! !
#endif

// default port base
#if defined(__alpha)
    #define	PORT_BASE_DEFAULT	0x3bc
#else
    #define	LPT1			0x378
    #define 	LPT2			0x278
    #define	PORT_BASE_DEFAULT	LPT1
#endif

const int EXIT_GOOD = 0;	// Exit for no error
const int EXIT_USAGE = 8;	// User error
const int EXIT_IO_ERROR = 10;	// I/O error


const unsigned int C32K = (32 * 1024);	// 32K constant
const unsigned int C32M = (C32K * 1024);// 32MB constant

#endif		// _COMMON_

