#ifndef __RIO_ERROR__
#define __RIO_ERROR__

/********************************************************
 * error_str -- Print to a string and return the result	*
 ********************************************************/
extern const char *const error_str(
    const char* const format, 	// Format string
    ... 			// Format argument
);
// error id's
enum RIO_ERROR
{
    CRIO_ERROR_ALLOC = 0,
    CRIO_ERROR_IOPRERM,
    CRIO_ERROR_CREATEFILE,
    CRIO_ERROR_DEVICENOTFOUND,
    CRIO_ERROR_DRIVERVERSION,
    CRIO_ERROR_TXBLOCKRETRY,
    CRIO_ERROR_RXBLOCKRETRY,
    CRIO_ERROR_CORRUPT,
    CRIO_ERROR_FILENOTFOUND,
    CRIO_ERROR_INVALIDFILEPOSITION,
    CRIO_ERROR_MAXDIRENTRY,
    CRIO_ERROR_MEMORY,
    CRIO_ERROR_OPEN,
    CRIO_ERROR_STAT,
    CRIO_ERROR_READ,
    CRIO_ERROR_WRITE,
    CRIO_ERROR_BAD_FILE,
    CRIO_ERROR_INTERRUPTED,
    CRIO_ERROR_ACK,
};

/********************************************************
 * rio_error -- Information an rio error.		*
 ********************************************************/
class rio_error {
    public:
	// The error code
	const enum RIO_ERROR error_code;
	// The error message 
	const char * const msg;
    public:
	rio_error(
	    const enum RIO_ERROR i_error_code,
	    const char *const i_msg
	) : error_code(i_error_code),
	    msg(i_msg)
	{}
	// Copy construtor defaults
	// Destructor defaults
	// Assignment operator defaults
};
	
#endif /* __RIO_ERROR__ */

