/********************************************************
 * rio_glob -- perform "globbing" on the rio's entry	*
 ********************************************************/
#include <fnmatch.h>
#include <stdio.h>
#include "rio_glob.h"


/********************************************************
 * match -- Match a list of against those in a directory*
 ********************************************************/
static void match(
    rio_class &rio_info, 		// The connection to the rio
    const string mem_prefix,	// x: or i: depending on memory
    string_list &result,	// Results stored here
    const string_list &list	// List of things to match
)
{
    // Number of entries
    unsigned int entry_count = rio_info.dir.get_entry_count();
    unsigned int index;	/* Index into the entries */

    string_list::const_iterator cur_entry;	// Current string to check

    for (cur_entry = list.begin(); cur_entry != list.end(); ++cur_entry) {
	int match_count = 0;	// Number of matches

	for (index = 0; index < entry_count; ++index) {
	    // The current directory entry
	    const rio_dir_entry dir_entry = rio_info.dir.get_dir_entry(index);

	    if (fnmatch(&(*cur_entry).c_str()[2], 
			    dir_entry.name, FNM_NOESCAPE) == 0) {
		result.push_back(mem_prefix + dir_entry.name);
		++match_count;
	    }
	}
	if (match_count == 0) {
	    fprintf(stderr, "Warning: File not found %s\n", 
		    (*cur_entry).c_str());
	}
    }
}
/********************************************************
 * rio_glob -- Perform a glob on the rio's		*
 *	directory and return the list of files.		*
 *							*
 * Note: All files will have i: or x: on their front	*
 * and be sorted by name.				*
 ********************************************************/
string_list
rio_glob(
    rio_class &rio_info,// The connection to the rio
    int argc, 		// Arguement count
    char *argv[], 	// Arguements 
    int optind		// Index to start arguement scan
)
{
    string_list result;	// Result of the glob
    string_list i_list;	// List of x: stuff to match
    string_list x_list;	// List of x: stuff to match

    for (/* optind set */; optind < argc; ++optind) {
	if (strncmp(argv[optind], "i:", 2) == 0) 
	    i_list.push_back(argv[optind]);
	else if (strncmp(argv[optind], "x:", 2) == 0) 
	    x_list.push_back(argv[optind]);
	else {
	    i_list.push_back(string("i:") + string(argv[optind]));
	    x_list.push_back(string("x:") + string(argv[optind]));
	}
    }
    if (!i_list.empty()) {
	rio_info.set_mem_type(MEM_INTERNAL);
	match(rio_info, string("i:"), result, i_list);
    }

    if (!x_list.empty()) {
	rio_info.set_mem_type(MEM_EXTERNAL);
	match(rio_info, string("x:"), result, x_list);
    }

    result.sort();
    return (result);
}
