/********************************************************
 * rio_io -- Do low level I/O on the rio.		*
 ********************************************************/
#ifndef __RIO_IO__
#define __RIO_IO__

// Memory types
enum MEM_TYPE {MEM_INTERNAL, MEM_EXTERNAL};

class data_block;	
// I/O Handler for the rio 
class rio_io {
    private:
	void io_begin(void);	// Begin an I/O operation
	void io_end(void);	// End an I/O operation
	void wait_ack(void);	// Wait for the RIO to ack the signal

	int port_base;		// Base of the LPT I/O
	int port_data;		// The data port
	int port_status;	// The status port
	int port_control;	// The control port

	enum MEM_TYPE mem_type;// External flash?

	inline void command_out(
	    const u_short v1, 
	    const u_short v2, 
	    const u_short v3
	);

	void io_delay(
	    const unsigned int ticks	// Ticks to delay
	);

	u_int get_data_byte(void);
    public:
	rio_io(void);

	// Tell us what memory to use
	void set_mem_type(
	    const enum MEM_TYPE new_mem_type
	) {
	    mem_type = new_mem_type;
	}

	void unset_io_address(void);
	void set_io_address(const int i_port_base);

    private:
	void send_block_to_rio_once(
	    const data_block &block,	// The data block to be sent
	    const u_int block_pos, 	// The location of the data block
	    const u_int prev_block_pos,	// Previous block number
	    const u_int next_block_pos 	// Next block number
	);

	void get_block_from_rio_once(
	    data_block &block_ptr, 	// Block to get
	    const u_int block_pos 	// Where to get it from
	);
    public:
	void send_block_to_rio(
	    const data_block &block,	// The data block to be sent
	    const u_int block_pos, 	// The location of the data block
	    const u_int prev_block_pos,	// Previous block number
	    const u_int next_block_pos 	// Next block number
	);

	void get_block_from_rio(
	    data_block &block_ptr, 	// Block to read
	    const u_int block_pos 	// Position
	);
	u_char get_memory_size(void);	// Get memory size code

	void finish(void) {
	    io_end();
	}
};

#endif /* __RIO_IO__ */
