/********************************************************
 * set_ix -- Set internal or external memory.		*
 ********************************************************/
#include <string.h>
#include <stdio.h>
#include "rio.h"
#include "common.h"

/********************************************************
 * set_ix -- Set the rio for Internal or External 	*
 *		memory access				*
 *							*
 * Returns:						*
 *	true -- we saw an "i:" or "x:" at the beginning	*
 *		of the file and will act accordingly	*
 *							*
 * 	false -- not i: or x: seen			*
 ********************************************************/
bool set_ix(
    rio_class &rio_info,	// Information on the rio
    const bool verbose_flag,	// True if we should chatter
    const char file_name[]	// The file name to check for the
    				// Internal/external flag
)
{
    enum MEM_TYPE mem_type;	// Use the eternal flash?

    if (strncmp(file_name, "i:", 2) == 0) {
	mem_type = MEM_INTERNAL;
    } else if (strncmp(file_name, "x:", 2) == 0) {
	mem_type = MEM_EXTERNAL;
    } else
        return (false);

    // select internal or external flash memory
    if (verbose_flag)
	printf( "Performing operations on %s flash ram.\n", 
		mem_type == MEM_EXTERNAL ? "external" : "internal" );
    rio_info.set_mem_type(mem_type);
    return (true);
}

