#include <time.h>	/* (/usr/include/time.h) */
#include <stdio.h>
#include "time.h"

typedef unsigned int u_int;	// Nice shorthand
/********************************************************
 * time_to_string -- Turn time into a string		*
 ********************************************************/
char* time_to_string(
    const long time_value 	// Time in UNIX standard format
)
{
    static char result[64];	// Result in string format
    struct tm* tm_value;	// Time value split apart
    tm_value = localtime(&time_value);

    if ( !tm_value )
	strcpy( result, "INVALID DATE/TIME" );
    else {
	sprintf(
		result,
		"%02u/%02u/%02u %02u:%02u:%02u",
		(u_int)tm_value->tm_mday % 100,
		(u_int)tm_value->tm_mon+1 % 100,
		(u_int)tm_value->tm_year % 100,
		(u_int)tm_value->tm_hour % 100,
		(u_int)tm_value->tm_min % 100,
		(u_int)tm_value->tm_sec % 100
	);
    }

    return result;
}

