#include "sadp_config.h"

#define MAX_VOLUME  100
#define MAX_BALANCE 100

#define SADP_VERSION  0x10104
#define TIME_DISPLAY_MODES 4

typedef enum
{
/* ---- The following 17 buttons are used in main window   ---- */
/* ---- and  covered by OperNotation and BtnInfo           ---- */
   OPER_PREV, OPER_BACK,  OPER_FWD,  OPER_NEXT,
   OPER_PLAY, OPER_PAUSE, OPER_QUIT,
   OPER_STOP, OPER_NEXT5, OPER_PREV5,
   OPER_MIXERPREV, OPER_MIXERNEXT,
   OPER_STOPQUIT, OPER_HELP, OPER_REFRESH, OPER_SUSPEND,
   OPER_SAVEO,

/* ---- The following 3 buttons are used in help mode only ---- */
/* ---- and covered by OperNotation but not BtnInfo        ---- */
   OPER_PLAYBACK, OPER_HELPPREV, OPER_HELPNEXT,

/* ---- The following 5 buttons have variable appearence   ---- */
/* ---- and covered by BtnInfo, but not OperNotation       ---- */
   OPER_TIMEDISPLAY, OPER_AUTOPLAY, OPER_LOOPPLAY,
   OPER_PLAYMODE,    OPER_INPUT,

/* ---- The following commands are used as buttons         ---- */
/* ---- in XForms mode only                                ---- */
   OPER_FIRSTTRACK, OPER_LASTTRACK, OPER_FOCUS,

/* ---- The following are commands that do not correspond  ---- */
/* ---- to any button                                      ---- */

   OPER_PLAYFROM, OPER_PLAYFROMALIGNED,
   OPER_SPECIAL,   OPER_NONE
} OPERATION;


#define CBUTTONS   17     /* Common buttons */
#define HBUTTONS    3     /* OperNotation only */
#define UBUTTONS    5     /* BtnInfo only */
#define XFBUTTONS   3     /* XForms only */

typedef enum
{  PLTF_CURSES, PLTF_XFORMS } PLATFORM;

typedef enum
{  PLAY_NORMAL, PLAY_LIST, PLAY_RANDOM, PLAY_INTRO, PLAY_SINGLE}
			PLAY_MODE_TYPE;
/* PLAY_LOOP, PLAY_REPEAT, */
typedef enum
{  ACCESS_UNDEF, ACCESS_PLAY, ACCESS_STOP,
   ACCESS_EJECT, ACCESS_LOAD, ACCESS_POSITION }
			ACCESS_TYPE;

typedef enum
{    DM_ELAPSED,   DM_REMAINED,
     DM_PROGRESS,    DM_PROGREM }
     TIME_DISPLAY_MODE_TYPE;

typedef enum
{   SDM_MODULUS = 1,
    SDM_REAL = 2,
    SDM_IMAG = 3,
    SDM_COMB = 4
} SPECTR_DISPLAY_MODE;

typedef struct
{  double r;
   double i;
} CPLX;

typedef struct
{    u_long  start;
     char    name[61];
     u_char  audio;
} TRACK_INFO;

/* Hopefully we should not have an overflow in this case. */
#define time_diff(to, from)  (((to).tv_sec - (from).tv_sec) * 1000000l + \
				      ((to).tv_usec - (from).tv_usec) )

int  process_arguments(int argc, char **argv);

/* Screen interface functions */
PLATFORM get_platform(void);
int screen_initialize(int argc, char *argv[]);
void screen_deinitialize(void);
int foreground_processing(void);
OPERATION  get_action(void);
void show_cd_status(char *status, short ind);
void show_cd_time(void);
void draw_volume(unsigned char volumel, unsigned char volumer);
void show_volume(void);
void show_mixer_input(void);
void show_mixer_device(void);
void show_mode(OPERATION mode);
void clear_cd_time(void);
void draw_spectrum(void);
void redraw_screen(void);
void refresh_output(void);
void set_suspend_mode(short NewMode);
void  draw_mwnd_bottom(void);
void  print_epilogue();
u_short get_kbd_shift(void);

/*  cdaudio functions  */
int cdaudio_initialize(void);
int cdaudio_deinitialize(void);
int cdaudio_start(void);
char *cdaudio_get_track_name(u_char track);
int cdaudio_operate(OPERATION oper);
int check_cd(void);
int cd_playtrack(int track, int force);
void time_to_msf(u_long timemsf,
                    u_char *min, u_char *sec, u_char *frm);
short cd_check_multisession(void);
short cd_setvolume(u_char vol_left, u_char vol_right);
void  cd_accept_play_mode(void);
short cd_getvolume(void);

/* Sound functions */
int sound_initialize(void);
void sound_terminate(void);
int sound_start(void);
int audio_reinitialize(void);
void sound_process(void);
void audio_stop(void);
void mixer_setvolume(u_int new_volume, u_int new_balance);
void mixer_changevolume(int volume_inc, int balance_inc);
void mixer_toggleinput(void);
int mixer_accept_next_device(void);
int mixer_accept_prev_device(void);
void  accept_focus(void);
void ft_process(CPLX *spectrum, CPLX signal[], int f);


/* Info functions */
#define INFO_LINE_SIZE  29

int  prepare_info_page(void);
void update_info_page(void);
void release_info_page(void);
short get_cpu_data(char *cputype, char *cpumodel, double *cpuclock, double *mips);

/* Data Base maintenance */
void cddb_initialize(void);
void cddb_terminate(void);
void cddb_find(void);
int  cddb_write(void);

/* Settings saving */
char *GetFullFileName(const char *shortname);
void save_settings(void);



