#include "sadp_gpm_support.h"

#ifndef NCURSES_VERSION_MAJOR
#define NCURSES_VERSION_MAJOR  1
#endif


/* Screen function */
void init_spectrum_wnd(void);
void draw_header(void);

/* Help functions */
int   help_initialize(void);
int   help_activate(void);
void  help_accept_focus(void);
void   help_deactivate(void);
void  help_accept_section(short new_section);
void  help_deinitialize(void);
OPERATION help_getaction(int key);
void help_redraw(void);

/* Data functions */
void  data_accept_section(short new_section);
void data_set_browser(int brow, short value);
void data_draw_fields(void);

int show_help(void);
OPERATION help_getaction(int key);

typedef enum
 {  MOUSE_NONE, MOUSE_NATIVE, MOUSE_GPM}
       MOUSE_SUPPORT_OPTION;

typedef enum
 {  HEADER_NONE, HEADER_DISC, HEADER_TRACK}
        HEADER_MODE;


int mouse_gpm_initialize(void);
void mouse_gpm_deinitialize(void);
void mouse_gpm_drawpointer(void);
int gpm_getch(void);

void load_settings(void);

#define DATA_FIRST_SECTION	2
#define DATA_SECTIONS		1
#define HELP_FIRST_SECTION	3
#define HELP_SECTIONS		3
#define HELP_FIRST_NONSECTION	(HELP_FIRST_SECTION + HELP_SECTIONS)
#define BOTTOM_SECTIONS		HELP_FIRST_NONSECTION

