/*  =========================================================

    SING - ALONG DISK PLAYER.
    (C) 1998-1999, Michael Glickman. xsadp@yahoo.com
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See GNU general public  licence  (GPL) supplied with
            this distribution for the details and legal issues.

            You are expected to provide appropriate references
            when using a part of the code in your software.

            Author strongly advices against using this code, or
            a part of it, in an application designed to run  on
            any Microsoft(tm) platfrom.
    ========================================================= */
#include <curses.h>
#include <term.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "sad.h"
#include "sadp_curses.h"

extern short  FourWndCount;
extern int  MainWndHeight, MainWndLeft, MainWndTop, MainWndWidth;
extern int  FourWndHeight, FourWndWidth;

extern  int    ScreenW, ScreenH;
extern  short  BkgrColour;
extern  short  BtnDist, BtnWidth;
extern  short  HelpFocus, BottomSection;
extern  short  HeaderMode;      /* 1 - CD + Artist, 2 - Track name */
extern  short  SaveData;

extern  chtype btn_attr, bar_attr;
extern  chtype bkgr_attr, fill_attr, text_attr;

extern  chtype thumb_attr, suspend_attr, dimmed_attr;
extern  chtype side_attr, side_text_attr, side_dim_attr;
extern  chtype spectr1_attr, spectr2_attr, spectr3_attr;
extern  chtype header_attr, brow_attr, brow_hilite_attr;
extern  chtype help_attr, help_hdr_attr;

extern  chtype cLeftArrow, cRightArrow,  cDownArrow, cUpArrow;
extern  chtype cLeftArrow1, cRightArrow1;
extern  chtype cBlock, cBar, cBullet, cBullet1, cCkboard, cDiamond;
chtype  cSpectBright, cSpectDim, cVolBright, cVolDim;
extern  chtype OperNotation[][3];
extern  PLAY_MODE_TYPE  PlayMode;

extern  char   TimeModeTxt[];
extern  char   AutoModeTxt[];
extern  char   PlayModeTxt[];
extern  char   LoopModeTxt[];

extern  short  DataChanged;
extern  short  cd_playlist_size;
extern  u_char *cd_playlist;
extern  short  cur_plist_size;
extern  short  cur_plist_pos;
extern  u_char *cur_plist;

extern  WINDOW *MainWnd;
extern  MEVENT  LastMouseEvent;

extern  char   **InfoPages;
extern  short  HelpLineCount, InfoLineCount, MiscLineCount;
extern  short  IsX, AreColours;

static  WINDOW *HelpWnd;
static  short  HelpWndWidth, HelpWndHeight, HelpWndLineWidth;
static  short  HelpWndEffWidth, HelpWndEffHeight, HelpWndEffTop;
static  short  HelpWndLeft, HelpWndTop;
static  short  OldMainWndTop = -1;
static  short  PlayAdvance, HelpCurSect = -1, OldBarPos = -1;

static  short  PageWidth, EffPageWidth, LineCount, PageCount;
static  short  TotWidth, LogWidth, InsOvlX;
static  short  HelpBarTop, HelpBarLength, HelpBarLeft;
static  short  HelpPlayInd, HelpPlaybackInd;

static  int    HelpCurPos;
static  int    MainWndTop1;
static  struct timeval TimePlayStart;

extern  char   disc_name[], disc_artist[];
extern  u_char track_first, track_last, track_cur;
extern  short  no_cd;

extern char   *HelpPages[], *MiscPages[];

static short   DataLineSize, BrowHeight, BrowWidth;
static short   DataHdrX, DataLineX;
static short   DataScrollX1, DataScrollX2;
static u_short brow_cur_line[2], brow_top_line[2], brow_lines[2];
static short   data_active_fld = -1, data_active_browser = 0;
static short   InsertMode = 0;
static OPERATION data_getaction(int key);

#define DATA_FIELDS 3
#define HWND_HEIGHT 19
/* #define HWND_WIDTH  64 */

#define HELP_PLAY_TIMEOUT ((TIME_OUT_HELP_ADVANCE) * 1000)

#define HELP_BUTTONS   8
#define BOTTOM_BUTTONS 0

static struct HELP_SECTION_INFO
{       char   **source;
        char   *name;
        short  page_width;
        short  line_count;
        int    position;
} HelpSectionInfo[HELP_SECTIONS];

static struct DATA_FIELD_INFO
{       char   *name;
        char   *source;
        chtype attr;
        short  offset;
        short  pos;
        short  y;
} DataFieldInfo[3];


static char  **DispPages;

struct BTN_INFO
{
   short  y;
   short  x1, x2;
   short  oper;
} HelpButtonInfo[HELP_BUTTONS+BOTTOM_BUTTONS],
  DataButtonInfo[5];

enum DATA_BUTTON_COMMANDS
{  DATA_SAVE, DATA_RESTORE, DATA_AUTOSAVE, DATA_ADDLIST, DATA_DELLIST };

static const char *DataBtnNames[] =
        { "  Save  ", " Reload ", "  Auto  "};

static void activate_data_fld(short new_field);
static void mark_char(short fld_no, short active);
static void decorate_browser(short brow);
static void data_show_track_in_browser(short brow, short line);

static chtype  help_button_char(char *src, int off)
{       int buttonNo, i;
        chtype ret = ' ';

      if (*(src+off) == ' ') goto Uscita;

        buttonNo = atoi(src);
        switch(buttonNo)
      { case 0 ... CBUTTONS+HBUTTONS-1:
          ret = OperNotation[buttonNo][off] | btn_attr;
            break;

        case 40 ... 52:
          {  char *txtptr;

                i = buttonNo - 40;

              if (i<4) txtptr = TimeModeTxt;
              else
              if (i<6) { txtptr = AutoModeTxt; i -= 4; }
              else
	      if(i<11) { txtptr = PlayModeTxt; i -= 6; }
	      else     { txtptr = LoopModeTxt; i -= 11; }

              ret = *(txtptr + 3*i + off) | btn_attr;
          }
          break;

        case 70 ... 73:
           if (off==1)
                ret = OperNotation[OPER_STOP][buttonNo-70];
           else
              ret = ' ';
           ret |= btn_attr;
           break;

        case 75 ... 76:
             ret = OperNotation[buttonNo-75 + OPER_HELPPREV][off] | btn_attr;
           break;

        case 80 ... 89:
           i = buttonNo - 80;
             if (i==5) i = OPER_PLAYBACK;
           ret = ( (i==OPER_STOP && off != 1) ? ' '
                   : OperNotation[i][off] ) | side_attr;


      }


  Uscita:
        return ret;
}


static void help_show_page(long start)
{
    int x, y, ind, off, pageno_pos;
    int offset, pageno;
    char *src, pagenotxt[5];
    chtype typ, attr;
    chtype sep = cBullet | side_text_attr;
    const char *specchr = "%-";

    wattrset(HelpWnd, side_text_attr);
    wmove(HelpWnd, HelpWndEffTop-2, 1);
    whline(HelpWnd, cBullet, HelpWndLineWidth);
    wmove(HelpWnd, HelpWndEffTop + HelpWndEffHeight+1, 1);
    whline(HelpWnd, cBullet, HelpWndLineWidth);

    wattrset(HelpWnd, text_attr);

    pageno = start / PageWidth;
    offset = start % PageWidth;
    start = HelpWndEffHeight * pageno;

    off= PageWidth-offset-3;
    if (off <0)
    { off += PageWidth; pageno++; }
    pageno_pos = off - PageWidth/2 + 2;

    x = 0;
    while(x < HelpWndLineWidth-2)
    {

        if (off > HelpWndLineWidth-2-x) off = HelpWndLineWidth-2-x;
        wmove(HelpWnd, HelpWndEffTop-1, x+3);
        whline(HelpWnd, ' ', off);
        wmove(HelpWnd, HelpWndEffTop+HelpWndEffHeight, x+3);
        whline(HelpWnd, ' ', off);
        x +=  off;

        if (pageno_pos >= 2)
        {
           sprintf (pagenotxt, " %02d ", pageno+1);
           for (ind = 0; ind < 4; ind++)
           { y = pageno_pos+ind;
             if (y >= 3 && y <= HelpWndLineWidth)
             {
                 mvwaddch(HelpWnd, HelpWndEffTop-2, y,
                          pagenotxt[ind] | side_attr);

                 mvwaddch(HelpWnd, HelpWndEffTop+ HelpWndEffHeight+1, y,
                          pagenotxt[ind] | side_attr);
             }
           }
         }

         pageno = (pageno+1) % PageCount;
         pageno_pos += PageWidth;

         if (x < HelpWndEffWidth)
         {
               mvwaddch(HelpWnd, HelpWndEffTop-1, x+3, sep);
               mvwaddch(HelpWnd, HelpWndEffTop+HelpWndEffHeight, x+3, sep);
               x++;
         }

         off= PageWidth-1;
   }

    for (y=0; y<HelpWndEffHeight; y++)
    {
         wmove(HelpWnd, y+HelpWndEffTop, 3);

         x = 0; ind = y+start, off = offset;
         src =  ind < LineCount ? DispPages[ind] : NULL;

         if (src && strchr(specchr, *src)) attr = help_hdr_attr;
                                      else attr = help_attr;

         wattrset(HelpWnd, attr);

         while(x < HelpWndEffWidth)
         {
            if (off >= PageWidth)
            {   ind += HelpWndEffHeight;
                if ((ind - y) >= LineCount) ind = y;
                src = ind < LineCount ? DispPages[ind] : NULL;
                if (src && strchr(specchr, *src))
                                        attr = help_hdr_attr;
                                   else attr = help_attr;
                wattrset(HelpWnd, attr);
                off = 0;
            }

            if (off < EffPageWidth)
            {
                if (!src)
                    typ = ' ';
                else
                if (off==0  && *src == '%')
                    typ = ' ';
                else
                if (off<3 && isdigit(*src))
                    typ = help_button_char(src, off);
                else
                {   typ = *(src+off);
                    if (typ == '@') typ = cCkboard;
                }
             }
             else
               typ = (off-EffPageWidth) == 2 ? sep : ' ';

             waddch(HelpWnd, typ);
             off++; x++;
         }
    }

}

/*
static void help_show_page(long start)
{
    int x, y, ind, off, pageno_pos;
    int offset, pageno;
    char *src, pagenotxt[5];
    chtype typ;
    chtype sep = cBullet | side_text_attr;


    if (ScreenH < 28)
    { wattrset(HelpWnd, side_text_attr);
      wmove(HelpWnd, HelpWndEffTop-2, 1);
      whline(HelpWnd, cBullet, HelpWndLineWidth);
      wmove(HelpWnd, HelpWndEffTop + HelpWndEffHeight+1, 1);
      whline(HelpWnd, cBullet, HelpWndLineWidth);
    }

    wattrset(HelpWnd, text_attr);

    pageno = start / PageWidth;
    offset = start % PageWidth;
    start = HelpWndEffHeight * pageno;


    off= PageWidth-offset-3;
    if (off <0)
    { off += PageWidth; pageno++; }

    pageno_pos = off - PageWidth/2 + 2;


    x = 0;
    while(x < HelpWndLineWidth-2)
    {

        if (off > HelpWndLineWidth-2-x) off = HelpWndLineWidth-2-x;
        wmove(HelpWnd, HelpWndTop+3, x+3);
        whline(HelpWnd, ' ', off);
        wmove(HelpWnd, HelpWndEffTop+HelpWndEffHeight, x+3);
        whline(HelpWnd, ' ', off);
        x +=  off;

        if (pageno_pos >= 2)
        {
           sprintf (pagenotxt, " %02d ", pageno+1);
           for (ind = 0; ind < 4; ind++)
           { y = pageno_pos+ind;
             if (y >= 3 && y <= HelpWndLineWidth)
             {
                 mvwaddch(HelpWnd, HelpWndEffTop-2, y,
                          pagenotxt[ind] | bar_attr);

                 mvwaddch(HelpWnd, HelpWndEffTop+ HelpWndEffHeight+1, y,
                          pagenotxt[ind] | bar_attr);
             }
           }
        }

          pageno = (pageno+1) % PageCount;
        pageno_pos += PageWidth;

          if (x < HelpWndEffWidth)
        {
               mvwaddch(HelpWnd, HelpWndEffTop-1, x+3, sep);
               mvwaddch(HelpWnd, HelpWndEffTop+HelpWndEffHeight, x+3, sep);
                 x++;
        }

          off= PageWidth-1;
   }

    for (y=0; y<HelpWndEffHeight; y++)
    {
         wmove(HelpWnd, y+HelpWndEffTop, 3);

       x = 0; ind = y+start, off = offset;
         src =  ind < LineCount ? DispPages[ind] : NULL;


       while(x < HelpWndEffWidth)
       {
          if (off >= PageWidth)
          {  ind += HelpWndEffHeight;
                 if ((ind - y) >= LineCount) ind = y;
                 src = ind < LineCount ? DispPages[ind] : NULL;
             off = 0;
            }

            if (off < EffPageWidth)
            {
             if (off<3 && src && isdigit(*src))
                typ = help_button_char(src, off);
                 else
                 {   typ = src ? *(src+off) : ' ';
                 if (typ == '@') typ = cBlock;
             }
          }
          else
                typ = (off-EffPageWidth) == 2 ? sep : ' ';

          waddch(HelpWnd, typ);
          off++;
            x++;
       }
    }

}
*/

static void help_show_buttons(void)
{  int i, l, x, l1;
   OPERATION oper;
   struct BTN_INFO *bi;


   wattrset(HelpWnd, side_attr);
   for (i=0; i< (HELP_BUTTONS+BOTTOM_BUTTONS); i++)
   {  bi = (HelpButtonInfo + i);
      oper = bi->oper;

      x = bi->x1;

      l = bi->x2 - x + 1;
      l1 = (l & 1) ? 3 : 2;
      l = (l-l1) >> 1;

      wmove(HelpWnd, bi->y, x);

      for (x=0; x < l; x++) waddch(HelpWnd, ' ');

      for(x=0; x<l1; x++) waddch(HelpWnd, OperNotation[oper][x]);

      for (x=0; x < l; x++) waddch(HelpWnd, ' ');

   }

}

static void help_arrange_buttons(void)
{
    int x, y;
//    int dist, wid;
    int AfterBar;
    int i;

    i = 0;
    y = HelpBarTop;
    x = 3;

    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+BtnWidth;
    HelpButtonInfo[i++].oper = OPER_PREV5;
    x += BtnDist;

    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+BtnWidth-1;
    HelpButtonInfo[i++].oper = OPER_PREV;
    x +=  BtnDist-1;

    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+BtnWidth-1;
    HelpButtonInfo[i++].oper = OPER_BACK;
    x +=  BtnDist-1;

    HelpPlaybackInd = i;
    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+BtnWidth;
    HelpButtonInfo[i++].oper = OPER_PLAYBACK;
    x +=  BtnDist;

    HelpBarLeft = x;
    wattrset(HelpWnd, bar_attr);
    wmove(HelpWnd, y, x);
    whline(HelpWnd, cBullet, HelpBarLength);
    x += HelpBarLength+1;

    HelpPlayInd = i;
    AfterBar = x;
    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+BtnWidth;
    HelpButtonInfo[i++].oper = OPER_PLAY;
    x +=  BtnDist;

    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+BtnWidth-1;
    HelpButtonInfo[i++].oper = OPER_FWD;
    x +=  BtnDist-1;

    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+BtnWidth-1;
    HelpButtonInfo[i++].oper = OPER_NEXT;
    x +=  BtnDist-1;

    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+BtnWidth;
    HelpButtonInfo[i++].oper = OPER_NEXT5;

/*
    y += 2;
    x = 3;
    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+2*BtnWidth;
    HelpButtonInfo[i++].oper = OPER_HELPPREV;


    x +=  2*BtnDist;
    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+2*BtnWidth;
    HelpButtonInfo[i++].oper = OPER_INFO;


    x = HelpWndEffWidth +2 - 2*BtnWidth;
    HelpButtonInfo[i].y  = y;
    HelpButtonInfo[i].x1 = x;
    HelpButtonInfo[i].x2 = x+2*BtnWidth;
    HelpButtonInfo[i++].oper = OPER_HELPNEXT;
*/
}


static void draw_help_board(void)
{
    wbkgdset(HelpWnd, bkgr_attr);

    wattrset(HelpWnd, fill_attr);
    wclear(HelpWnd);

    wmove(HelpWnd, 0, 0);
    wvline(HelpWnd, cCkboard, HelpWndHeight-1);
    wmove(HelpWnd, HelpWndHeight-1, 0);
    whline(HelpWnd, cCkboard, HelpWndWidth);
    wmove(HelpWnd, 0, HelpWndWidth-1);
    wvline(HelpWnd, cCkboard, HelpWndHeight-1);

}

static void  help_position(int newpos)
{   int x;

    if (HelpWnd == NULL) return;

    if (OldBarPos >=0)
    {   wattrset(HelpWnd, bar_attr);
        wmove(HelpWnd, HelpBarTop, HelpBarLeft + OldBarPos);
        waddch(HelpWnd, cBullet);
    }

    HelpCurPos = newpos;
    help_show_page(HelpCurPos);

    x =  (HelpBarLength *  HelpCurPos) / LogWidth;
    if (x >=HelpBarLength) x = HelpBarLength-1;
    wattrset(HelpWnd, HelpFocus ? thumb_attr : bar_attr);
    wmove(HelpWnd, HelpBarTop, HelpBarLeft + x);
    waddch(HelpWnd, cBlock);
    OldBarPos = x;

    wrefresh(HelpWnd);

}

static void  help_show_sect_header(void)
{    char *header = HelpSectionInfo[HelpCurSect].name;
     int x = (HelpWndWidth - 8) >> 1;
     int y = HelpWndHeight-1;

     wattrset(HelpWnd, fill_attr);
     wmove(HelpWnd, y, x);
     whline(HelpWnd, cCkboard, 8);
     x += (6-strlen(header))>>1;
     wmove(HelpWnd, y, x);
     wattrset(HelpWnd, bar_attr);
     wprintw (HelpWnd, " %s ", header);
}

void  help_accept_section(short new_section)
{
     if (HelpCurSect >= 0)
            HelpSectionInfo[HelpCurSect].position = HelpCurPos;

     HelpCurSect = new_section;

     draw_help_board();

     DispPages = HelpSectionInfo[HelpCurSect].source;
     EffPageWidth = HelpSectionInfo[HelpCurSect].page_width;
     LineCount = HelpSectionInfo[HelpCurSect].line_count;
     HelpCurPos = HelpSectionInfo[HelpCurSect].position;

     PageWidth = EffPageWidth + 5;
     PageCount = LineCount / HelpWndEffHeight;
     if (LineCount % HelpWndEffHeight) PageCount++;
     TotWidth = PageWidth * PageCount;
     if (TotWidth <= HelpWndLineWidth) LogWidth = TotWidth;
     else    LogWidth = TotWidth - HelpWndEffWidth - 3;


     /* Draw buttons */
     help_arrange_buttons();
     help_show_buttons();

     if (new_section == 1) update_info_page();
     help_show_sect_header();
     HelpFocus = 1;
     accept_focus();
//     help_position(HelpCurPos);


}

void  help_accept_focus(void)
{
        if (BottomSection < HELP_FIRST_SECTION)
        {       if (HelpFocus &&        data_active_fld < 0)
                                        data_active_fld = 0;

                decorate_browser(0);
                decorate_browser(1);

                if (data_active_fld >= 0)
                        mark_char(data_active_fld, HelpFocus);


                if (HelpFocus)
                {  data_show_track_in_browser(0, brow_cur_line[0]);
                   data_show_track_in_browser(1, brow_cur_line[1]);
                }
                else
                {  if (no_cd == 0 && track_cur != 0xff)
                      data_set_browser(0, track_cur - track_first);

                   if (PlayMode == PLAY_LIST)
                       data_set_browser(1, cur_plist_pos);
                   else
                       data_show_track_in_browser(1, brow_cur_line[1]);
                }

                wrefresh(HelpWnd);
        }
        else
           help_position(HelpCurPos);
}

int help_initialize(void)
{

    if (FourWndCount == 0)
    {
       MainWndTop1 = ScreenH /16-1;
         HelpWndHeight = ScreenH - 2*MainWndTop1  - MainWndHeight;
    }
    else
    {
       MainWndTop1 = MainWndTop;
         HelpWndHeight = (FourWndHeight-1)*FourWndCount + 2;
    }

    HelpBarTop = HelpWndHeight - 3;
    HelpWndTop =  MainWndTop1 + MainWndHeight;
    HelpWndWidth = MainWndWidth;
    HelpWndLeft =  MainWndLeft;  // (ScreenW - HelpWndWidth) >> 1;

    HelpWndLineWidth = HelpWndWidth-2;
    HelpWndEffWidth = HelpWndWidth-6;

    HelpWndEffHeight = HelpWndHeight-8;
    HelpWndEffTop = 2;

    DataLineSize = HelpWndWidth - 12;
    if (DataLineSize > 60) DataLineSize = 60;
    BrowWidth  = (HelpWndWidth - 1)>>1;
/*    BrowWidth  = HelpWndWidth - 2; */
    BrowHeight = HelpWndHeight - 9;
    DataHdrX   = (HelpWndWidth - DataLineSize-8) >> 1;
    DataLineX  = (DataHdrX + 9);
    InsOvlX =   BrowWidth + 6;  /*  HelpWndWidth/2 - 2; */
    DataScrollX1 = 3;
    DataScrollX2 = BrowWidth - 3;
    if (DataLineSize & 1) DataLineX--;

    HelpBarLength = HelpWndWidth - BtnDist*(HELP_BUTTONS-2)- BtnWidth*2 - 6;

    prepare_info_page();

    HelpSectionInfo[0].source = HelpPages;
    HelpSectionInfo[0].page_width = strlen(HelpPages[0]);
    HelpSectionInfo[0].line_count = HelpLineCount;
    HelpSectionInfo[0].name  = " Help ";
    HelpSectionInfo[0].position  = 0;

    HelpSectionInfo[1].source = InfoPages;
    HelpSectionInfo[1].page_width = INFO_LINE_SIZE;
    HelpSectionInfo[1].line_count = InfoLineCount;
    HelpSectionInfo[1].name  = "Status";
    HelpSectionInfo[1].position  = 0;

    HelpSectionInfo[2].source = MiscPages;
    HelpSectionInfo[2].page_width = 33;
    HelpSectionInfo[2].line_count = MiscLineCount;
    HelpSectionInfo[2].name  = " Misc ";
    HelpSectionInfo[2].position  = 0;


    DataFieldInfo[0].name  = "TITLE:";
    DataFieldInfo[0].source  = disc_name;
    DataFieldInfo[0].attr  = bar_attr;
    DataFieldInfo[0].offset  = 0;
    DataFieldInfo[0].pos  = 0;
    DataFieldInfo[0].y  = 1;


    DataFieldInfo[1].name = "ARTIST:";
    DataFieldInfo[1].source  = disc_artist;
    DataFieldInfo[1].attr  = bar_attr;
    DataFieldInfo[1].offset  = 0;
    DataFieldInfo[1].pos  = 0;
    DataFieldInfo[1].y  = 3;

    DataFieldInfo[2].name = "TRACK:";
    DataFieldInfo[2].source  = NULL;
    DataFieldInfo[2].attr  = AreColours ? side_attr : bar_attr;
    DataFieldInfo[2].offset  = 0;
    DataFieldInfo[1].pos  = 0;
    DataFieldInfo[2].y  = 5;

    data_active_fld = -1;
    return 1;
}


int help_activate(void)
{

    if (FourWndCount == 0)
    {  OldMainWndTop = MainWndTop;
       MainWndTop = MainWndTop1;
       mvwin(MainWnd, MainWndTop, MainWndLeft);
    }

    PlayAdvance = 0;

    set_suspend_mode(0);

    HelpWnd = newwin(HelpWndHeight, HelpWndWidth, HelpWndTop, HelpWndLeft);
    if (!HelpWnd) return 0;

    audio_stop();

    return 1;
}

void  help_deactivate(void)
{
    delwin(HelpWnd);
    HelpWnd = NULL;

    HelpFocus = 0;
    accept_focus();


#ifdef DSP_SUPPORT
    if (FourWndCount == 0)
    {
#endif
        if (OldMainWndTop >=0)
        {  MainWndTop = OldMainWndTop;
           mvwin(MainWnd, MainWndTop, MainWndLeft);
           redraw_screen();
        }
#ifdef DSP_SUPPORT
    }
    else
        init_spectrum_wnd();
#endif

    audio_reinitialize();
}

void  help_deinitialize(void)
{
    release_info_page();
}

static void  help_advance(int offset)
{
    int newpos = HelpCurPos + offset;
    if (newpos >= TotWidth) newpos -= TotWidth;
    if (newpos < 0) newpos += TotWidth;
    help_position(newpos);
}

static void  help_gotoend(void)
{  int newpos = TotWidth-HelpWndEffWidth-4;
   if (newpos <0) newpos =0;
    help_position(newpos);
}

void  help_stopplay(void)
{
    struct BTN_INFO *bi;
    OPERATION oper;
    int  ind, x, y;

    if (PlayAdvance == 0) return;

    if (PlayAdvance > 0)
    { ind = HelpPlayInd;
      oper =  OPER_PLAY;
    }
    else
    { ind = HelpPlaybackInd;
        oper = OPER_PLAYBACK;
    }

    bi = (HelpButtonInfo + ind);
    x = (bi->x1+bi->x2+1)>>1; y= bi->y;

    PlayAdvance = 0;
    wmove(HelpWnd, y, x);
    wattrset(HelpWnd, side_attr);
    waddch(HelpWnd, OperNotation[oper][1]);
}


static void  help_startplay(OPERATION oper,  short new_advance, short ind, short alt_ind )
 {
      int x, y;
        struct BTN_INFO *bi;

        bi = (HelpButtonInfo + ind);
      x = (bi->x1+bi->x2+1)>>1; y= bi->y;

      wattrset(HelpWnd, side_attr);

        if (PlayAdvance == new_advance)
      {   PlayAdvance = 0;
          wmove(HelpWnd, y, x);
//          wattrset(HelpWnd, side_attr);
          waddch(HelpWnd, OperNotation[oper][1]);
      }
      else
      {

//          wattrset(HelpWnd, bar_attr);
          wmove(HelpWnd, y, x);
          waddch(HelpWnd, OperNotation[OPER_STOP][1]);

          if (PlayAdvance != 0)   /* Sorry for redundant repetition */
          {  oper = (OPER_PLAY + OPER_PLAYBACK) - oper;
               bi = (HelpButtonInfo + alt_ind);
               x = (bi->x1+bi->x2+1)>>1; y= bi->y;
                 wmove(HelpWnd, y, x);
//             waddch(HelpWnd, OperNotation[oper][1] | side_attr);
               waddch(HelpWnd, OperNotation[oper][1]);
          }

          PlayAdvance = new_advance;
            gettimeofday(&TimePlayStart, NULL);
      }

      wrefresh(HelpWnd);
}



static OPERATION help_mouse_command(void)
{

     if ( (LastMouseEvent.bstate & BUTTON1_CLICKED) ||
          (LastMouseEvent.bstate & BUTTON2_CLICKED) ||
          (LastMouseEvent.bstate & BUTTON3_CLICKED) )
     {   int x, y, i;
         struct BTN_INFO *bi;
         x = LastMouseEvent.x - HelpWndLeft - 1;
         y = LastMouseEvent.y - HelpWndTop - 1;

           if (y!= HelpBarTop) goto AnalButtons;

         i = x - HelpBarLeft;

         if (i>=0 && i < HelpBarLength)
           {

              i = i * LogWidth / (HelpBarLength-1);
              if (i >= LogWidth) i = LogWidth;
            help_position(i);


                PlayAdvance = 0;
            return OPER_NONE;
         }


AnalButtons:
           for (i=0; i< HELP_BUTTONS+BOTTOM_BUTTONS; i++)
         { bi = HelpButtonInfo + i;

           if (y == bi->y && x >= bi->x1 && x<= bi->x2)
                 return bi->oper;
         }

      }

        return OPER_NONE;

}


OPERATION help_getaction(int key)
{

     OPERATION oper = OPER_NONE;
     struct OPER_KEYS
     { int key1; int key2; OPERATION oper; }

     keysOper[] = {{KEY_RIGHT, '6',   OPER_FWD},
                   {KEY_LEFT,  '4',   OPER_BACK},
                   {KEY_UP,    '8',   OPER_PREV},
                   {KEY_DOWN,  '2',   OPER_NEXT},
                   {KEY_B2,    '5',   OPER_STOP},
                   {KEY_IC,    '0',   OPER_STOP},
                   {KEY_HOME,  '7',   OPER_PREV5},
                   {KEY_END,   '1',   OPER_NEXT5},
                   {KEY_BACKSPACE,  '\0',   OPER_PLAYBACK},
                   { ' ',      '\0',  OPER_PLAY},
                   {KEY_PPAGE,  '9',  OPER_HELPPREV},
                   {KEY_NPAGE,  '3',  OPER_HELPNEXT}
/*                   { '?',       '\0',  OPER_QUIT}  */
                  };


    if (BottomSection < HELP_FIRST_SECTION)
                return  data_getaction(key);

    if (key == ERR) goto Fine;

    if (key==9)
    {  HelpFocus ^= 1;
         accept_focus();
         oper =OPER_SPECIAL;
       goto Fine;
    }

    if (key == KEY_MOUSE)
           oper = help_mouse_command();
    else
    if (HelpFocus)
    {   int  count = sizeof(keysOper)/sizeof(struct OPER_KEYS);
        struct OPER_KEYS *keysOperPtr = keysOper;
        while (--count>=0)
        { if(keysOperPtr->key1 == key || keysOperPtr->key2 == key)
          { oper = keysOperPtr->oper;
/*          if ((oper == OPER_PLAY) && PlayAdvance) oper = OPER_STOP; */
            break;
          }
          keysOperPtr++;
        }
    }

    switch(oper)
    {
/*
        case OPER_QUIT:
          case OPER_HELP:
              help_deactivate();
            break;
*/
        case OPER_FWD:
                PlayAdvance = 0;
                help_advance(1);
            break;

        case OPER_BACK:
                PlayAdvance = 0;
                help_advance(-1);
            break;

        case OPER_NEXT:
                PlayAdvance = 0;
                help_advance(PageWidth);
            break;

        case OPER_PREV:
                PlayAdvance = 0;
                help_advance(-PageWidth);
            break;

        case OPER_NEXT5:
                PlayAdvance = 0;
                help_gotoend();
            break;

        case OPER_PREV5:
                PlayAdvance = 0;
                help_position(0);
            break;

        case OPER_PLAY:
                help_startplay(oper,  1, HelpPlayInd, HelpPlaybackInd);
                break;

        case OPER_PLAYBACK:
                help_startplay(oper,  -1, HelpPlaybackInd, HelpPlayInd);
                break;

        case OPER_STOP:
                help_stopplay();
                break;

        case OPER_HELPNEXT:
                help_accept_section((HelpCurSect + 1) % HELP_SECTIONS);
                break;

        case OPER_HELPPREV:
                help_accept_section((HelpCurSect + HELP_SECTIONS - 1 ) % HELP_SECTIONS);
                break;

        default:
                oper = OPER_NONE;
    }

 Fine:
    if (PlayAdvance != 0)
    {  struct timeval TimeNew;

         gettimeofday(&TimeNew, NULL);

       if (time_diff(TimeNew, TimePlayStart) > HELP_PLAY_TIMEOUT)
       {   help_advance(PlayAdvance);
           TimePlayStart.tv_sec = TimeNew.tv_sec;
           TimePlayStart.tv_usec = TimeNew.tv_usec;
       }
    }

    if (HelpCurSect == 1) update_info_page();

    if (FourWndCount > 0)
            usleep((HELP_PLAY_TIMEOUT)/4);  /* Prevents a noise from speakers,
                                                 due to intensive CPU use */


    if (oper != OPER_NONE) oper = OPER_SPECIAL;
    return oper;

}

void help_redraw(void)
{  clear();
   refresh();
   touchwin(MainWnd);
   refresh();
   touchwin(HelpWnd);
   wrefresh(HelpWnd);
}

static u_short get_track_no(short brow, short line)
{
     if (line >= brow_lines[brow]) return track_last+1;
     return  brow ? cd_playlist[line] : track_first + line;
}


static void show_browser_line(u_short line, short x,  char *text, chtype attr)
{
     int l, w, c;


     l = strlen(text);
     w = BrowWidth-3; if (l > w) l =w;

     wattrset(HelpWnd,  attr);
     wmove(HelpWnd, line+8, x);

     c = l;
     while (--c >= 0) waddch(HelpWnd, (chtype)(*text++) | attr);
     c = w-l;
     while (--c >= 0) waddch(HelpWnd, (chtype)' ' | attr);

}

static void data_show_track_in_browser(short brow, short line)
{
     short   top_line, line_count;
     char    buf[65];
     chtype  attr;
     int     x = 2;

     if (brow) x += BrowWidth;


     top_line = brow_top_line[brow];
     line_count = brow_lines[brow];

     if (line < top_line || line >= top_line + BrowHeight) return;

     strcpy(buf, "");

     if (line == brow_cur_line[brow])
         attr = (HelpFocus && (data_active_browser == brow)) ? brow_hilite_attr : brow_attr;
     else
         attr = fill_attr;

     if (brow && line == line_count-1)
         strcpy(buf, "*** End of list ***");
     else
     if (line < line_count )
     {
          u_short track_no = get_track_no(brow, line);
          char *track_name = cdaudio_get_track_name(track_no);

          if (track_name !=  NULL)
                 sprintf (buf, "%2u %s", track_no, track_name);

     }

     show_browser_line(line-top_line, x, buf, attr);
}

static void align_brow_top(short brow)
{
     short  line = brow_cur_line[brow];

     if (line < brow_top_line[brow])
                brow_top_line[brow] = line;
     else
     if (line >= brow_top_line[brow] + BrowHeight)
                brow_top_line[brow] = line - BrowHeight+1;

}

static void show_browser(int brow)
{
     short i, top_line;

     top_line = brow_top_line[brow];

     for (i=0; i<BrowHeight; i++)
        data_show_track_in_browser(brow, i+top_line);
}

static void data_insert_plist_line(void)
{
    short pos, i;

    cd_playlist_size++;
    cd_playlist = realloc(cd_playlist, cd_playlist_size*sizeof(u_char));
    if (!cd_playlist) return;

    pos = brow_cur_line[1];
    i = cd_playlist_size;
    while (--i>pos)  cd_playlist[i] = cd_playlist[i-1];

    cd_playlist[pos] = get_track_no(0, brow_cur_line[0]);
    brow_lines[1] = cd_playlist_size+1;

    if (HelpFocus) data_set_browser(1, pos+1);
    show_browser(1);
    wrefresh(HelpWnd);

    DataChanged = 1;

    if (PlayMode == PLAY_LIST)
    {   cur_plist_size = cd_playlist_size;
        cur_plist = cd_playlist;
        /* No need top set position! */
    }

}

static void data_delete_plist_line(void)
{
    short pos, i;

    pos = brow_cur_line[1];
    if (pos >= cd_playlist_size) return;


    if (HelpFocus)
    { short track_no = get_track_no(1, pos);
      data_set_browser(0, track_no-track_first);
    }

    cd_playlist_size--;
    for (i=pos; i<cd_playlist_size; i++)
                cd_playlist[i] = cd_playlist[i+1];

    /* No need to realloc */
    brow_lines[1] = cd_playlist_size+1;
    show_browser(1);
    wrefresh(HelpWnd);

    DataChanged = 1;

    if (PlayMode == PLAY_LIST)
    {   cur_plist_size = cd_playlist_size;
   /*     cur_plist = cd_playlist; */
        /* No need top set position! */
    }

}

static void show_padded_line(char *text, chtype attr)
{
        int  len, count;

        len = text ? strlen(text) : 0;
        if (len > DataLineSize) len = DataLineSize;

        count = len;
        while (--count >= 0) waddch(HelpWnd, *text++ | attr);

        count = DataLineSize - len;
        while (--count >= 0) waddch(HelpWnd, (chtype)' ' | attr);

}

static void data_draw_single_field(short i)
{
        short  y = DataFieldInfo[i].y;
        chtype attr = DataFieldInfo[i].attr;
        short  off  = DataFieldInfo[i].offset;

        wmove(HelpWnd, y, DataLineX);
        wattrset(HelpWnd, attr);
        show_padded_line(DataFieldInfo[i].source+off, attr);
}

static void data_draw_info(void)
{       short i;
        static short dumb;



        brow_cur_line[0] = track_cur - track_first;
        brow_cur_line[1] =
            (PlayMode == PLAY_LIST) ? cur_plist_pos : 0;

        dumb = no_cd || track_cur > track_last;

        if (dumb)
        {   brow_lines[0] = 0;
            brow_lines[1] = 1;
        }
        else
        {   brow_lines[0] = track_last - track_first + 1;
            brow_lines[1] = cd_playlist_size+1;
        }




        DataFieldInfo[2].source = dumb ? ""
                        : cdaudio_get_track_name(track_cur);

        for (i=0; i<3; i++)
        {   if (dumb)
             DataFieldInfo[i].offset =
             DataFieldInfo[i].pos = 0;
             data_draw_single_field(i);
        }

        for (i=0; i<2; i++)
        {  align_brow_top(i);
           show_browser(i);
        }

}

void data_draw_fields(void)
{

/*      data_track = track_cur; */


      data_draw_info();
      if(!no_cd) mark_char(data_active_fld, 1);
      wrefresh(HelpWnd);
}

static void data_draw_insert(void)
{
        char *text = InsertMode ? " Ins " : " Ovl ";

        wmove(HelpWnd, HelpWndHeight-1, InsOvlX);
        wattrset(HelpWnd, fill_attr);
        waddstr(HelpWnd, text);

}

static void decorate_browser(short brow)
{       int x, x1;
        static char *brow_names[] = {" Tracks ", " Play List "};
        char *name;
        chtype attr;

        x = brow ? BrowWidth : 0;
        attr = side_text_attr;
        if (HelpFocus && brow == data_active_browser)
                         attr = side_attr;

        name = brow_names[brow];
        wattrset(HelpWnd, attr);
        x1 = x + 1 + ((BrowWidth - strlen(name)) >> 1);
        mvwaddstr(HelpWnd, 7, x1, name);

        wattrset(HelpWnd, btn_attr);
        x1 = x + DataScrollX1;
        mvwaddch(HelpWnd, 7, x1, cUpArrow);
        mvwaddch(HelpWnd, HelpWndHeight-1, x1, cDownArrow);

        x1 = x + DataScrollX2;
        mvwaddch(HelpWnd, 7, x1, cUpArrow);
        mvwaddch(HelpWnd, HelpWndHeight-1, x1, cDownArrow);
}

static void data_draw_static(void)
{
        short i, y, x;
        const char *txt;
        chtype attr;

        for (i=0; i<3; i++)
        {
                y = DataFieldInfo[i].y;

                wmove(HelpWnd, y, DataHdrX);
                wattrset(HelpWnd, text_attr);
                waddstr(HelpWnd, DataFieldInfo[i].name);

                wmove(HelpWnd, y, DataLineX);
                attr = DataFieldInfo[i].attr;
                wattrset(HelpWnd, attr);
                show_padded_line(DataFieldInfo[i].source, attr);
        }

        /* Separation lines */
        wattrset(HelpWnd, fill_attr);
        wmove(HelpWnd, 7, 1);
        whline(HelpWnd, cCkboard, HelpWndWidth-2);

        wmove(HelpWnd, 8, BrowWidth);
        wvline(HelpWnd, cCkboard, HelpWndHeight-7);

        /* Browsers */
        decorate_browser(0);
        decorate_browser(1);

        /* Buttons */
        y = HelpWndHeight - 1;
        x = 6;
        for (i=0; i<3; i++)
        {   txt = DataBtnNames[i];

            if (i== 0)
            {  x = 6;  attr = btn_attr; }
            else
            if (i== 1)
            {  x = HelpWndWidth-14; attr = btn_attr; }
            else
            {  x = BrowWidth-13;
               attr = SaveData ? side_attr : side_dim_attr;
            }

            wattrset(HelpWnd, attr);
            mvwaddstr(HelpWnd, y, x, txt);
            DataButtonInfo[i].y = y;
            DataButtonInfo[i].x1 = x;
            x += strlen(txt) - 1;
            DataButtonInfo[i].x2 = x;
            DataButtonInfo[i].oper = i;
          /*  x = (BrowWidth - 13); */
            x = HelpWndWidth - 14;
         }

         /* Transfer buttons */
         wattrset(HelpWnd, btn_attr);

         x = BrowWidth; y = 9;
         mvwaddch(HelpWnd, y, x, cRightArrow);
         DataButtonInfo[i].y = y;
         DataButtonInfo[i].x1 = x;
         DataButtonInfo[i].x2 = x;
         DataButtonInfo[i].oper = i;  /* Add playlist */
         i++;

         y = HelpWndHeight-3;
         mvwaddch(HelpWnd, y, x, cLeftArrow);
         DataButtonInfo[i].y = y;
         DataButtonInfo[i].x1 = x;
         DataButtonInfo[i].x2 = x;
         DataButtonInfo[i].oper = i;  /* Del playlist */




}
/* ctrl_no = field number
   active  = 0/1   show as inactive/active field */

void  mark_char(short fld_no, short active)
{       short   x, y, len;
      char      *src;
        chtype attr, c;
        short  pos;

        if (active && !HelpFocus) return;

        pos = DataFieldInfo[fld_no].pos;
      src = DataFieldInfo[fld_no].source;
        len = strlen(src);
        if (pos >= len) { pos = len;
                                DataFieldInfo[fld_no].pos = pos;
                                c = ' ';
                            }
                   else c = *(src+pos);

      if (active && c ==  ' ') c = cDiamond;

        pos -= DataFieldInfo[fld_no].offset;
        if (pos < 0) return;
        x = DataLineX + pos;
        y = DataFieldInfo[fld_no].y;
      attr = active ? thumb_attr : DataFieldInfo[fld_no].attr;
        wmove(HelpWnd, y, x);
        wattrset(HelpWnd, attr);
        waddch(HelpWnd, c | attr);

}


static void activate_data_fld(short new_field)
{
        if (data_active_fld >= 0)  /* && data_active_fld != new_field) */
                mark_char(data_active_fld, 0);

        data_active_fld = new_field;

        if (data_active_fld >= 0)
                mark_char(data_active_fld, 1);

}

void  data_accept_section(short new_section)
{

        PlayAdvance = 0;
        draw_help_board();
        brow_top_line[0] = brow_top_line[1] = 0;

        data_draw_static();
        data_draw_insert();

        HelpFocus = 0;

        if (no_cd == 0)
        {
/*           if (brow_cur_line[0] == 0xff) brow_cur_line[0] = track_cur - track_first;
           if (brow_cur_line[1] == 0xff &&  */
           if (data_active_fld < 0) data_active_fld = 0;
           data_draw_info();
           accept_focus();
/*         activate_data_fld(data_active_fld);  */
        }

        wrefresh(HelpWnd);

}

static short adjust_offset(int pos)
{       short off = DataFieldInfo[data_active_fld].offset;

        if (off > pos)
          off = pos;
        else
        if (off+DataLineSize <= pos)
          off = pos - DataLineSize+2;
        else
            return 0;

      DataFieldInfo[data_active_fld].offset = off;
        return 1;
}


static void advance_data_field(short shift)
{
        short   len;
        char    *src;
        short newpos;

        newpos = DataFieldInfo[data_active_fld].pos + shift;
        src = DataFieldInfo[data_active_fld].source;
        len = strlen(src);

        if (newpos < 0 || newpos > len) return;

        if (adjust_offset(newpos))
                data_draw_single_field(data_active_fld);

        mark_char(data_active_fld, 0);

        DataFieldInfo[data_active_fld].pos = newpos;
        mark_char(data_active_fld, 1);
        wrefresh(HelpWnd);
}

void data_set_browser(int brow, short value)
{

        brow_cur_line[brow] = value;
        align_brow_top(brow);
        show_browser(brow);

        if (brow == 0)
        {  short track_no = get_track_no(brow, value);
           char *src = cdaudio_get_track_name(track_no);
           short  len  = strlen(src);

            DataFieldInfo[2].source = src;
            if (DataFieldInfo[2].pos > len) DataFieldInfo[2].pos = len;

            data_draw_single_field(2);
            if (data_active_fld == 2)
               mark_char(data_active_fld, 1);
        }

        wrefresh(HelpWnd);
}

static void advance_browser(int brow, short shift)
{
    short new_value = brow_cur_line[brow] + shift;
    short max_value = brow_lines[brow]-1;

    if (new_value < 0) new_value = 0;
    if (new_value > max_value) new_value = max_value;

    data_set_browser(brow, new_value);
}

static void     data_perform_button_action(short action)
{
        switch (action)
        {
           case 0:
                cddb_write();
                break;

           case 1:
                cddb_find();
                data_draw_fields();
                break;

           case 2:
           {    chtype attr;
                short x, y;
                SaveData ^= 1;
                attr = SaveData ? side_attr : side_dim_attr;
                x = DataButtonInfo[action].x1;
                y = DataButtonInfo[action].y;
                wattrset(HelpWnd, attr);
                mvwaddstr(HelpWnd, y, x, "  Auto  ");
           }
                break;

           case 3:
                data_insert_plist_line();
                break;

           case 4:
                data_delete_plist_line();
                break;



     }
}

static OPERATION data_process_mouse(void)
{   short x, y, pos, i, len;
    OPERATION oper = OPER_NONE;

    x = LastMouseEvent.x - HelpWndLeft - 1;
    y = LastMouseEvent.y - HelpWndTop - 1;

    if ( LastMouseEvent.bstate &
              (BUTTON1_CLICKED | BUTTON2_CLICKED | BUTTON3_CLICKED) )
    {
           pos = x - DataLineX;
           if (pos >= 0 && pos < DataLineSize)
           {   for (i=0; i<3 && DataFieldInfo[i].y != y; i++);

               if (i<3)
                 {  len = strlen(DataFieldInfo[i].source);
                    if (pos > len) pos = len;
                    mark_char(data_active_fld, 0);
                    DataFieldInfo[i].pos = pos;
                    data_active_fld = i;
                    mark_char(data_active_fld, 1);
                    if (!HelpFocus)
                {  HelpFocus = 1;
                       accept_focus();
                }
                    oper = OPER_SPECIAL;
                  }

            }

           pos = x;
           if (pos > 0 && pos < BrowWidth)
           {
               if (y >=7  && y < HelpWndHeight -1)
                {  if (y==7 || HelpFocus)
                   {  HelpFocus = 1;
                      data_active_browser = 0;
                      accept_focus();
                   }
                }

               if (y >= 8 && y <HelpWndHeight-1)
               {
                        short new_line = brow_top_line[0] + y-8;

                        if (new_line < brow_lines[0])
                        {  short old_line = brow_cur_line[0];

                           data_set_browser(0, new_line);

                           if (LastMouseEvent.bstate & BUTTON3_CLICKED)
                                  data_insert_plist_line();
                           else
                           if (!HelpFocus || LastMouseEvent.bstate & BUTTON2_CLICKED ||
                                              old_line == new_line)
                                  cd_playtrack(new_line + track_first, 0);
                        }

                        oper = OPER_SPECIAL;
               }
           }

           pos = x - BrowWidth;
           if (pos > 0 && pos < BrowWidth)
           {    if (y >=7  && y < HelpWndHeight - 1)
                {  if (y==7 || HelpFocus)
                   {  HelpFocus = 1;
                      data_active_browser = 1;
                      accept_focus();
                   }
                }

                if (y >= 8 && y <HelpWndHeight-1)
                {
                       short max_line = brow_lines[1];
                       short new_line = brow_top_line[1] + y-8;

                 /*      if (!HelpFocus && PlayMode == PLAY_LIST) max_line--; */
                       if (new_line < max_line)
                       {
                          short old_line = brow_cur_line[1];

                          data_set_browser(1, new_line);

                          if (LastMouseEvent.bstate & BUTTON3_CLICKED)
                                    data_delete_plist_line();
                          else
                          if (new_line < brow_lines[1]-1 &&
                               ( ! HelpFocus ||
                                 LastMouseEvent.bstate & BUTTON2_CLICKED ||
                                 old_line == new_line
                               )
                            )
                          {     short track_no = get_track_no(1, new_line);
                                short new_line_alt = track_no - track_first;
                                short old_line_alt = brow_cur_line[0];

                                data_set_browser(0, new_line_alt);

                                if (!HelpFocus || old_line_alt == new_line_alt)
                                { if(PlayMode == PLAY_LIST) cur_plist_pos = new_line;
                                    cd_playtrack(track_no, 0);
                                }
                          }


                       }
                        oper = OPER_SPECIAL;
               }
           }


           if (oper != OPER_SPECIAL)
           { for (i=0; i<5; i++)
                {  if (DataButtonInfo[i].y != y) continue;
                   if (DataButtonInfo[i].x1 <= x && DataButtonInfo[i].x2 >= x) break;
                }
                if (i<5)
                {  data_perform_button_action(i);
                   oper = OPER_SPECIAL;
                }
          }

    }
    if ( LastMouseEvent.bstate &
              (BUTTON1_CLICKED | BUTTON2_PRESSED | BUTTON3_PRESSED) )
    {      pos = x; i = -1;
           if (pos == DataScrollX1 || pos == DataScrollX2) i=0;
           else
	     { pos -= BrowWidth;	
             if (pos == DataScrollX1 || pos == DataScrollX2) i=1;
           }
	     if (i >= 0)	 
           {   if (y == 7 && brow_top_line[i] > 0 )
               {  brow_top_line[i]--;
                     if (HelpFocus) data_set_browser(i, brow_cur_line[i]-1);
                               else show_browser(i);
                     oper = OPER_SPECIAL;
	         }
               else
               if (y == HelpWndHeight-1 &&
                   brow_top_line[i]+BrowHeight < brow_lines[i])
               {    brow_top_line[i]++;
                    if (HelpFocus) data_set_browser(i, brow_cur_line[i]+1);
                            else show_browser(i);
                    oper = OPER_SPECIAL;
               }
            }
    }

    if (oper != OPER_NONE)
       wrefresh(HelpWnd);

    return oper;

}

u_short get_kbd_shift(void)
{
#ifdef TIOCLINUX
        u_char argp = 6;
        if (ioctl(cur_term->Filedes, TIOCLINUX, &argp) >= 0)
           return (u_short) argp;
#endif
        return 0;
}


static OPERATION  data_process_key(int key)
{
      char      *src;
        short pos, len;

        pos = DataFieldInfo[data_active_fld].pos;
        src = DataFieldInfo[data_active_fld].source;
        len = strlen(src);

        if (key == KEY_IC)
        {  InsertMode ^= 1;
           data_draw_insert();
           wrefresh(HelpWnd);
           return OPER_SPECIAL;
        }

        if (key == KEY_BACKSPACE)
        {  if (--pos >= 0)
         {  strcpy(src+pos, src+pos+1);
                DataFieldInfo[data_active_fld].pos = pos;
                DataChanged = 1;
           }
           else pos = 0;
        }
        else
        if (key == KEY_DC)
        {  strcpy(src+pos, src+pos+1);
           DataFieldInfo[data_active_fld].pos = pos;
           DataChanged = 1;
        }
        else
        if (key <= 0xff && key >= ' ')
        {
            if (InsertMode && len < 60)
            {  int i = len+1;
             while (i>pos)
                 {  *(src+i) = *(src+i-1);
                    i--;
             }
            }

            *(src+pos) = key;
            if (++pos < 60)
            {  if (pos > len) *(src+pos) = '\0';
                 DataFieldInfo[data_active_fld].pos = pos;
          }

          DataChanged = 1;
        }
        else
           return OPER_NONE;


        adjust_offset(pos);

        if (data_active_fld == 2)
        {   if (HeaderMode == 2 && brow_cur_line[0] + track_first == track_cur)
                                         draw_header();
            data_show_track_in_browser(0, brow_cur_line[0]);
        }
        else
        if (HeaderMode == 1)  draw_header();

        data_draw_single_field(data_active_fld);
        mark_char(data_active_fld, 1);

        wrefresh(HelpWnd);

        return OPER_SPECIAL;
}



static OPERATION data_getaction(int key)
{   OPERATION oper = OPER_NONE;
    short  brow;
    short shift;

    if (no_cd || track_cur == 0xff || key == ERR) goto Fine;

    /* Process tab key */
    /*
    if (key==9 || key == KEY_F(5))
    {    int shift = get_kbd_shift() & 1;

         if (HelpFocus && data_active_browser == shift)
              data_active_browser ^= 1;
         else
         {    HelpFocus ^= 1;
              data_active_browser = shift;
         }

         accept_focus();
         oper =OPER_SPECIAL;
         goto Fine;
    }
    */

    shift = get_kbd_shift() & 1;

    if (key==9 || key == KEY_F(5) || key == KEY_F(6))
    {
         if (shift || key == KEY_F(6))
              data_active_browser ^= 1;
         else
              HelpFocus ^= 1;

         accept_focus();
         oper =OPER_SPECIAL;
         goto Fine;
    }

    /* Process enter key */
    if (key == KEY_ENTER || key == 13)
    {     activate_data_fld((data_active_fld +
                              ( shift ? (DATA_FIELDS-1) : 1)) % DATA_FIELDS);
          wrefresh(HelpWnd);
          oper =OPER_SPECIAL;
          goto Fine;
    }

    if (key == KEY_MOUSE)
         oper = data_process_mouse();
    else
    if (HelpFocus && key != ERR)
    {
       oper = OPER_SPECIAL;

       brow = data_active_browser ^ shift;

       switch(key)
         {
           case 0xc:    /* Ctrl+L */
                data_perform_button_action(1);
                break;

           case 0x12:    /* Ctrl+R */
                redraw_screen();
                break;

           case 0x13:    /* Ctrl+S */
                data_perform_button_action(0);
                break;

           case 0x1:    /* Ctrl+A */
                data_perform_button_action(2);
                wrefresh(HelpWnd);
                break;

           case 0x11:    /* Ctrl+Q */
                oper = OPER_QUIT;
                break;

           case 0x18:    /* Ctrl+X */
                oper = OPER_STOPQUIT;
                break;

           case KEY_RIGHT:
                if (shift)
                    data_insert_plist_line();
                else
                    advance_data_field(1);
                break;

           case KEY_LEFT:
                if (shift)
                    data_delete_plist_line();
                else
                     advance_data_field(-1);
                break;

           case KEY_UP:
                advance_browser(brow, -1);
                break;

           case KEY_DOWN:
                advance_browser(brow, 1);
                break;

           case KEY_PPAGE:
                advance_browser(brow, -BrowHeight);
                break;

           case KEY_NPAGE:
                advance_browser(brow, BrowHeight);
                break;

           case KEY_HOME:
                data_set_browser(brow, 0);
                break;

           case KEY_END:
                data_set_browser(brow, brow_lines[brow]-1);
                break;

           case KEY_B2:
           case KEY_F(7):
                if (brow) data_delete_plist_line();
                     else data_insert_plist_line();
                break;


           default:
                oper = data_process_key(key);
         }
    }

Fine:
    if (FourWndCount > 0)
            usleep((HELP_PLAY_TIMEOUT)/4);  /* Prevents a noise from speakers,
                                                 due to intensive CPU use */

/*    if (oper != OPER_NONE) oper = OPER_SPECIAL; */
    return oper;
}

