/*  =========================================================
    SING - ALONG DISK PLAYER.
    (C) 1998, 1999   Michael Glickman.  xsadp@yahoo.com
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See GNU general public licence (GPL) available at
	    ftp://metalab.unc.edu/pub/gnu/COPYING for details
	    and legal issues.

            You are expected to provide appropriate references
            when using a part of the code in your software.

	    Author strongly advices against using this code, or
	    a part of it, in an application designed to run  on
	    any Microsoft(tm) platfrom.
    ========================================================= */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <pwd.h>
#include <linux/types.h>
#include <linux/cdrom.h>
#include "sad.h"


extern  TRACK_INFO  *trk_info;
extern  u_char dtrack_first, dtrack_last, track_first;
extern  char disc_name[], disc_artist[];
extern  char *ShortDBName;
extern  short   cd_playlist_size;
extern  u_char	*cd_playlist;

static char *DBName = NULL;
const  char *TmpFileName = "~/.xcddbase.tmp";
short  new_cd_in_db = 1;

/* ===============================================================
    Converts the tilded name into full path.
    ------------------------------------------------------------
    Was copied unchanged from my another application: itetris.
    I wonder if it could be done with less effort.
   =============================================================== */
char *GetFullFileName(const char *filename)
{  char *fname;
   char *home = NULL;
   int  l;

   if (!filename) return NULL;

   l = 0;

   if (*filename == '~')
   {  int ul;

      filename++;

      fname = strchr(filename, '/');
      if (!fname) goto Adelante;

      ul = fname - filename;

      if (!ul)
          home = getenv("HOME");   // User home directory
      else
      {   struct passwd *pwent;

          home = NULL;

          fname = malloc(ul+1);
          if (!fname) goto Adelante;

          memcpy(fname, filename, ul);
          fname[ul] = '\0';
          pwent = getpwnam(fname);
          free(fname);

          if (pwent)
          {  home = pwent->pw_dir;
             if (home) filename += ul;
          }

      }

      if (home) l=strlen(home);
   }

Adelante:
   l += strlen(filename) + 1;

   fname = (char *) malloc(l);

   if (fname)
   { if (home)
     { strcpy(fname, home);
       strcat(fname, filename);
     }
     else
       strcpy(fname, filename);
   }

   return fname;
}

void cddb_initialize(void)
{
    DBName = GetFullFileName(ShortDBName);

}

void cddb_terminate(void)
{
   if (DBName) free(DBName);
}

/* ===============================================================
  Unlike xcd, this will avoid reading the whole DB into the memory
  It takes so much memory already, that there is no need to waste it
  In addition, this will enable a multiuser access to DB
   =============================================================== */
void process_plist(FILE *f)
{   u_int  w;
    short i;


    fscanf(f, "%u", &w);
    cd_playlist_size = w;

    cd_playlist = malloc(cd_playlist_size * sizeof(u_char));
    if (!cd_playlist)
    { cd_playlist_size = 0; return; }

    for (i=0; i<cd_playlist_size; i++)
    {	fscanf(f, "%u", &w);
	cd_playlist[i] = w;
    }

}


static void get_text_fld(FILE *f, char *buf, char *target)
{    fgets(buf, 80, f);
     buf[80] = 0;
     strtok(buf, "\n");
     memcpy(target, buf+1, 60);
     *(target+60) = 0;
}

void cddb_find(void)
{
    FILE *f;
    char buf[81];
    TRACK_INFO *ti;
    u_long start;
    int i;

    new_cd_in_db = 1;
    f = fopen(DBName, "r");
    if (!f) return; 	              /* That's fine ! */

    if (cd_playlist) free(cd_playlist);
    cd_playlist_size = 0;

    while (!feof(f))
    {
    /* Looking for 'tracks' keyword */
       fgets(buf, 8, f);
       if (strcmp(buf, "tracks ")) goto Adelante;


    /* Comparing number of tracks */
       if (fscanf(f, "%d", &i) == 0 || dtrack_last != i) goto Adelante;

    /* Comparing track data */
       ti = trk_info;
	 i = dtrack_last;
       while (--i >= 0)
       {  if (fscanf(f, "%lu", &start) == 0 || ti->start != start)
                                       break;
	    ti++;
       }

       if (i >=0) goto Adelante;
	 fgets(buf, 12, f);
	 if (sscanf(buf, "%lu",  &start) > 0
                    && ti->start/CD_FRAMES == start)
				goto Trovano;
	 continue;

    Adelante:
	fflush(f);
     }

     goto Malfortuna;

Trovano:
     fflush(f);

     /* We found it! Unbelieva-b-b-b-le
        Parse other relevant lines now.
     */

     new_cd_in_db = 0;
     ti = trk_info;
     while (!feof(f))
     { fscanf(f, "%s", buf);


       if (!strcmp(buf, "tracks")) break;

       if (!strcmp(buf, "cdname"))
	   get_text_fld(f, buf, disc_name);
       else
       if (!strcmp(buf, "artist"))
	   get_text_fld(f, buf, disc_artist);
       else
       if (!strcmp(buf, "track"))
       {   get_text_fld(f, buf, ti->name);
	   ti++;
       }
       else
       if (!strcmp(buf, "plist"))
          process_plist(f);
     }

Malfortuna:

     fclose(f);
     return;
}


/* ===============================================================
  This rather tricky algorithm manages to update xcd data base
  without loading the whole data at once.
   =============================================================== */
static void  save_cd_time(FILE *fo)
{    short i;
     TRACK_INFO *ti;

     fprintf (fo, "tracks %u", (u_int)dtrack_last);


	i = dtrack_last;
	ti = trk_info;

	while (--i>=0)
      { fprintf (fo, " %lu", ti->start);
	  ti++;
      }

	fprintf (fo, " %lu\n", ti->start / CD_FRAMES);
}

static void  save_cd_info(FILE *fo)
{     int i;
      TRACK_INFO *ti;

 	fprintf(fo, "cdname %s\n", disc_name);
 	fprintf(fo, "artist %s\n", disc_artist);

	/* Patching XCD bug */

	i = dtrack_last;
	ti = trk_info;
 	while (--i >=0)
      {  fprintf (fo, "track %s\n", ti->name);
	   ti++;
      }

      /* Saving playlist */
      if (cd_playlist_size <=0) return;
      fprintf (fo, "plist %d", (int)cd_playlist_size);

      for (i=0; i<cd_playlist_size; i++)
          fprintf (fo, " %u", (u_int)cd_playlist[i]);

      fprintf (fo, "\n");

 }

int cddb_write(void)
{
    FILE *f = NULL, *fo;
    char buf[81];
    TRACK_INFO *ti;
    u_long start;
    int  i;
    int bypass = 0, disc_ok;
    char *tmpname =  GetFullFileName(TmpFileName);
    int found = 0;

    fo = fopen(tmpname, "w+");
    if (!fo)
    {  fprintf(stderr, "Failed to open temporary file %s:\n", tmpname);
       perror("");
       fclose(f); return 0;  }


    f = fopen(DBName, "r");
    if (!f) goto Malfortuna;

    while (!feof(f))
    {
    /* Looking for 'tracks' keyword */
       fgets(buf, 8, f);
       if (strlen(buf) < 7) continue;
       if (strcmp(buf, "tracks ")) goto Adelante;

    /* Found 'tracks' record */
       bypass = 0;
       fprintf(fo, "%s", buf);

    /* Comparing/copying number of tracks */
       if (fscanf(f, "%d", &i) == 0) goto Malfortuna;
       fprintf(fo, "%d ", i); 	/* Copy number of tracks */
       disc_ok = (i == dtrack_last);

    /* Comparing/copying track data */
       ti = trk_info;
       while (--i >= 0)
       {  if (fscanf(f, "%lu", &start) == 0) goto Malfortuna;
	    fprintf(fo, "%lu ", start);
          if (disc_ok)
          {  disc_ok = (ti->start == start);
	       ti++;
          }
       }

       if (fscanf(f, "%ld", &start) == 0) goto Malfortuna;
       fprintf (fo, "%ld", start);
       if (disc_ok)
	     disc_ok = (ti->start/CD_FRAMES == start);

	 fprintf(fo, "\n");

	 if (disc_ok)
	 { found = 1;
	   save_cd_info(fo);
         bypass = 1;
       }
	 else
         bypass = 0;


	 continue;

    Adelante:
	 if (bypass) fflush(f);
	 else if (!feof(f))
	 {  fprintf(fo, "%s", buf);
	    if (fgets(buf, 80, f)) fprintf (fo, "%s", buf);
       }

     }


Malfortuna:
     if (!found)
     {   save_cd_time(fo);
         save_cd_info(fo);
     }
     fprintf (fo, "\n");
     fclose(fo);
     if (f) fclose(f);
     if (rename(tmpname, DBName))
     {   fprintf(stderr, "Error writing CD data base: %d (%s)\n", errno, strerror(errno));
         fprintf(stderr, "New data base is stored as %s\n", tmpname);
     }

     if (tmpname) free(tmpname);

     new_cd_in_db = 0;
     return 1;
}

