/*  =========================================================
    SING - ALONG DISK PLAYER.  (C) 1998, Michael Glickman        
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See GNU general public  licence  (GPL) included  in
		this distribution for the details and legal issues.
    
            You are expected to provide appropriate references
            when using a part of the code in your software. 

		Author strongly advices against using this code, or
		a part of it, in an application designed to run  on
		any Microsoft(tm) platfrom.
    ========================================================= */
#include "sadp_gpm_support.h"
#include <sys/types.h>

#if GPM_SUPPORT
#include <sys/time.h>
#include <sys/ioctl.h>
#include <linux/vt.h>


#include <unistd.h>
#include <fcntl.h>
#include <gpm.h>
#endif

#include <curses.h>
#include "sad.h"


#if GPM_SUPPORT
/*static int  gpm_pointer; */
static int IsMouseEvent;
static Gpm_Event MouseEvent;    
static mmask_t ButtonMask;
extern int	   ttyno;

/*
static struct
     { char subcode;
       short xs, ys, xe, ye;
       short sel_mode;
     } set_sel_arg;
*/

static int CheckTTY(void)
{   struct vt_stat vts;
  
    if (ttyno < 0) return 0;

    ioctl(gpm_consolefd, VT_GETSTATE, &vts);	

    return (vts.v_active == ttyno) ? 1: 0;
}  

void mouse_gpm_drawpointer(void)
{
     if (CheckTTY()) 
        Gpm_DrawPointer(MouseEvent.x, MouseEvent.y, gpm_consolefd); 
}

void ProceedPressedButtons(int MouseB)
{ 
    mmask_t NewButtonMask = 0;

     if (MouseB & GPM_B_LEFT) 
     {  if (!(ButtonMask & BUTTON1_PRESSED))  NewButtonMask |= BUTTON1_CLICKED;
        NewButtonMask |= BUTTON1_PRESSED;
     }
     	

     if (MouseB & GPM_B_MIDDLE)
     {  if (!(ButtonMask & BUTTON2_PRESSED))  NewButtonMask |= BUTTON2_CLICKED;
        NewButtonMask |= BUTTON2_PRESSED;
     }


     if (MouseB & GPM_B_RIGHT)
     {  if (!(ButtonMask & BUTTON3_PRESSED))  NewButtonMask |= BUTTON3_CLICKED;
        NewButtonMask |= BUTTON3_PRESSED;
     }

     ButtonMask = NewButtonMask;

}

void ProceedReleasedButtons(int MouseB)
{ 

     if (MouseB & GPM_B_LEFT)
        ButtonMask &= ~(BUTTON1_PRESSED | BUTTON1_CLICKED);
     
     	

     if (MouseB & GPM_B_MIDDLE)
        ButtonMask &= ~(BUTTON2_PRESSED | BUTTON2_CLICKED);


     if (MouseB & GPM_B_RIGHT)
        ButtonMask &= ~(BUTTON3_PRESSED | BUTTON3_CLICKED);


}


void mouse_gpm_deinitialize(void)
{
    while (Gpm_Close()); /* close all the stack */

}

int gpm_getch(void) 
{
   int key;	


   key = getch();
   if (key != ERR) return key;
		
   fcntl(gpm_fd, F_SETFL, O_NDELAY );
   IsMouseEvent = Gpm_GetEvent(&MouseEvent);

   if (IsMouseEvent)
   {
       if (MouseEvent.type & GPM_MOVE)  
		  mouse_gpm_drawpointer();


//     ButtonMask &= ~(BUTTON1_CLICKED | BUTTON2_CLICKED | BUTTON3_CLICKED |
//			   BUTTON1_PRESSED | BUTTON2_PRESSED | BUTTON3_PRESSED);


     if (MouseEvent.type & GPM_DOWN)
     {    ProceedPressedButtons(MouseEvent.buttons);
          return KEY_MOUSE;
     }

     if (MouseEvent.type & GPM_UP)
           ProceedReleasedButtons(MouseEvent.buttons);


   }
   
  
   return ERR;

}		 

int gpm_getmouse(MEVENT *mevent)
{

	mevent->id = gpm_fd;
	mevent->x = MouseEvent.x;
	mevent->y = MouseEvent.y;


	mevent->bstate = ButtonMask; 

        return (ButtonMask != 0);
}	 

int mouse_gpm_initialize(void)
 {   Gpm_Connect conn;


     conn.eventMask=~0 ;
     conn.defaultMask=~GPM_HARD;
     conn.maxMod=~0;
     conn.minMod= 0;

     gpm_visiblepointer = 0;
/*     gpm_pointer = open ("/dev/console", O_RDWR); */
     ButtonMask = 0;
     if (Gpm_Open(&conn, 0) !=-1)
     { 
        Gpm_GetSnapshot(&MouseEvent);
	  ProceedPressedButtons(MouseEvent.buttons);
	  IsMouseEvent = 0;
	  return 1;
     }

     return 0;
}

#endif

int native_getmouse(MEVENT *event)
{
    mmask_t bstate;
//    static mmask_t oldstate = 0;
    
    if (getmouse(event) != OK) return 0;


    bstate = event->bstate;
    
    if (bstate & BUTTON1_PRESSED) //  && !(oldstate & BUTTON1_PRESSED))
			     bstate |= BUTTON1_CLICKED;

    if (bstate & BUTTON2_PRESSED) //  && !(oldstate & BUTTON2_PRESSED))
			     bstate |= BUTTON2_CLICKED;
			     
    if (bstate & BUTTON3_PRESSED) //  && !(oldstate & BUTTON3_PRESSED))
			     bstate |= BUTTON3_CLICKED;
    
//    oldstate = event->bstate;    
    event->bstate = bstate;

    (event->x) ++;
    (event->y) ++;
    
    return 1;
}    	
