/*  =========================================================
    SING - ALONG DISK PLAYER.  (C) 1998, Michael Glickman
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See GNU general public  licence  (GPL) included  in
		this distribution for the details and legal issues.

            You are expected to provide appropriate references
            when using a part of the code in your software.

		Author strongly advices against using this code, or
		a part of it, in an application designed to run  on
		any Microsoft(tm) platfrom.
    ========================================================= */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <term.h>
#include <time.h>
#include <linux/major.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "sad.h"
#include "sadp_curses.h"

extern int	 ScreenW, ScreenH;
extern char  CDDeviceName[];
extern char  AudioDeviceName[];
extern char  MixerDeviceName[];
extern u_int SamplingRate;
extern short FourWndCount;
extern short AutoPlay;
extern short CharSet;
extern long  FrameInterval;
extern short FourInterlace;
extern short SaveSet, SaveData;
/*extern short BkgrColour = -1; */
extern short ProbeCD;
extern short FourInterlace;
extern MOUSE_SUPPORT_OPTION MouseSupport;
extern u_char CDDeviceType, CDNodeNumber;
extern int    TimeoutStart, TimeoutLoad, TimeoutRepos;
extern long   ft_bufsize;
extern short  AreColours;
extern short  WaveObturate;
extern long   TimeStart;
extern double Frames;
extern char *ShortDBName;

#define MAX_LINES 200

char   **InfoPages;
short  InfoLineCount;

static double FramesPerSec;
static int    EfficLineNo;


static const  char *empty = "";
static const  char *yes = "yes";
static const  char *no =  "no";

static char *charset_names[] = {"PC", "ALT", "ANSI", "ACS"};
static char *mouse_names[] = {"DISABLED", "NCURSES", "GPM"};


static int get_cpu_type(char *line, const char *sign, char *retval)
{
   char *ptr;

   if (retval && strncmp(line, sign, strlen(sign)) == 0)
   {  ptr = strchr(line, ':');
      if (ptr)
      {  if (*++ptr == ' ') ptr++;
         strcpy(retval, ptr);
         strtok(retval, "\n\r\t");
         return 1;
      }
   }

   return 0;
}

static int get_audio_name(const char *file_name, const char *pattern,
				  const char *section_name,
				  char  *device_name,
                          short *node_no,
                          char  *logical_name_start,
				  char  *logical_name_end)
{
	struct stat stat_info;
	dev_t  rtdev;
	short s, dn;
	char  auxbuf[121], *devname;
	int   ret_val = 0;
	FILE  *f = NULL;


      *node_no = 0;
	logical_name_end[0] =
	logical_name_start[0] =	device_name[0] = '\0';


	if (stat(file_name, &stat_info) != 0) goto Sortie;
	rtdev = stat_info.st_rdev;
	if ((rtdev >> 8) != SOUND_MAJOR)  goto Sortie;
	*node_no = rtdev;

      s = readlink(file_name, auxbuf, 120);
      if (s > 0) auxbuf[s] = '\0';
          else   strncpy(auxbuf, file_name, 120);

      devname = strrchr(auxbuf, '/');
	if (devname) devname++;
		 else  devname = auxbuf;

      strncpy(device_name, devname, 11);

	s = strlen(pattern);
	if (memcmp(devname, pattern, s) != 0) goto Sortie;
	dn = atoi(devname+s);

	f = fopen("/dev/sndstat", "r");
	if (!f) return 0;

	s = strlen(section_name);
	while ((devname = fgets(auxbuf, 120, f)) != NULL
	       && strncmp(auxbuf, section_name, s) != 0);
	if (devname == NULL) goto Sortie;

	while ((devname = fgets(auxbuf, 120, f)) != NULL)
      {  if (!isdigit(*auxbuf)) goto Sortie;
         if ( dn == atoi(auxbuf)) break;
      }

	strtok(auxbuf, "\t\n\r");
      devname = strchr(auxbuf, ':');
	if (!devname) goto Sortie;

	s = strlen(++devname);

      if (s > 18)
      {  memcpy(logical_name_start, devname, 18);

         if ((dn = s-18) > 18) dn = 18;  s = 18;
	   memcpy(logical_name_end, devname+18, dn);
      }
      else
      {  memcpy(logical_name_start, devname, s);
         dn = 0;
      }

	logical_name_end[dn] = logical_name_start[s] = '\0';;

	ret_val = 1;

Sortie:
	if (f) fclose(f);
      return ret_val;
}

short get_cpu_data(char *cputype, char *cpumodel, double *cpuspeed, double *mips)
{
    FILE *f;
    char buf[20];
    char line[121];
/*    const char *undef = "undef"; */

    if (cputype) strcpy(cputype, "");
    if (cpumodel) strcpy(cpumodel, "");
    *mips = 0;
    if (cpuspeed) *cpuspeed = 0;

    f = fopen("/proc/cpuinfo", "r");
    if (!f) return 0;

    while (fgets(line, 120, f) != NULL)
    {
       if (get_cpu_type(line, "cpu\t\t", cputype))
       { if (strncmp(cputype, "586", 3) == 0)
            strcpy (cputype, "Pentium");
         else
         if (strncmp(cputype, "686", 3) == 0)
            strcpy (cputype, "Pent Pro");
       }
       else
       if (!get_cpu_type(line, "model\t", cpumodel) &&
           !get_cpu_type(line, "model name\t", cpumodel) &&
            cpuspeed && get_cpu_type(line, "cpu MHz\t", buf))
                   *cpuspeed = strtod(buf, NULL);
        else
        if (get_cpu_type(line, "bogomips\t", buf))
                   *mips = strtod(buf, NULL);

    }

    fclose(f);
    return 1;
}

static short get_os_data(char *ostype, char *osversion)
{
    FILE *f;
    char *rv;



    f = fopen("/proc/sys/kernel/ostype", "r");
    if (!f) return 0;
    rv = fgets(ostype, 40, f);
    fclose(f);
    if (rv == NULL) return 0;
    ostype[40] = '\0';
    strtok(ostype, "r\n");


    f = fopen("/proc/sys/kernel/osrelease", "r");
    if (!f) return 0;
    rv = fgets(osversion, 40, f);
    fclose(f);
    if (rv == NULL) return 0;
    osversion[40] = '\0';
    strtok(osversion, "r\n");

    return 1;
}



/* ============================================= */
struct CD_TYPE_DESCR
{
	u_char	major;
	u_char	*descr;
};

struct CD_TYPE_DESCR CDDevices[] =
{	{ SCSI_CDROM_MAJOR, "SCSI CD ROM"},
	{ CDU31A_CDROM_MAJOR, "CDU31A"},
	{ GOLDSTAR_CDROM_MAJOR, "GOLDSTAR"},
	{ OPTICS_CDROM_MAJOR, "OPTICS"},
	{ SANYO_CDROM_MAJOR, "SANYO"},
	{ MITSUMI_X_CDROM_MAJOR, "MITSUMI_X"},
	{ MITSUMI_CDROM_MAJOR, "MITSUMI"},
	{ CDU535_CDROM_MAJOR, "CDU535"},
	{ IDE1_MAJOR, "IDE ATAPI"},
	{ MATSUSHITA_CDROM_MAJOR, "PANASONIC"},
	{ MATSUSHITA_CDROM2_MAJOR, "PANASONIC"},
	{ MATSUSHITA_CDROM3_MAJOR, "PANASONIC"},
	{ MATSUSHITA_CDROM4_MAJOR, "PANASONIC"},
	{ AZTECH_CDROM_MAJOR, "AZTECH"},
	{ CM206_CDROM_MAJOR, "CM206"}
};

static char *get_cd_description(void)
{   int i;
    int sz = sizeof(CDDevices) / sizeof(struct CD_TYPE_DESCR);
    struct CD_TYPE_DESCR *st;

    st = CDDevices;

    for (i=0; i<sz; i++)
    { if (st->major == CDDeviceType)
                return st->descr;
	st++;
    }

    return NULL;
}

static void  put_line(char *line, const char *buf)
{
    int  len = strlen(buf);

    if (len > INFO_LINE_SIZE) len = INFO_LINE_SIZE;
    memcpy (line, buf, len);
    line += len;

    len = INFO_LINE_SIZE - len;
    if (len > 0)
    {  memset(line, ' ', len);
       line += len;
    }

    *line = '\0';
}

static int  update_line(const char *buf, int lineno)
{
    if (lineno >= InfoLineCount) return 0;
    put_line (InfoPages[lineno], buf);
    return 1;
}

static int  commit_line(const char *buf)
{   char *line;
    if (InfoLineCount >= MAX_LINES) return 0;

    line = malloc(INFO_LINE_SIZE +1);
    if (!line) return 0;

    InfoPages[InfoLineCount++] = line;
    put_line(line, buf);
    return 1;
}

/* ================================================== */

static void get_cpu_info(void)
{   char CpuType[11];
    char CpuModel [41];
    char buffer[INFO_LINE_SIZE+1];
    double mips, cpuclock;

    if (get_cpu_data(CpuType, CpuModel, &cpuclock, &mips))
    {  commit_line("CPU");
       if (strlen(CpuType)>0)
       { sprintf (buffer, "    Type:   %-10s", CpuType);
         commit_line(buffer);
       }
       if (strlen(CpuModel)>0)
       {  sprintf (buffer, "    Model:  %-15s", CpuModel);
          commit_line(buffer);
       }
       if (cpuclock > 0)
       {   sprintf(buffer, "    Clock:  %.1f MHz", cpuclock);
           commit_line(buffer);
       }
       if (mips > 0)
       {   sprintf(buffer, "    Speed:  %.1f BogoMIPS", mips);
           commit_line(buffer);
       }
       commit_line(empty);
    }
}

static void get_os_info(void)
{   char OsType[41];
    char OsVersion[41];
    char buffer[81];

    if (get_os_data(OsType, OsVersion))
    {  commit_line("SYSTEM");
	 sprintf (buffer, "    Type:      %s", OsType);
       commit_line(buffer);
	 sprintf (buffer, "    Release:   %s", OsVersion);
       commit_line(buffer);
	 sprintf (buffer, "    Kbd shift: %ssupported",
                  get_kbd_shift() & 0x8000 ? "not " : "");
       commit_line(buffer);
       commit_line(empty);
    }
}

static void get_screen_info(void)
{
    char buffer[121];   /*INFO_LINE_SIZE+1]; */
    char termname[21];

    commit_line("TTY");

    strncpy(termname, cur_term->type.term_names, 20);
    strtok(termname, "|");
    sprintf(buffer,  "    Type:    %s", termname );
    commit_line(buffer);

    sprintf(buffer,  "    Colums:  %d", ScreenW);
    commit_line(buffer);

    sprintf(buffer,  "    Rows:    %d", ScreenH);
    commit_line(buffer);

/*    sprintf(buffer,  "    Colours: %s",
                           AreColours ? "supported" : "not supported");
    commit_line(buffer); */

    commit_line(empty);

}

static void get_cd_info(void)
{
    char buffer[81];
    char auxbuf[81];
    char *descr;
    short s;

    commit_line("CD ROM device");
    sprintf(buffer,  "    Name:   %-20s", CDDeviceName);
    commit_line(buffer);

    s = readlink(CDDeviceName, auxbuf, 40);
    if (s > 0)  auxbuf[s] = '\0';
    else strncpy(auxbuf, CDDeviceName, 40);

    descr = strrchr(auxbuf, '/');
    if (descr) descr++; else descr = auxbuf;
    sprintf(buffer,  "    Device: %s", descr);
    commit_line(buffer);

    sprintf(buffer,  "    Node:   %d-%d",
                           (int)CDDeviceType, CDNodeNumber);
    commit_line(buffer);

    descr = get_cd_description();
    if (descr)
    {  sprintf(buffer,  "    Type:   %s", descr);
	 commit_line(buffer);
    }

/*
    s = cd_check_multisession();
    if (s >= 0)
    {  sprintf (buffer, "    XA disk: %s", s ? yes : no);
	 commit_line(buffer);
    }
*/
    commit_line(empty);
}

static void get_audio_info(void)
{
    char buffer[61];
    char descr1[INFO_LINE_SIZE+1];
    char descr2[INFO_LINE_SIZE+1];
    char devname[21];
    short  node_no;

   commit_line("AUDIO device");
   if (get_audio_name(AudioDeviceName, "dsp", "Audio devices:",
                         devname,   &node_no,  descr1, descr2))
   {
	  sprintf(buffer,  "    Name:   %s", AudioDeviceName);
	  commit_line(buffer);

	  sprintf(buffer,  "    Device: %s", devname);
	  commit_line(buffer);

	  sprintf(buffer,  "    Node:   %d-%d", node_no >> 8, node_no & 255);
	  commit_line(buffer);

	  sprintf(buffer,    "    Type:  %s", descr1);
	  commit_line(buffer);

        if (*descr2)
	  { sprintf(buffer,  "            %s", descr2);
	    commit_line(buffer);
        }
    }
    else
	  commit_line("    Disabled");

    commit_line(empty);
}

static void get_mixer_info(void)
{
    char buffer[61];
    char descr1[INFO_LINE_SIZE+1];
    char descr2[INFO_LINE_SIZE+1];
    char devname[21];
    short  node_no;

   commit_line("MIXER device");
   if (get_audio_name(MixerDeviceName, "mixer", "Mixers:",
                         devname,   &node_no,  descr1, descr2))
   {
	  sprintf(buffer,  "    Name:   %s", MixerDeviceName);
	  commit_line(buffer);

	  sprintf(buffer,  "    Device: %s", devname);
	  commit_line(buffer);

	  sprintf(buffer,  "    Node:   %d-%d", node_no >> 8, node_no & 255);
	  commit_line(buffer);

	  sprintf(buffer,   "    Type:  %s", descr1);
	  commit_line(buffer);

        if (*descr2)
	  { sprintf(buffer, "            %s", descr2);
	    commit_line(buffer);
        }

    }
    else
	  commit_line("    Disabled");

    commit_line(empty);
}

void  get_efficiency(char *buffer)
{
    long period = time(NULL) - TimeStart;

    if (Frames > 0 && period > 0) FramesPerSec = Frames / period;
    				else    FramesPerSec = -1;

    sprintf(buffer, "    Efficiency: %0.1f", FramesPerSec);
}

static void get_program_info(void)
{    char buffer[81];

     commit_line("SADP");
     sprintf(buffer, "    Version:   %d.%d.%d",
             SADP_VERSION >> 16,
            (SADP_VERSION >> 8) & 255, SADP_VERSION & 255);
     commit_line(buffer);
     sprintf(buffer, "    Compiled:  %s", __DATE__);
     commit_line(buffer);
     sprintf(buffer, "               %s", __TIME__);
     commit_line(buffer);
     commit_line(empty);
}

static void get_curses_info(void)
{    char buffer[81];

    commit_line("NCURSES");
#ifdef NCURSES_VERSION
     commit_line("    Compiled with");
     sprintf(buffer, "    version:   %s", NCURSES_VERSION);
     commit_line(buffer);
#endif
    sprintf(buffer,  "    Colours:   %ssupported",
                           AreColours ? "" : "not ");
    commit_line(buffer);
    commit_line(empty);
}

static void get_parameters(void)
{    char buffer [81];
     char dbname[15];

     commit_line("TIME INTERVALS");
     sprintf(buffer, "    Start:        %d sec", TimeoutStart);
     commit_line(buffer);
     sprintf(buffer, "    Reposition:   %d sec", TimeoutRepos);
     commit_line(buffer);
     sprintf(buffer, "    Load tray:    %d sec", TimeoutLoad);
     commit_line(buffer);
     sprintf(buffer, "    Help advance: %d msec", TIME_OUT_HELP_ADVANCE);
     commit_line(buffer);
     sprintf(buffer, "    Intro play:   %d sec", INTRO_DURATION_SEC);
     commit_line(buffer);
     sprintf(buffer, "    Forward/back: %d sec", STEP_DISCRETE);
     commit_line(buffer);
     commit_line(empty);

#ifdef DSP_SUPPORT
     if (FourWndCount > 0)
     { commit_line("SPECTRUM and OSCILLATOR");
       sprintf(buffer, "    Sampling:   %u Hz",  SamplingRate);
       commit_line(buffer);
       sprintf(buffer, "    Windows:    %d", FourWndCount);
       commit_line(buffer);
       sprintf(buffer, "    Interlace:  %d", FourInterlace);
       commit_line(buffer);
       sprintf(buffer, "    Buf size:   %ld", ft_bufsize);
       commit_line(buffer);
       sprintf(buffer, "    Obturation: %d", (int)WaveObturate);
       commit_line(buffer);
       commit_line(empty);
    }
#endif

    commit_line("SUPORTED FEATURES");
    sprintf(buffer, "    SCSI CD:    %s",
#ifdef SCSI_SUPPORT
		"supported"
#else
		"not supported"
#endif
	);
    commit_line(buffer);

    sprintf(buffer, "    UCDROM:     %s",
#ifdef UCDROM_SUPPORT
		"supported"
#else
		"not supported"
#endif
	);
    commit_line(buffer);

    sprintf(buffer, "    DSP:        %s",
#ifdef DSP_SUPPORT
		"supported"
#else
		"not supported"
#endif
	);
    commit_line(buffer);

    sprintf(buffer, "    MIXER:      %s",
#ifdef MIXER_SUPPORT
		"supported"
#else
		"not supported"
#endif
	);
    commit_line(buffer);

    sprintf(buffer, "    GPM:        %s",
#if GPM_SUPPORT
		"supported"
#else
		"not supported"
#endif
	);
    commit_line(buffer);
    commit_line(empty);

    commit_line("OPTIONS");
    sprintf(buffer, "    Probe CD:   %s", ProbeCD ? yes : no);
    commit_line(buffer);
    commit_line    ("    Auto-save");
    sprintf(buffer, "      settings: %s", SaveSet ? yes : no);
    commit_line(buffer);
    sprintf(buffer, "      data:     %s", SaveData ? yes : no);
    commit_line(buffer);
    commit_line(empty);

    commit_line("MISCELLANEOUS");
    sprintf(buffer, "    Char set:   %d [%s]", CharSet, charset_names[CharSet-1]);
    commit_line(buffer);
    strncpy(dbname, ShortDBName, 14);
    sprintf(buffer, "    DB name:    %s", dbname);
    commit_line(buffer);
    sprintf(buffer, "    Mouse:      %s", mouse_names[MouseSupport] );
    commit_line(buffer);
    EfficLineNo = InfoLineCount;
    get_efficiency(buffer);
    commit_line(buffer);
/*    commit_line(empty);	*/

}

void update_info_page(void)
{
    char buffer[51];

    get_efficiency(buffer);
    update_line(buffer, EfficLineNo);
}

int  prepare_info_page(void)
{

    InfoPages = (char **)  malloc((MAX_LINES+1) * sizeof(char *));
    if (!InfoPages) return 0;

    InfoLineCount = 0;

    commit_line("%         ENVIRONMENT");
/*    commit_line("%          ==========="); */
    commit_line(empty);

    get_cpu_info();
    get_screen_info();

    get_cd_info();
    get_audio_info();
    get_mixer_info();

    commit_line("%          SOFTWARE");
    commit_line(empty);
    get_os_info();
    get_program_info();
    get_curses_info();

    commit_line("%          SETTINGS");
/*    commit_line("==========");              */
    commit_line(empty);

    get_parameters();

    InfoPages[InfoLineCount] = NULL;
    InfoPages = realloc(InfoPages, (InfoLineCount +1) * sizeof(char *));

    return InfoPages ? 1 : 0;
}

void release_info_page(void)
{
    char **iptr;
    int i;

    if (!(iptr = InfoPages)) return;

    for (i=0; i<InfoLineCount; i++)
			 free(*iptr++);

    free(InfoPages);

}
