/*  =========================================================
    SING - ALONG DISK PLAYER.
    (C) 1998, 1999   Michael Glickman  xsadp@yahoo.com
    ----------------------------------------------------------
    NOTICE:
          Sing-Along Disk Player is copyrighted by the author.
          See GNU general public licence (GPL) available at
	    ftp://metalab.unc.edu/pub/gnu/COPYING for details
	    and legal issues.

          You are expected to provide appropriate references
          when using a part of the code in your software.

	    Author strongly advices against using this code, or
	    a part of it, in an application designed to run  on
	    any Microsoft(tm) platfrom.
    ========================================================= */
#include <sys/time.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <linux/cdrom.h>
#include "sad.h"
#include "sadp_curses.h"

char  CDDeviceName[81];
char  AudioDeviceName[81];
char  MixerDeviceName[81];

#ifdef DSP_SUPPORT
short   FourWndCount = 2;
#else
short  FourWndCount = 0;
#endif


u_int SamplingRate = 11025u;
short RunBackground;
short QuietMode = 0;
short CharSet = 0;
short BkgrColour = -1, ShadColour = -1, BottomColour=-1;
short FourInterlace = 1;
short FourWndRes = DEFAULT_BAR_WIDTH;
short AutoPlay = DEFAULT_AUTOPLAY;
short LoopPlay = DEFAULT_LOOPPLAY;
short ProbeCD = DEFAULT_PROBE;
short SaveData = DEFAULT_SAVE_DATA;
short SaveSet = DEFAULT_SAVE_SETTINGS;

short WaveObturate = DEFAULT_OBTURATE;
short WaveHRes = DEFAULT_PIX_WIDTH;
short WaveVRes = DEFAULT_PIX_HEIGHT;

int  TimeoutStart = TIME_OUT_START;
int  TimeoutRepos = TIME_OUT_REPOSITION;
int  TimeoutLoad = TIME_OUT_LOAD;
int  DurationIntro = INTRO_DURATION_SEC;
int  DurationAdvance = STEP_DISCRETE;

short OptionsChanged=0;
char  *ShortDBName = DEFAULT_DB_PATH;
char  BkgrColourName[31];
MOUSE_SUPPORT_OPTION MouseSupport = MOUSE_NATIVE;
PLAY_MODE_TYPE  PlayMode = PLAY_NORMAL;
TIME_DISPLAY_MODE_TYPE TimeDisplayMode = DM_ELAPSED;
HEADER_MODE   HeaderMode = HEADER_TRACK;
OPERATION StartOper = OPER_NONE;
PLATFORM  Platform;


long TimeStart;
double Frames;
SPECTR_DISPLAY_MODE SpectrDisplayMode = SDM_MODULUS;

//#define  FRAME_INTERVAL 10000l
//long FrameInterval;

extern short   HelpMode;
extern u_char track_cur;
extern u_char cd_status;
extern char  disc_name[], disc_artist[];
extern short  play_finished;
extern short   new_cd_in_db;


static char *PlayModesFull[] =
	{"NORMAL", "LIST", "RANDOM", "INTRO", "SINGLE"};



void TerminationHandler(int code)
{

    sound_terminate();

    if (code != SIGKILL) cdaudio_deinitialize();

    screen_deinitialize(); 

    if (SaveSet) save_settings();

    if (code == 0)
    { /* if (!RunBackground && ! QuietMode)
			print_epilogue(); */
       exit(0);
    }
    else
       exit(16);
}




int main(int argc, char *argv[])
{
      int    cd_only;
	u_char old_track;
	long timeout;
	char *trk_name;

      Platform = get_platform();
      load_settings();
      if (!process_arguments(argc, argv)) return 16;

      if (AudioDeviceName[0] == '\0') FourWndCount = 0;

      if (StartOper != OPER_NONE) QuietMode = 1;


      RunBackground = ((Platform != PLTF_XFORMS) || QuietMode) &&
                      ((tcgetpgrp (0) != getpid()) || !isatty(0));
      cd_only = RunBackground || QuietMode;

      if (RunBackground || StartOper == OPER_PLAY ||
               (QuietMode && StartOper == OPER_NONE) ) AutoPlay = 1;
      else
      if (StartOper != OPER_NONE) AutoPlay =  0;

      if ( !cdaudio_initialize()
                ||
           (!cd_only &&
		 ( !sound_initialize() || !screen_initialize(argc, argv)))
 	        ||
           !cdaudio_start()
                ||
           (!cd_only && !sound_start())
        )
      {  TerminationHandler(666);
                    return 8;
      }


      signal(SIGTERM, TerminationHandler);
      signal(SIGKILL, TerminationHandler);
      signal(SIGTSTP, SIG_IGN);

      if(StartOper!= OPER_NONE && StartOper != OPER_PLAY)
      {   cdaudio_operate(StartOper);
	    goto FinitaLaComedia;
      }

      if (RunBackground | QuietMode)  goto BackgroundRoutine;

      TimeStart = time(NULL);
      Frames = 0;

	foreground_processing();
	goto FinitaLaComedia;


/* ================================================================ */

BackgroundRoutine:
      if (StartOper == OPER_NONE)
	    printf ("\nSing-Along Disk Player. Version %d.%d.%d (A.C.E '98 - '99)\n",
		SADP_VERSION >> 16, (SADP_VERSION >> 8) & 0xFF, SADP_VERSION & 0xFF);

      check_cd();
      if (cd_status != CDROM_AUDIO_PLAY)
	{  printf ("Could not start play mode (no disk ?)\n\n");
         TerminationHandler(666);
	   return 8;
      }

	if (StartOper != OPER_NONE) goto FinitaLaComedia;

      if (RunBackground && PlayMode == PLAY_NORMAL )
	{
        printf ("Playing in background - no need for further intrusion. Bye-bye.\n\n");
	  goto FinitaLaComedia;
      }

	printf ("Running %s. Play mode - %s%s\n",
		 RunBackground ? "in background" : "low profile",
		 PlayModesFull[PlayMode], LoopPlay ? " LOOP" : "" );
	if (new_cd_in_db == 0)
	{  printf ("Title:  %s\n", disc_name);
	   printf ("Artist: %s\n", disc_artist);
      }

	if (RunBackground)
      {   printf ("Enter 'kill %d' to quit\n", getpid());
	    timeout = 1000000;
      }
	else
	{
          fcntl(fileno(stdin), F_SETFL, O_NONBLOCK);
	    printf ("Enter: n - next, p -prev, q - quit, s - stop and quit\n\n");
	    timeout = 250000;
      }

	old_track = 0xff;

      while (1)
      {
     	    if (!RunBackground)
	    { switch(toupper(getchar()))
		{  case 'S':
		       cdaudio_operate(OPER_STOP);
			 /* Has to go further */

		   case 'Q':
			 goto FinitaLaComedia;

		   case 'N':
		       cdaudio_operate(OPER_NEXT);
			 break;

		   case 'P':
		       cdaudio_operate(OPER_PREV);
			 break;
             }
		 if (track_cur != old_track)
		 {
		   trk_name = new_cd_in_db ? "" :  cdaudio_get_track_name(track_cur);
               printf ("\rPlaying track %d. %s    ", track_cur, trk_name);
		   old_track = track_cur;
             }
          }
	    else	
          if (play_finished) break;

          cdaudio_operate(OPER_NONE);
	    usleep(timeout);

      }


FinitaLaComedia:
	TerminationHandler(0);
	return 0;

}

