/*  ===========================================================
    SING - ALONG DISK PLAYER. 
    (C) 1998, 1999   Michael Glickman  xsadp@yahoo.com
    ----------------------------------------------------------
    NOTICE:
            Sing-Along Disk Player is copyrighted by the author.
            See GNU general public licence (GPL) available at
	    ftp://metalab.unc.edu/pub/gnu/COPYING for details
	    and legal issues.
    
            You are expected to provide appropriate references
            when using a part of the code in your software. 

	    Author strongly advices against using this code, or
	    a part of it, in an application designed to run  on
	    any Microsoft(tm) platfrom.
    ========================================================= */

#include <stdio.h>
#include <fcntl.h>
#include <malloc.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <unistd.h>
#include <curses.h>
#include <string.h>
#include <math.h>
#include "sad.h"

#if defined(MIXER_SUPPORT) || defined(DSP_SUPPORT)
#include <linux/soundcard.h>
#endif

unsigned int stereo = 1;
unsigned short stereo_supported = 1;
extern u_int SamplingRate;  /* 11025, 22050, 44100 */

extern char  AudioDeviceName[81];
extern char  MixerDeviceName[81];
extern short  FourWndCount, FourWndMask;
extern u_char volume_left, volume_right;
extern PLATFORM  Platform;

int audio = -2;				/* /dev/dsp audio file descriptor */
int mixer = -2;				/* /dev/mixer  file descriptor */

#if defined (MIXER_SUPPORT) || defined (DSP_SUPPORT)
static char ErrMes[121];
#endif

u_char MixerCurDevice, MixerCurDevno;
u_int  MixerStereoMask=0, MixerCurDevMask, MixerRecsrc, MixerRecmask;
u_char MixerDeviceCount;
char   MixerSoundDevice[9];
char   volume, balance;

#ifdef MIXER_SUPPORT
static char *mixer_devnames[] = SOUND_DEVICE_LABELS;
/* static u_int MixerRecsrcBackup; */
#endif

#ifdef DSP_SUPPORT
static unsigned int sample_size = 8;


static CPLX *roots=NULL;
static int T, T1;

int abuf_size;					/* audio buffer size for I/O */
signed char *iobuf = NULL;			/* allocated I/O buffer */

int ft_size, first_run = 1;
long ft_bufsize;
CPLX *ft_buffer = NULL;

#endif


struct MIXER_DEVICE_INFO 
{  u_char devno;
   char volume;
   char balance;
} *MixerDevPtr = NULL;


void audio_stop(void);

#ifdef DSP_SUPPORT
static void ft_initialize(int power)
{
   CPLX   root_cur, root_prim;
   double re, im;
   int    t;

   T = 1 << power;
   T1 = T-1;

   roots = malloc(sizeof(CPLX) * T);
   roots[0].r = root_cur.r = 1;  // 256;
   roots[0].i = root_cur.i = 0;

   re = cos(2.*M_PI/T);
   root_prim.r = re;  // * 256;
   root_prim.i = -sqrt(1 - re * re);  // * 256;

   for (t=1; t<T; t++)
   {   roots[t].r = root_cur.r = ((re = root_cur.r) * root_prim.r -
                                  (im = root_cur.i) * root_prim.i);        // 256;
       roots[t].i = root_cur.i = (re * root_prim.i + im * root_prim.r);    // 256;
   }
}


void ft_process(CPLX *spectrum, CPLX signal[], int f)
{  int  t;
   CPLX *cpl;
   double re1, re2, im1, im2;     

    
   spectrum->r = 0;
   spectrum->i = 0;

   for (t = 0; t<T; t++)
   { 
      cpl = signal+t; 
      re1 = cpl->r;  im1 = cpl->i;

      cpl = roots+((f*t) & T1);	
      re2 = cpl->r;  im2 = cpl->i;

	spectrum->r += re1*re2 - im1*im2;
	spectrum->i += re1*im2 + im1*re2;
   }
}

static int dsp_reinitialize(void) {
	unsigned int tmp;

	if (audio == -2) return 0;
	if (audio >= 0) return 1;

	if ( (audio = open(AudioDeviceName,O_RDONLY,0)) < 0 ) {
		char *arg = (Platform == PLTF_XFORMS)? "-noadev" : "-A*";
		sprintf(ErrMes,"Error opening audio-device %s.\n\n"
				"Use %s command line argument \n"
				"        to disable audio support.\n", 
				AudioDeviceName, arg);
		return 0;
	}

        tmp = sample_size;
        if ( ioctl(audio, SNDCTL_DSP_SAMPLESIZE, &sample_size) < 0 ||
                 tmp != sample_size)  {
        	sprintf(ErrMes,"Unable to set audio sample size.");
		goto errxit;
	}


	tmp = stereo;	
	if (ioctl(audio, SNDCTL_DSP_STEREO, &stereo) < 0 
				 || stereo < tmp ) {
		stereo_supported  = 0; 
		stereo = 0;
	}		

	if ( ioctl(audio,SNDCTL_DSP_GETBLKSIZE,&abuf_size) < 0 ) {
		sprintf(ErrMes,"Obtaining dsp buffer size.");
		goto errxit;
	}

	if ( abuf_size <= 0 || abuf_size > 65536 ) {
		sprintf(ErrMes,"Invalid audio buffer size (%d bytes).",(int)abuf_size);
		goto errxit;
	} 
	if (abuf_size < 256) abuf_size = 256;

	if ( ioctl(audio,SNDCTL_DSP_SPEED, &SamplingRate) < 0 ) {
		sprintf(ErrMes,"Unable to set audio sampling rate.");
		goto errxit;
	}
	
	{   int  maxbufsize = (1024 * SamplingRate + 22050) / 44100  ;
           if (!stereo) maxbufsize >>=1 ;

          if (abuf_size > maxbufsize) abuf_size = maxbufsize;

	}

   
	ft_size= 0; tmp = abuf_size;
	while (tmp >>= 1) ft_size++;
	if (ft_size > 10) ft_size = 10;
	if (stereo) ft_size--;
          
     
      ioctl(audio, SNDCTL_DSP_POST, 0); 
	return 1;

errxit:
	return 0;
}
#endif




static int mixer_initialize(void)
{

#ifdef MIXER_SUPPORT
	const char *ReadError = "Error reading mixer settings\n";
	const char *WriteError = "Error changing mixer settings\n";
	const char *NoMem = "Mixer: memory allocation failure\n";
	u_int mixer_devmask, mask;
	u_char i;	
#endif

	u_int  vol, bal;
	int rc = 0;



	MixerDeviceCount = 0;


#ifdef MIXER_SUPPORT
	if (MixerDeviceName[0] == '\0') goto InitIntCD;

	mixer = open(MixerDeviceName, O_RDWR);

/*
      if (mixer < 0)

	{
		sprintf(ErrMes,"Unable to open mixer device %s.\n" 
				   "Use -M* command line argument.", MixerDeviceName);
		goto errxit;
	}
*/

	if (mixer < 0) goto InitIntCD;


      strcpy(ErrMes, ReadError);
      if (ioctl(mixer, SOUND_MIXER_READ_DEVMASK, &mixer_devmask) == -1 ||
          ioctl(mixer, SOUND_MIXER_READ_STEREODEVS, &MixerStereoMask) == -1 ||
          ioctl(mixer, SOUND_MIXER_READ_RECMASK, &MixerRecmask) == -1 ||
          ioctl(mixer, SOUND_MIXER_READ_RECSRC, &MixerRecsrc) == -1)
		         goto errxit;

	if (MixerRecmask & SOUND_MASK_CD )
      { 
/*	   MixerRecsrcBackup = MixerRecsrc;   */
	   MixerRecsrc |= SOUND_MASK_CD;
	   if (ioctl(mixer, SOUND_MIXER_WRITE_RECSRC, &MixerRecsrc) == -1 )
	   {     strcpy(ErrMes, WriteError);
      	   goto errxit;
	   }
      }

	MixerDevPtr = malloc(SOUND_MIXER_NRDEVICES *
					 sizeof(struct MIXER_DEVICE_INFO));
	if (!MixerDevPtr)
      {     strcpy(ErrMes, NoMem);
      	   goto errxit;
      }

      strcpy(ErrMes, ReadError);

	for (i=0, mask=1; i< SOUND_MIXER_NRDEVICES; i++, mask<<=1)
	{
	   if (!(mixer_devmask & mask)) continue;
	   MixerDevPtr[MixerDeviceCount].devno = i;         
   	
	   if (ioctl(mixer, MIXER_READ(i), &vol) == -1)
					goto errxit;
             
	   if (!(MixerStereoMask & mask) || vol == 0)
	   {
	      bal = MAX_BALANCE/2;
	      vol &= 0xff;
         }  	
	   else		
	   {	
	      int volr = vol >> 8;

    	      vol &= 0xff;
	      bal = volr * MAX_BALANCE / (vol + volr);
		if (volr > vol) vol = volr;
	   }
	   	
	   if (vol > MAX_VOLUME) vol = MAX_VOLUME;
         MixerDevPtr[MixerDeviceCount].balance = bal;
	   MixerDevPtr[MixerDeviceCount].volume = vol;

	   MixerDeviceCount++;
	}



InitIntCD:	
#endif


      vol = cd_getvolume();
      if (!vol && !MixerDeviceCount)
      { vol = 1;  volume_right = volume_left = 0; }
      
      if (vol)
      {	    u_int volume_total;

 	    if (!MixerDevPtr)	
 		MixerDevPtr = malloc(sizeof(struct MIXER_DEVICE_INFO));
	
	    bal = 128;
	    volume_total = (u_int) volume_right + (u_int)volume_left;        

	    if (volume_total)
	         bal = (u_int)volume_right * MAX_BALANCE / volume_total;
		
	    vol = (volume_right > volume_left) ? volume_right : volume_left;

	    vol = vol * MAX_VOLUME / 255;
	
	    if (vol > MAX_VOLUME) vol = MAX_VOLUME;
            MixerDevPtr[MixerDeviceCount].balance = bal;
	    MixerDevPtr[MixerDeviceCount].volume = vol;
	    MixerDevPtr[MixerDeviceCount].devno = 255;         

	    MixerDeviceCount++;
      } 



      if (MixerDeviceCount > 0)
      {   MixerDevPtr = realloc(MixerDevPtr,
			 MixerDeviceCount * sizeof(struct MIXER_DEVICE_INFO));	
          rc = 1;
      }
      else
      if (MixerDevPtr)
      {  free(MixerDevPtr);
         MixerDevPtr = NULL;
      } 


#ifdef MIXER_SUPPORT
errxit:
#endif
      return rc;

}

int audio_reinitialize(void)
{    int ret = 1;

#ifdef DSP_SUPPORT
    if (audio < 0) ret = dsp_reinitialize();
#endif

    return ret;
}

int sound_initialize(void) {


	audio = -1;

#ifdef DSP_SUPPORT
      if (FourWndCount >0)
      {
	        int buflen;


	        stereo_supported = stereo = (FourWndCount >= 2) ? 1: 0;
		if (!dsp_reinitialize()) goto errxit;
		FourWndCount = stereo ? 2: 1;

		if ( (iobuf = malloc(abuf_size)) == NULL ) {
			sprintf(ErrMes,"Unable to allocate audio buffer.");
			goto errxit;
		}

		ft_initialize(ft_size);
		ft_bufsize = 1 << ft_size;
		buflen = ft_bufsize;
          	if (stereo) buflen <<= 1;
		ft_buffer = malloc( buflen * sizeof(CPLX));
      }
#endif

	mixer_initialize();

	return 1;

#if defined(DSP_SUPPORT)
errxit:
	fprintf(stderr, "\n%s\n\n", ErrMes);
	sound_terminate();
	return 0;
#endif

}

static int mixer_accept_device(short device)
{ 


	MixerCurDevice = device;

	MixerCurDevno = MixerDevPtr[device].devno;

	if (MixerCurDevno == 255)
	{
		MixerCurDevMask = 0;
		strcpy(MixerSoundDevice, "CDint");
      }


#ifdef MIXER_SUPPORT
	else
	{	short len;

		MixerCurDevMask = 1 << MixerCurDevno;
		strncpy(MixerSoundDevice, 
                     *(mixer_devnames + MixerCurDevno), 9);	

		/* Right trimming */
      	len = strlen(MixerSoundDevice);
	      while(MixerSoundDevice[--len] == ' ');
	      MixerSoundDevice[++len] = '\0';
      }
#endif


	volume  = MixerDevPtr[device].volume;
	balance = MixerDevPtr[device].balance;

	show_volume();
	show_mixer_input();
	show_mixer_device();
	return 1;
}

int mixer_accept_next_device(void)
{  	char newdev;

	if (MixerCurDevice == 255) return 1;
	newdev = MixerCurDevice + 1;
	if (newdev >= MixerDeviceCount) newdev = 0;
 
	return mixer_accept_device(newdev);
} 	   

int mixer_accept_prev_device(void)
{  	char newdev;

	if (MixerCurDevice == 255) return 1;
	newdev = MixerCurDevice - 1;
	if (newdev < 0 ) newdev = MixerDeviceCount - 1;
 
	return mixer_accept_device(newdev);
} 	   



	/*****************************************************
	 * Volume
	 *****************************************************/


void mixer_setvolume(u_int new_volume, u_int new_balance)
{   
    u_int vol, volr;
    short success = 0;


    if (MixerDeviceCount == 0) return;	
    if (new_volume > MAX_VOLUME) new_volume = MAX_VOLUME;	

    if (MixerCurDevMask && !(MixerCurDevMask & MixerStereoMask))
          new_balance = MAX_BALANCE/2;
    else
    if (new_balance > MAX_BALANCE) new_balance =  MAX_BALANCE;	

    if (new_balance < 50)
    {  vol = new_volume;
	 volr = (new_balance * new_volume) / (MAX_BALANCE - new_balance);
    }
    else
    {  volr = new_volume;
	 vol = (MAX_BALANCE - new_balance) * new_volume / new_balance;
    }			



    if (MixerCurDevno == 255)
    {   vol = vol * 255 /MAX_VOLUME;
	  volr = volr * 255 /MAX_VOLUME;
	  if (vol > 255) vol = 255; 
	  if (volr > 255) volr = 255; 
	  success = cd_setvolume(vol, volr);
    } 	 
#ifdef MIXER_SUPPORT
    else		
    {   vol |= (volr << 8);
        success = ( ioctl(mixer, MIXER_WRITE(MixerCurDevno), &vol) != -1);
    }
#endif

    if (success)
    {  MixerDevPtr[MixerCurDevice].volume = volume = new_volume;
	 MixerDevPtr[MixerCurDevice].balance = balance = new_balance;
	 show_volume();
    }

   	    
}

void mixer_changevolume(int volume_inc, int balance_inc)
{  

     int new_volume, new_balance;

     if (MixerDeviceCount == 0) return;	
     new_volume  = (int)volume + volume_inc;
     new_balance = (int)balance + balance_inc; 

     if (new_volume < 0) new_volume = 0;	
     if (new_balance < 0) new_balance = 0;	
   	
     mixer_setvolume((u_int) new_volume, (u_int) new_balance);
}

void mixer_toggleinput(void)
{    

     if (mixer < 0 || !(MixerRecmask & MixerCurDevMask)) return;

#ifdef MIXER_SUPPORT
     {  u_int temp;
        temp = MixerRecsrc ^ MixerCurDevMask;
        ioctl(mixer, SOUND_MIXER_WRITE_RECSRC, &temp);
        if (ioctl(mixer, SOUND_MIXER_READ_RECSRC, &temp) != -1)
			MixerRecsrc = temp;
     }
#endif

     show_mixer_input();
}   

void mixer_deinitialize(void)
{       
    if (MixerDevPtr) free(MixerDevPtr);
    MixerDevPtr = NULL;

    if (mixer >=0) 
    { /*
         if (MixerRecmask & SOUND_MASK_CD) 
            ioctl(mixer, SOUND_MIXER_WRITE_RECSRC, &MixerRecsrcBackup);
      */
         close(mixer);
         mixer = -1;	
    }
}




int sound_start(void)
{ 
	
   if (MixerDeviceCount > 0)
  	 return  mixer_accept_device(0);

   MixerCurDevice = -1;	
   return 1;
}

	/*****************************************************
	 * Record :
	 *****************************************************/

void sound_process(void)
{	

#ifdef DSP_SUPPORT
	int i, j;
      int n=0; 
	int signal;
/*	int volume[2]; */
      audio_buf_info info;
	int increm = (stereo+1);	

      ioctl(audio, SNDCTL_DSP_GETISPACE, &info);

       i= info.fragments+1;
       
	while (--i >= 0) 
        {
	    if ( (n = read(audio,iobuf,abuf_size)) <= 0 ) 
			goto ThatsIt;
        }


/* 
	volume[0] = 0;
	volume[1] = 0;
*/
      for (i=j=0; i<n; i+=increm, j++) 
      {   

         if (FourWndMask & 1)
         {  signal = (int)iobuf[i] + 128; 
            if (j < ft_bufsize)
            {  ft_buffer[j].r = signal;
               ft_buffer[j].i = 0; /* signal1; */
            }
		/*	volume[0] += signal; */
         }

         if (FourWndMask & 2)
         {   signal = (int)iobuf[i+1] + 128;
             if (j < ft_bufsize) 
             {  ft_buffer[j+ft_bufsize].r = signal;
	          ft_buffer[j+ft_bufsize].i = 0; // signal1;
	       }
		/* volume[1] += signal; */
          }
      }

/*
     for (j=0; j<2; j++)
     {   signal = volume[j]*increm/n;
  	   signal = (signal-96)*4;
	   if (signal < 0) signal = 0;
	   if (signal > 255) signal = 255;

	   volume[j] = signal;
    }
*/
    ioctl(audio, SNDCTL_DSP_POST, 0); 
	
ThatsIt:
    draw_spectrum();   

#endif
    return;
}	


void audio_stop(void)
{
#ifdef DSP_SUPPORT
   if (audio >=0) 
    {  int i, sz;

       ioctl(audio, SNDCTL_DSP_RESET, 0); 
       close(audio);
       sz = ft_bufsize;
       if (stereo) sz <<= 1;
       for (i=0; i<sz; i++)
       { ft_buffer[i].r = 0;
         ft_buffer[i].i = 0;
       }		
	 draw_spectrum(); 	 
       audio = -1;
    }
#endif
    return;	
}


	   


	/*************************************************************
	 * Exit :
	 *************************************************************/
void sound_terminate(void)
{	
#ifdef DSP_SUPPORT
	audio_stop();
	if(roots) free(roots);  
	roots = NULL;
  	if (ft_buffer) free(ft_buffer);
  	ft_buffer = NULL;
	   
#endif

#ifdef MIXER_SUPPORT
      if (mixer >=0) mixer_deinitialize();
#endif	
	return;
}



