/* sod2, a player for polychannel .csf music files.
 * Copyright (C) 1995, 1996 Russell Marks. See sod2.c for license details.
 *
 * tune_fft.c - fixed-point integer FFT routines used by tunesam.
 *
 * Yes, integer. Yes, it's GPL'd code. And it's not bloody FORTRAN!
 * So anyone who wants to stick this in a pwetty fft viewer is not only
 * welcome but encouraged. :-) I make no guarantees about the accuracy -
 * I'm no expert on FFTs and just hacked this up after reading how they
 * work - so I may have screwed something up writing it, but it seems to
 * work well enough.
 *
 * -Rus.
 */

/* fixed-point version of floatfft.c - about 20% faster
 * uses only ints, so should be usable even on 486sx's etc.
 * (floatfft.c available on request, BTW)
 */

/* fft routines */


#include <stdio.h>
#include <string.h>
#include <math.h>
#include "tune_fft.h"



fixed re[FFTBUFSIZ],im[FFTBUFSIZ],co[FFTBUFSIZ],si[FFTBUFSIZ];
static double k=2.0*3.1415927/FFTBUFSIZ;
static fixed sq[256];



/* call once, before using any others */
void fftinit()
{
int x;

/* make sin/cos lookup table */
for(x=0;x<FFTBUFSIZ;x++)
  {
  co[x]=FIX_DBL(cos(k*x));
  si[x]=FIX_DBL(sin(k*x));
  }

/* make sqrt lookup table */
for(x=0;x<256;x++)
  {
  sq[x]=FIX_UP(x*x);
  }
}


int fixedsqrt(fixed square)
{
int x;

for(x=1;x<256;x++)
  if(square<sq[x]) return(x-1);
return(255);
}


void inbuf2re(unsigned char *inbuf)
{
int x;

for(x=0;x<FFTBUFSIZ;x++)
  {
  im[x]=0;		/* while we're here... */
  re[x]=FIX_UP((int)inbuf[x]-128)/128;
  }
}


void reim2outbuf(unsigned char *outbuf)
{
int x;
int c;

/* dump re spectrum into output */
for(x=0;x<FFTBUFSIZ;x++)
  {
  c=FIX_DOWN((re[FFTBUFSIZ-1-x]/(1<<(FFTPOWER-7)))+FIX_UP(128));
  if(c>255) c=255;
  if(c<0) c=0;
  outbuf[x]=(unsigned char)c;
  }
}


void freq2outbuf(unsigned char *outbuf)
{
int x;

/* combine real+imag into freq output */
for(x=0;x<FFTBUFSIZ;x++)
  outbuf[x]=(unsigned char)fixedsqrt(FIX_DOWN(re[x]*re[x])+
  					FIX_DOWN(im[x]*im[x]));
}


void fft()
{
int x,y,v,a,b;
int s,t2,d,z,l,i;
fixed f1,f2,p1,p2,p3,p4;
static fixed oldre[FFTBUFSIZ],oldim[FFTBUFSIZ];

for(x=0;x<FFTBUFSIZ;x++)
  {
  oldre[x]=re[x];
  oldim[x]=im[x];
  }

/* bit reversal */
for(x=0;x<FFTBUFSIZ;x++)
  {
  y=0;
  for(v=0;v<FFTPOWER;v++)
    {
    a=(1<<v); b=(1<<(FFTPOWER-1-v));
    y+=b*(x&a)/a;
    }
  re[y]=oldre[x];
  im[y]=oldim[x];
  }

/* the fft */
for(s=0;s<FFTPOWER;s++)
  {
  t2=(1<<s); d=(1<<((FFTPOWER-1)-s));
  for(z=0;z<t2;z++)
    {
    l=d*z;
    for(i=0;i<d;i++)
      {
      a=2*i*t2+z;
      b=a+t2;
      
      f1=re[a]; f2=im[a];
      
      p1=FIX_DOWN(co[l]*re[b]); p2=FIX_DOWN(si[l]*im[b]);
      p3=FIX_DOWN(si[l]*re[b]); p4=FIX_DOWN(co[l]*im[b]);
      
      re[a]=f1+p1-p2; im[a]=f2+p3+p4;
      re[b]=f1-p1+p2; im[b]=f2-p3-p4;
      }
    }
  }
}
