/* tune_fft
 * tune_fft.h - header for tune_fft.c
 */

/* size of FFT input buffer, must be power of 2 */
#define FFTPOWER	10	/* 1024-byte buffer */
#define FFTBUFSIZ	(1<<FFTPOWER)

/* WARNING: this assumes bit shifts work properly for negative numbers.
 * It does with gcc, but I'm not sure about generic K&R or ANSI.
 * You could change the bit shifts to mult and div if you're suspicious.
 */
typedef int fixed;

#ifdef BROKEN_NEGATIVE_BITSHIFT
#define FIX_UP(x)	((x)*1024)
#define FIX_DOWN(x)	((x)/1024)
#else
#define FIX_UP(x)	((x)<<10)	/* move from int to fixed (x1024) */
#define FIX_DOWN(x)	((x)>>10)	/* move from fixed to int */
#endif

/* move from double/float to fixed */
#define FIX_DBL(x)	((fixed)((x)*1024.0+0.5))

extern void fftinit();
extern void inbuf2re(unsigned char *inbuf);
extern void reim2outbuf(unsigned char *outbuf);
extern void freq2outbuf(unsigned char *outbuf);
extern void fft();
